/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.hjq.bar.ITitleBarStyle;
import com.hjq.bar.OnTitleBarListener;
import com.hjq.bar.R;
import com.hjq.bar.ViewBuilder;
import com.hjq.bar.style.TitleBarLightStyle;
import com.hjq.bar.style.TitleBarNightStyle;
import com.hjq.bar.style.TitleBarTransparentStyle;

public class TitleBar
extends FrameLayout
implements View.OnClickListener,
Runnable {
    private static ITitleBarStyle sDefaultStyle;
    private OnTitleBarListener mListener;
    private LinearLayout mMainLayout;
    private TextView mLeftView;
    private TextView mTitleView;
    private TextView mRightView;
    private View mLineView;

    public TitleBar(Context context) {
        this(context, null, 0);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
        this.initStyle(attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE || View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthMeasureSpec, (int)0x40000000);
        }
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE || View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
            Drawable background;
            int titleBarHeight = sDefaultStyle.getTitleBarHeight();
            if (titleBarHeight <= 0) {
                titleBarHeight = ViewBuilder.getActionBarHeight(this.getContext());
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)titleBarHeight, (int)0x40000000);
            }
            if ((background = this.getBackground()) instanceof BitmapDrawable) {
                this.mMainLayout.getLayoutParams().height = View.MeasureSpec.getSize((int)heightMeasureSpec);
                double ratio = (double)View.MeasureSpec.getSize((int)widthMeasureSpec) / (double)background.getIntrinsicWidth();
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)(ratio * (double)background.getIntrinsicHeight())), (int)0x40000000);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void initView(Context context) {
        ViewBuilder builder = new ViewBuilder(context);
        this.mMainLayout = builder.getMainLayout();
        this.mLineView = builder.getLineView();
        this.mTitleView = builder.getTitleView();
        this.mLeftView = builder.getLeftView();
        this.mRightView = builder.getRightView();
        this.mLeftView.setEnabled(false);
        this.mTitleView.setEnabled(false);
        this.mRightView.setEnabled(false);
        this.mMainLayout.addView((View)this.mLeftView);
        this.mMainLayout.addView((View)this.mTitleView);
        this.mMainLayout.addView((View)this.mRightView);
        this.addView((View)this.mMainLayout, 0);
        this.addView(this.mLineView, 1);
    }

    private void initStyle(AttributeSet attrs) {
        CharSequence label;
        ITitleBarStyle style;
        if (sDefaultStyle == null) {
            sDefaultStyle = new TitleBarLightStyle(this.getContext());
        }
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.TitleBar);
        switch (array.getInt(R.styleable.TitleBar_barStyle, 0)) {
            case 16: {
                style = new TitleBarLightStyle(this.getContext());
                break;
            }
            case 32: {
                style = new TitleBarNightStyle(this.getContext());
                break;
            }
            case 48: {
                style = new TitleBarTransparentStyle(this.getContext());
                break;
            }
            default: {
                style = sDefaultStyle;
            }
        }
        if (array.hasValue(R.styleable.TitleBar_leftTitle)) {
            this.setLeftTitle(array.getString(R.styleable.TitleBar_leftTitle));
        }
        if (array.hasValue(R.styleable.TitleBar_title)) {
            this.setTitle(array.getString(R.styleable.TitleBar_title));
        } else if (this.getContext() instanceof Activity && (label = ViewBuilder.getActivityLabel((Activity)this.getContext())) != null && !"".equals(label.toString())) {
            this.setTitle(label);
        }
        if (array.hasValue(R.styleable.TitleBar_rightTitle)) {
            this.setRightTitle(array.getString(R.styleable.TitleBar_rightTitle));
        }
        if (array.hasValue(R.styleable.TitleBar_leftIcon)) {
            this.setLeftIcon(this.getContext().getResources().getDrawable(array.getResourceId(R.styleable.TitleBar_leftIcon, 0)));
        } else if (array.getBoolean(R.styleable.TitleBar_backButton, style.getBackIcon() != null)) {
            this.setLeftIcon(style.getBackIcon());
        }
        if (array.hasValue(R.styleable.TitleBar_rightIcon)) {
            this.setRightIcon(this.getContext().getResources().getDrawable(array.getResourceId(R.styleable.TitleBar_rightIcon, 0)));
        }
        this.setLeftColor(array.getColor(R.styleable.TitleBar_leftColor, style.getLeftColor()));
        this.setTitleColor(array.getColor(R.styleable.TitleBar_titleColor, style.getTitleColor()));
        this.setRightColor(array.getColor(R.styleable.TitleBar_rightColor, style.getRightColor()));
        this.setLeftSize(0, array.getDimensionPixelSize(R.styleable.TitleBar_leftSize, (int)style.getLeftSize()));
        this.setTitleSize(0, array.getDimensionPixelSize(R.styleable.TitleBar_titleSize, (int)style.getTitleSize()));
        this.setRightSize(0, array.getDimensionPixelSize(R.styleable.TitleBar_rightSize, (int)style.getRightSize()));
        if (array.hasValue(R.styleable.TitleBar_leftBackground)) {
            this.setLeftBackground(array.getDrawable(R.styleable.TitleBar_leftBackground));
        } else {
            this.setLeftBackground(style.getLeftBackground());
        }
        if (array.hasValue(R.styleable.TitleBar_rightBackground)) {
            this.setRightBackground(array.getDrawable(R.styleable.TitleBar_rightBackground));
        } else {
            this.setRightBackground(style.getRightBackground());
        }
        if (array.hasValue(R.styleable.TitleBar_lineColor)) {
            this.setLineDrawable(array.getDrawable(R.styleable.TitleBar_lineColor));
        } else {
            this.setLineDrawable(style.getLineDrawable());
        }
        this.setLineVisible(array.getBoolean(R.styleable.TitleBar_lineVisible, style.isLineVisible()));
        this.setLineSize(array.getDimensionPixelSize(R.styleable.TitleBar_lineSize, style.getLineSize()));
        array.recycle();
        if (this.getBackground() == null) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.setBackground(style.getBackground());
            } else {
                this.setBackgroundDrawable(style.getBackground());
            }
        }
    }

    @Override
    public void run() {
        int rightSize;
        int leftSize = this.mLeftView.getWidth();
        if (leftSize != (rightSize = this.mRightView.getWidth())) {
            if (leftSize > rightSize) {
                this.mTitleView.setPadding(0, 0, leftSize - rightSize, 0);
            } else {
                this.mTitleView.setPadding(rightSize - leftSize, 0, 0, 0);
            }
        }
        this.mLeftView.setEnabled(!"".equals(this.mLeftView.getText().toString()) || ViewBuilder.hasCompoundDrawables(this.mLeftView));
        this.mTitleView.setEnabled(!"".equals(this.mTitleView.getText().toString()) || ViewBuilder.hasCompoundDrawables(this.mTitleView));
        this.mRightView.setEnabled(!"".equals(this.mRightView.getText().toString()) || ViewBuilder.hasCompoundDrawables(this.mRightView));
    }

    public void onClick(View v) {
        if (this.getOnTitleBarListener() == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.bar_id_left_view) {
            this.getOnTitleBarListener().onLeftClick(v);
        } else if (id2 == R.id.bar_id_title_view) {
            this.getOnTitleBarListener().onTitleClick(v);
        } else if (id2 == R.id.bar_id_right_view) {
            this.getOnTitleBarListener().onRightClick(v);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mTitleView.setOnClickListener((View.OnClickListener)this);
        this.mLeftView.setOnClickListener((View.OnClickListener)this);
        this.mRightView.setOnClickListener((View.OnClickListener)this);
    }

    protected void onDetachedFromWindow() {
        this.mTitleView.setOnClickListener(null);
        this.mLeftView.setOnClickListener(null);
        this.mRightView.setOnClickListener(null);
        super.onDetachedFromWindow();
    }

    public OnTitleBarListener getOnTitleBarListener() {
        return this.mListener;
    }

    public void setOnTitleBarListener(OnTitleBarListener l) {
        this.mListener = l;
    }

    public CharSequence getTitle() {
        return this.mTitleView.getText();
    }

    public void setTitle(int stringId) {
        this.setTitle(this.getResources().getString(stringId));
    }

    public void setTitle(CharSequence text) {
        this.mTitleView.setText(text);
        this.post(this);
    }

    public void setLeftTitle(int stringId) {
        this.setLeftTitle(this.getResources().getString(stringId));
    }

    public void setLeftTitle(CharSequence text) {
        this.mLeftView.setText(text);
        this.post(this);
    }

    public void setRightTitle(int stringId) {
        this.setRightTitle(this.getResources().getString(stringId));
    }

    public void setRightTitle(CharSequence text) {
        this.mRightView.setText(text);
        this.post(this);
    }

    public void setLeftIcon(int iconId) {
        if (iconId > 0) {
            this.setLeftIcon(this.getContext().getResources().getDrawable(iconId));
        }
    }

    public void setLeftIcon(Drawable drawable2) {
        this.mLeftView.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
        this.post(this);
    }

    public void setRightIcon(int iconId) {
        if (iconId > 0) {
            this.setRightIcon(this.getContext().getResources().getDrawable(iconId));
        }
    }

    public void setRightIcon(Drawable drawable2) {
        this.mRightView.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
        this.post(this);
    }

    public void setTitleColor(int color) {
        this.mTitleView.setTextColor(color);
    }

    public void setLeftColor(int color) {
        this.mLeftView.setTextColor(color);
    }

    public void setRightColor(int color) {
        this.mRightView.setTextColor(color);
    }

    public void setLeftBackground(int bgId) {
        if (bgId > 0) {
            this.mLeftView.setBackgroundResource(bgId);
        }
    }

    public void setLeftBackground(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mLeftView.setBackground(drawable2);
        } else {
            this.mLeftView.setBackgroundDrawable(drawable2);
        }
        this.post(this);
    }

    public void setRightBackground(int bgId) {
        if (bgId > 0) {
            this.mRightView.setBackgroundResource(bgId);
        }
    }

    public void setRightBackground(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mRightView.setBackground(drawable2);
        } else {
            this.mRightView.setBackgroundDrawable(drawable2);
        }
        this.post(this);
    }

    public void setLeftSize(int unit, float size) {
        this.mLeftView.setTextSize(unit, size);
        this.post(this);
    }

    public void setTitleSize(int unit, float size) {
        this.mTitleView.setTextSize(unit, size);
        this.post(this);
    }

    public void setRightSize(int unit, float size) {
        this.mRightView.setTextSize(unit, size);
        this.post(this);
    }

    public void setLineVisible(boolean visible) {
        this.mLineView.setVisibility(visible ? 0 : 8);
    }

    public void setLineColor(int color) {
        this.setLineDrawable((Drawable)new ColorDrawable(color));
    }

    public void setLineDrawable(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mLineView.setBackground(drawable2);
        } else {
            this.mLineView.setBackgroundDrawable(drawable2);
        }
    }

    public void setLineSize(int size) {
        ViewGroup.LayoutParams layoutParams = this.mLineView.getLayoutParams();
        layoutParams.height = size;
        this.mLineView.setLayoutParams(layoutParams);
    }

    public LinearLayout getMainLayout() {
        return this.mMainLayout;
    }

    public TextView getLeftView() {
        return this.mLeftView;
    }

    public TextView getTitleView() {
        return this.mTitleView;
    }

    public TextView getRightView() {
        return this.mRightView;
    }

    public View getLineView() {
        return this.mLineView;
    }

    public static void initStyle(ITitleBarStyle style) {
        sDefaultStyle = style;
    }
}

