/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.hjq.bar.R;

final class ViewBuilder {
    private LinearLayout mMainLayout;
    private TextView mLeftView;
    private TextView mTitleView;
    private TextView mRightView;
    private View mLineView;

    ViewBuilder(Context context) {
        this.mMainLayout = new LinearLayout(context);
        this.mMainLayout.setId(R.id.bar_id_main_layout);
        this.mMainLayout.setOrientation(0);
        this.mMainLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mLeftView = new TextView(context);
        this.mLeftView.setId(R.id.bar_id_left_view);
        this.mLeftView.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
        this.mLeftView.setPadding(ViewBuilder.dp2px(context, 15.0f), 0, ViewBuilder.dp2px(context, 15.0f), 0);
        this.mLeftView.setCompoundDrawablePadding(ViewBuilder.dp2px(context, 5.0f));
        this.mLeftView.setGravity(16);
        this.mLeftView.setSingleLine();
        this.mLeftView.setEllipsize(TextUtils.TruncateAt.END);
        this.mLeftView.setEnabled(false);
        this.mTitleView = new TextView(context);
        this.mTitleView.setId(R.id.bar_id_title_view);
        LinearLayout.LayoutParams titleParams = new LinearLayout.LayoutParams(1, -1);
        titleParams.weight = 1.0f;
        titleParams.leftMargin = ViewBuilder.dp2px(context, 10.0f);
        titleParams.rightMargin = ViewBuilder.dp2px(context, 10.0f);
        this.mTitleView.setLayoutParams((ViewGroup.LayoutParams)titleParams);
        this.mTitleView.setGravity(17);
        this.mTitleView.setSingleLine();
        this.mTitleView.setEllipsize(TextUtils.TruncateAt.END);
        this.mTitleView.setEnabled(false);
        this.mRightView = new TextView(context);
        this.mRightView.setId(R.id.bar_id_right_view);
        this.mRightView.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
        this.mRightView.setPadding(ViewBuilder.dp2px(context, 15.0f), 0, ViewBuilder.dp2px(context, 15.0f), 0);
        this.mRightView.setCompoundDrawablePadding(ViewBuilder.dp2px(context, 5.0f));
        this.mRightView.setGravity(16);
        this.mRightView.setSingleLine();
        this.mRightView.setEllipsize(TextUtils.TruncateAt.END);
        this.mRightView.setEnabled(false);
        this.mLineView = new View(context);
        this.mLineView.setId(R.id.bar_id_line_view);
        FrameLayout.LayoutParams lineParams = new FrameLayout.LayoutParams(-1, 1);
        lineParams.gravity = 80;
        this.mLineView.setLayoutParams((ViewGroup.LayoutParams)lineParams);
    }

    LinearLayout getMainLayout() {
        return this.mMainLayout;
    }

    View getLineView() {
        return this.mLineView;
    }

    TextView getLeftView() {
        return this.mLeftView;
    }

    TextView getTitleView() {
        return this.mTitleView;
    }

    TextView getRightView() {
        return this.mRightView;
    }

    static int getActionBarHeight(Context context) {
        if (Build.VERSION.SDK_INT >= 11) {
            TypedArray ta = context.obtainStyledAttributes(new int[]{16843499});
            int actionBarSize = (int)ta.getDimension(0, 0.0f);
            ta.recycle();
            return actionBarSize;
        }
        return ViewBuilder.dp2px(context, 100.0f);
    }

    static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    static boolean hasCompoundDrawables(TextView view) {
        Drawable[] drawables = view.getCompoundDrawables();
        if (drawables != null) {
            for (Drawable drawable2 : drawables) {
                if (drawable2 == null) continue;
                return true;
            }
        }
        return false;
    }
}

