/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.hjq.bar.ITitleBarStyle;
import com.hjq.bar.OnTitleBarListener;
import com.hjq.bar.R;
import com.hjq.bar.ViewBuilder;
import com.hjq.bar.style.TitleBarLightStyle;

public class TitleBar
extends FrameLayout
implements View.OnClickListener,
Runnable {
    private static ITitleBarStyle sDefaultStyle;
    private OnTitleBarListener mListener;
    private LinearLayout mMainLayout;
    private TextView mLeftView;
    private TextView mTitleView;
    private TextView mRightView;
    private View mLineView;

    public TitleBar(Context context) {
        this(context, null, 0);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
        this.initStyle(attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE || View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthMeasureSpec, (int)0x40000000);
        }
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE || View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
            Drawable background;
            int titleBarHeight = sDefaultStyle.getTitleBarHeight();
            if (titleBarHeight <= 0) {
                titleBarHeight = ViewBuilder.getActionBarHeight(this.getContext());
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)titleBarHeight, (int)0x40000000);
            }
            if ((background = this.getBackground()) instanceof BitmapDrawable) {
                this.mMainLayout.getLayoutParams().height = heightMeasureSpec;
                double ratio = (double)View.MeasureSpec.getSize((int)widthMeasureSpec) / (double)background.getIntrinsicWidth();
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)(ratio * (double)background.getIntrinsicHeight())), (int)0x40000000);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void initView(Context context) {
        ViewBuilder builder = new ViewBuilder(context);
        this.mMainLayout = builder.getMainLayout();
        this.mLineView = builder.getLineView();
        this.mTitleView = builder.getTitleView();
        this.mLeftView = builder.getLeftView();
        this.mRightView = builder.getRightView();
        this.mMainLayout.addView((View)this.mLeftView);
        this.mMainLayout.addView((View)this.mTitleView);
        this.mMainLayout.addView((View)this.mRightView);
        this.addView((View)this.mMainLayout, 0);
        this.addView(this.mLineView, 1);
    }

    private void initStyle(AttributeSet attrs) {
        CharSequence label;
        TypedArray ta;
        if (sDefaultStyle == null) {
            sDefaultStyle = new TitleBarLightStyle();
        }
        if ((ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.TitleBar)).hasValue(R.styleable.TitleBar_title_left)) {
            this.setLeftTitle(ta.getString(R.styleable.TitleBar_title_left));
        }
        if (ta.hasValue(R.styleable.TitleBar_title)) {
            this.setTitle(ta.getString(R.styleable.TitleBar_title));
        } else if (this.getContext() instanceof Activity && (label = ((Activity)this.getContext()).getTitle()) != null && !label.toString().equals("")) {
            try {
                PackageManager packageManager = this.getContext().getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(this.getContext().getPackageName(), 0);
                if (!label.toString().equals(packageInfo.applicationInfo.loadLabel(packageManager).toString())) {
                    this.setTitle(label);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        if (ta.hasValue(R.styleable.TitleBar_title_right)) {
            this.setRightTitle(ta.getString(R.styleable.TitleBar_title_right));
        }
        if (ta.hasValue(R.styleable.TitleBar_icon_left)) {
            this.setLeftIcon(this.getContext().getResources().getDrawable(ta.getResourceId(R.styleable.TitleBar_icon_left, 0)));
        } else if (ta.getBoolean(R.styleable.TitleBar_icon_back, true)) {
            this.setLeftIcon(this.getContext().getResources().getDrawable(sDefaultStyle.getBackIconResource()));
        }
        if (ta.hasValue(R.styleable.TitleBar_icon_right)) {
            this.setRightIcon(this.getContext().getResources().getDrawable(ta.getResourceId(R.styleable.TitleBar_icon_right, 0)));
        }
        this.mLeftView.setTextColor(ta.getColor(R.styleable.TitleBar_color_left, sDefaultStyle.getLeftViewColor()));
        this.mTitleView.setTextColor(ta.getColor(R.styleable.TitleBar_color_title, sDefaultStyle.getTitleViewColor()));
        this.mRightView.setTextColor(ta.getColor(R.styleable.TitleBar_color_right, sDefaultStyle.getRightViewColor()));
        this.mLeftView.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.TitleBar_size_left, ViewBuilder.sp2px(this.getContext(), sDefaultStyle.getLeftViewSize())));
        this.mTitleView.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.TitleBar_size_title, ViewBuilder.sp2px(this.getContext(), sDefaultStyle.getTitleViewSize())));
        this.mRightView.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.TitleBar_size_right, ViewBuilder.sp2px(this.getContext(), sDefaultStyle.getRightViewSize())));
        this.mLeftView.setBackgroundResource(ta.getResourceId(R.styleable.TitleBar_background_left, sDefaultStyle.getLeftViewBackground()));
        this.mRightView.setBackgroundResource(ta.getResourceId(R.styleable.TitleBar_background_right, sDefaultStyle.getRightViewBackground()));
        this.mLineView.setVisibility(ta.getBoolean(R.styleable.TitleBar_line, sDefaultStyle.getLineVisibility()) ? 0 : 8);
        this.mLineView.setBackgroundColor(ta.getColor(R.styleable.TitleBar_color_line, sDefaultStyle.getLineBackgroundColor()));
        ta.recycle();
        if (this.getBackground() == null) {
            this.setBackgroundColor(sDefaultStyle.getBackgroundColor());
        }
    }

    @Override
    public void run() {
        int rightSize;
        int leftSize = this.mLeftView.getWidth();
        if (leftSize != (rightSize = this.mRightView.getWidth())) {
            if (leftSize > rightSize) {
                this.mTitleView.setPadding(0, 0, leftSize - rightSize, 0);
            } else {
                this.mTitleView.setPadding(rightSize - leftSize, 0, 0, 0);
            }
        }
        if (!"".equals(this.mLeftView.getText().toString()) || ViewBuilder.hasCompoundDrawables(this.mLeftView)) {
            this.mLeftView.setEnabled(true);
        }
        if (!"".equals(this.mTitleView.getText().toString()) || ViewBuilder.hasCompoundDrawables(this.mTitleView)) {
            this.mTitleView.setEnabled(true);
        }
        if (!"".equals(this.mRightView.getText().toString()) || ViewBuilder.hasCompoundDrawables(this.mRightView)) {
            this.mRightView.setEnabled(true);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mTitleView.setOnClickListener((View.OnClickListener)this);
        this.mLeftView.setOnClickListener((View.OnClickListener)this);
        this.mRightView.setOnClickListener((View.OnClickListener)this);
    }

    protected void onDetachedFromWindow() {
        this.mTitleView.setOnClickListener(null);
        this.mLeftView.setOnClickListener(null);
        this.mRightView.setOnClickListener(null);
        super.onDetachedFromWindow();
    }

    public void onClick(View v) {
        if (this.getOnTitleBarListener() == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.bar_id_left_view) {
            this.getOnTitleBarListener().onLeftClick(v);
        } else if (id2 == R.id.bar_id_title_view) {
            this.getOnTitleBarListener().onTitleClick(v);
        } else if (id2 == R.id.bar_id_right_view) {
            this.getOnTitleBarListener().onRightClick(v);
        }
    }

    public OnTitleBarListener getOnTitleBarListener() {
        return this.mListener;
    }

    public void setOnTitleBarListener(OnTitleBarListener l) {
        this.mListener = l;
    }

    public CharSequence getTitle() {
        return this.mTitleView.getText();
    }

    public void setTitle(CharSequence text) {
        this.mTitleView.setText(text);
        this.postDelayed(this, 100L);
    }

    public void setLeftTitle(CharSequence text) {
        this.mLeftView.setText(text);
        this.postDelayed(this, 100L);
    }

    public void setRightTitle(CharSequence text) {
        this.mRightView.setText(text);
        this.postDelayed(this, 100L);
    }

    public void setLeftIcon(Drawable drawable2) {
        this.mLeftView.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
        this.postDelayed(this, 100L);
    }

    public void setRightIcon(Drawable drawable2) {
        this.mRightView.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
        this.postDelayed(this, 100L);
    }

    public LinearLayout getMainLayout() {
        return this.mMainLayout;
    }

    public TextView getLeftView() {
        return this.mLeftView;
    }

    public TextView getTitleView() {
        return this.mTitleView;
    }

    public TextView getRightView() {
        return this.mRightView;
    }

    public View getLineView() {
        return this.mLineView;
    }

    public static void initStyle(ITitleBarStyle style) {
        sDefaultStyle = style;
    }
}

