/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar.style;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import com.hjq.bar.ITitleBarStyle;
import com.hjq.bar.TitleBarSupport;

public abstract class CommonBarStyle
implements ITitleBarStyle {
    @Override
    public TextView createTitleView(Context context) {
        TextView titleView = this.newTitleView(context);
        titleView.setGravity(16);
        titleView.setFocusable(true);
        titleView.setSingleLine();
        titleView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        titleView.setMarqueeRepeatLimit(-1);
        titleView.setSelected(true);
        return titleView;
    }

    public TextView newTitleView(Context context) {
        return new TextView(context);
    }

    @Override
    public TextView createLeftView(Context context) {
        TextView leftView = this.newLeftView(context);
        leftView.setGravity(16);
        leftView.setFocusable(true);
        leftView.setSingleLine();
        leftView.setEllipsize(TextUtils.TruncateAt.END);
        return leftView;
    }

    public TextView newLeftView(Context context) {
        return new TextView(context);
    }

    @Override
    public TextView createRightView(Context context) {
        TextView rightView = this.newRightView(context);
        rightView.setGravity(16);
        rightView.setFocusable(true);
        rightView.setSingleLine();
        rightView.setEllipsize(TextUtils.TruncateAt.END);
        return rightView;
    }

    public TextView newRightView(Context context) {
        return new TextView(context);
    }

    @Override
    public View createLineView(Context context) {
        return new View(context);
    }

    @Override
    public Drawable getLeftTitleForeground(Context context) {
        return null;
    }

    @Override
    public Drawable getRightTitleForeground(Context context) {
        return null;
    }

    @Override
    public int getLeftHorizontalPadding(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Override
    public int getTitleHorizontalPadding(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)0.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Override
    public int getRightHorizontalPadding(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Override
    public int getChildVerticalPadding(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Override
    public CharSequence getTitle(Context context) {
        if (!(context instanceof Activity)) {
            return "";
        }
        CharSequence label = ((Activity)context).getTitle();
        if (TextUtils.isEmpty((CharSequence)label)) {
            return "";
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            if (!label.toString().equals(packageInfo.applicationInfo.loadLabel(packageManager).toString())) {
                return label;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return "";
    }

    @Override
    public CharSequence getLeftTitle(Context context) {
        return "";
    }

    @Override
    public CharSequence getRightTitle(Context context) {
        return "";
    }

    @Override
    public float getTitleSize(Context context) {
        return TypedValue.applyDimension((int)2, (float)16.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Override
    public float getLeftTitleSize(Context context) {
        return TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Override
    public float getRightTitleSize(Context context) {
        return TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Override
    public Typeface getTitleTypeface(Context context, int style2) {
        return TitleBarSupport.getTextTypeface(style2);
    }

    @Override
    public Typeface getLeftTitleTypeface(Context context, int style2) {
        return TitleBarSupport.getTextTypeface(style2);
    }

    @Override
    public Typeface getRightTitleTypeface(Context context, int style2) {
        return TitleBarSupport.getTextTypeface(style2);
    }

    @Override
    public int getTitleStyle(Context context) {
        return 0;
    }

    @Override
    public int getLeftTitleStyle(Context context) {
        return 0;
    }

    @Override
    public int getRightTitleStyle(Context context) {
        return 0;
    }

    @Override
    public int getTitleIconGravity(Context context) {
        return 0x800005;
    }

    @Override
    public int getLeftIconGravity(Context context) {
        return 0x800003;
    }

    @Override
    public int getRightIconGravity(Context context) {
        return 0x800005;
    }

    @Override
    public int getTitleIconPadding(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Override
    public int getLeftIconPadding(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Override
    public int getRightIconPadding(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Override
    public int getTitleIconWidth(Context context) {
        return 0;
    }

    @Override
    public int getLeftIconWidth(Context context) {
        return 0;
    }

    @Override
    public int getRightIconWidth(Context context) {
        return 0;
    }

    @Override
    public int getTitleIconHeight(Context context) {
        return 0;
    }

    @Override
    public int getLeftIconHeight(Context context) {
        return 0;
    }

    @Override
    public int getRightIconHeight(Context context) {
        return 0;
    }

    @Override
    public boolean isLineVisible(Context context) {
        return true;
    }

    @Override
    public int getLineSize(Context context) {
        return 1;
    }
}

