/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.hjq.bar.ITitleBarStyle;
import com.hjq.bar.OnTitleBarListener;
import com.hjq.bar.R;
import com.hjq.bar.TitleBarSupport;
import com.hjq.bar.style.LightBarStyle;
import com.hjq.bar.style.NightBarStyle;
import com.hjq.bar.style.RippleBarStyle;
import com.hjq.bar.style.TransparentBarStyle;

public class TitleBar
extends FrameLayout
implements View.OnClickListener,
View.OnLayoutChangeListener {
    private static final String LOG_TAG = "TitleBar";
    private static ITitleBarStyle sGlobalStyle;
    private final ITitleBarStyle mCurrentStyle;
    private OnTitleBarListener mListener;
    private final TextView mLeftView;
    private final TextView mTitleView;
    private final TextView mRightView;
    private final View mLineView;
    private int mLeftHorizontalPadding;
    private int mTitleHorizontalPadding;
    private int mRightHorizontalPadding;
    private int mVerticalPadding;
    private int mLeftIconWidth;
    private int mLeftIconHeight;
    private int mTitleIconWidth;
    private int mTitleIconHeight;
    private int mRightIconWidth;
    private int mRightIconHeight;
    private int mLeftIconGravity;
    private int mTitleIconGravity;
    private int mRightIconGravity;
    private int mLeftIconTint;
    private int mTitleIconTint;
    private int mRightIconTint = 0;

    public TitleBar(Context context) {
        this(context, null);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (sGlobalStyle == null) {
            sGlobalStyle = new LightBarStyle();
        }
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.TitleBar, 0, R.style.TitleBarStyle);
        switch (array.getInt(R.styleable.TitleBar_barStyle, 0)) {
            case 16: {
                this.mCurrentStyle = new LightBarStyle();
                break;
            }
            case 32: {
                this.mCurrentStyle = new NightBarStyle();
                break;
            }
            case 48: {
                this.mCurrentStyle = new TransparentBarStyle();
                break;
            }
            case 64: {
                this.mCurrentStyle = new RippleBarStyle();
                break;
            }
            default: {
                this.mCurrentStyle = sGlobalStyle;
            }
        }
        this.mTitleView = this.mCurrentStyle.createTitleView(context);
        this.mLeftView = this.mCurrentStyle.createLeftView(context);
        this.mRightView = this.mCurrentStyle.createRightView(context);
        this.mLineView = this.mCurrentStyle.createLineView(context);
        this.mTitleView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 1));
        this.mLeftView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 0x800003));
        this.mRightView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 0x800005));
        this.mLineView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.mCurrentStyle.getLineSize(context), 80));
        this.setTitleIconGravity(array.getInt(R.styleable.TitleBar_titleIconGravity, this.mCurrentStyle.getTitleIconGravity(context)));
        this.setLeftIconGravity(array.getInt(R.styleable.TitleBar_leftIconGravity, this.mCurrentStyle.getLeftIconGravity(context)));
        this.setRightIconGravity(array.getInt(R.styleable.TitleBar_rightIconGravity, this.mCurrentStyle.getRightIconGravity(context)));
        this.setTitleIconSize(array.getDimensionPixelSize(R.styleable.TitleBar_titleIconWidth, this.mCurrentStyle.getTitleIconWidth(context)), array.getDimensionPixelSize(R.styleable.TitleBar_titleIconHeight, this.mCurrentStyle.getTitleIconHeight(context)));
        this.setLeftIconSize(array.getDimensionPixelSize(R.styleable.TitleBar_leftIconWidth, this.mCurrentStyle.getLeftIconWidth(context)), array.getDimensionPixelSize(R.styleable.TitleBar_leftIconHeight, this.mCurrentStyle.getLeftIconHeight(context)));
        this.setRightIconSize(array.getDimensionPixelSize(R.styleable.TitleBar_rightIconWidth, this.mCurrentStyle.getRightIconWidth(context)), array.getDimensionPixelSize(R.styleable.TitleBar_rightIconHeight, this.mCurrentStyle.getRightIconHeight(context)));
        this.setTitleIconPadding(array.getDimensionPixelSize(R.styleable.TitleBar_titleIconPadding, this.mCurrentStyle.getTitleIconPadding(context)));
        this.setLeftIconPadding(array.getDimensionPixelSize(R.styleable.TitleBar_leftIconPadding, this.mCurrentStyle.getLeftIconPadding(context)));
        this.setRightIconPadding(array.getDimensionPixelSize(R.styleable.TitleBar_rightIconPadding, this.mCurrentStyle.getRightIconPadding(context)));
        if (array.hasValue(R.styleable.TitleBar_title)) {
            this.setTitle(array.getResourceId(R.styleable.TitleBar_title, 0) != R.string.bar_string_placeholder ? array.getString(R.styleable.TitleBar_title) : this.mCurrentStyle.getTitle(context));
        }
        if (array.hasValue(R.styleable.TitleBar_leftTitle)) {
            this.setLeftTitle(array.getResourceId(R.styleable.TitleBar_leftTitle, 0) != R.string.bar_string_placeholder ? array.getString(R.styleable.TitleBar_leftTitle) : this.mCurrentStyle.getLeftTitle(context));
        }
        if (array.hasValue(R.styleable.TitleBar_rightTitle)) {
            this.setRightTitle(array.getResourceId(R.styleable.TitleBar_rightTitle, 0) != R.string.bar_string_placeholder ? array.getString(R.styleable.TitleBar_rightTitle) : this.mCurrentStyle.getRightTitle(context));
        }
        if (array.hasValue(R.styleable.TitleBar_titleIconTint)) {
            this.setTitleIconTint(array.getColor(R.styleable.TitleBar_titleIconTint, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_leftIconTint)) {
            this.setLeftIconTint(array.getColor(R.styleable.TitleBar_leftIconTint, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_rightIconTint)) {
            this.setRightIconTint(array.getColor(R.styleable.TitleBar_rightIconTint, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_titleIcon)) {
            this.setTitleIcon(TitleBarSupport.getDrawable(context, array.getResourceId(R.styleable.TitleBar_titleIcon, 0)));
        }
        if (array.hasValue(R.styleable.TitleBar_leftIcon)) {
            this.setLeftIcon(array.getResourceId(R.styleable.TitleBar_leftIcon, 0) != R.drawable.bar_drawable_placeholder ? TitleBarSupport.getDrawable(context, array.getResourceId(R.styleable.TitleBar_leftIcon, 0)) : this.mCurrentStyle.getBackButtonDrawable(context));
        }
        if (array.hasValue(R.styleable.TitleBar_rightIcon)) {
            this.setRightIcon(TitleBarSupport.getDrawable(context, array.getResourceId(R.styleable.TitleBar_rightIcon, 0)));
        }
        this.setTitleColor(array.hasValue(R.styleable.TitleBar_titleColor) ? array.getColorStateList(R.styleable.TitleBar_titleColor) : this.mCurrentStyle.getTitleColor(context));
        this.setLeftTitleColor(array.hasValue(R.styleable.TitleBar_leftTitleColor) ? array.getColorStateList(R.styleable.TitleBar_leftTitleColor) : this.mCurrentStyle.getLeftTitleColor(context));
        this.setRightTitleColor(array.hasValue(R.styleable.TitleBar_rightTitleColor) ? array.getColorStateList(R.styleable.TitleBar_rightTitleColor) : this.mCurrentStyle.getRightTitleColor(context));
        this.setTitleSize(0, array.hasValue(R.styleable.TitleBar_titleSize) ? (float)array.getDimensionPixelSize(R.styleable.TitleBar_titleSize, 0) : this.mCurrentStyle.getTitleSize(context));
        this.setLeftTitleSize(0, array.hasValue(R.styleable.TitleBar_leftTitleSize) ? (float)array.getDimensionPixelSize(R.styleable.TitleBar_leftTitleSize, 0) : this.mCurrentStyle.getLeftTitleSize(context));
        this.setRightTitleSize(0, array.hasValue(R.styleable.TitleBar_rightTitleSize) ? (float)array.getDimensionPixelSize(R.styleable.TitleBar_rightTitleSize, 0) : this.mCurrentStyle.getRightTitleSize(context));
        int titleStyle = array.hasValue(R.styleable.TitleBar_titleStyle) ? array.getInt(R.styleable.TitleBar_titleStyle, 0) : this.mCurrentStyle.getTitleStyle(context);
        this.setTitleStyle(this.mCurrentStyle.getTitleTypeface(context, titleStyle), titleStyle);
        int leftTitleStyle = array.hasValue(R.styleable.TitleBar_leftTitleStyle) ? array.getInt(R.styleable.TitleBar_leftTitleStyle, 0) : this.mCurrentStyle.getLeftTitleStyle(context);
        this.setLeftTitleStyle(this.mCurrentStyle.getLeftTitleTypeface(context, leftTitleStyle), leftTitleStyle);
        int rightTitleStyle = array.hasValue(R.styleable.TitleBar_rightTitleStyle) ? array.getInt(R.styleable.TitleBar_rightTitleStyle, 0) : this.mCurrentStyle.getRightTitleStyle(context);
        this.setRightTitleStyle(this.mCurrentStyle.getRightTitleTypeface(context, rightTitleStyle), rightTitleStyle);
        if (array.hasValue(R.styleable.TitleBar_titleGravity)) {
            this.setTitleGravity(array.getInt(R.styleable.TitleBar_titleGravity, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_android_background) && array.getResourceId(R.styleable.TitleBar_android_background, 0) == R.drawable.bar_drawable_placeholder) {
            TitleBarSupport.setBackground((View)this, this.mCurrentStyle.getTitleBarBackground(context));
        }
        if (array.hasValue(R.styleable.TitleBar_leftBackground)) {
            this.setLeftBackground(array.getResourceId(R.styleable.TitleBar_leftBackground, 0) != R.drawable.bar_drawable_placeholder ? array.getDrawable(R.styleable.TitleBar_leftBackground) : this.mCurrentStyle.getLeftTitleBackground(context));
        }
        if (array.hasValue(R.styleable.TitleBar_rightBackground)) {
            this.setRightBackground(array.getResourceId(R.styleable.TitleBar_rightBackground, 0) != R.drawable.bar_drawable_placeholder ? array.getDrawable(R.styleable.TitleBar_rightBackground) : this.mCurrentStyle.getRightTitleBackground(context));
        }
        if (array.hasValue(R.styleable.TitleBar_leftForeground)) {
            this.setLeftForeground(array.getResourceId(R.styleable.TitleBar_leftForeground, 0) != R.drawable.bar_drawable_placeholder ? array.getDrawable(R.styleable.TitleBar_leftForeground) : this.mCurrentStyle.getLeftTitleForeground(context));
        }
        if (array.hasValue(R.styleable.TitleBar_rightForeground)) {
            this.setRightForeground(array.getResourceId(R.styleable.TitleBar_rightForeground, 0) != R.drawable.bar_drawable_placeholder ? array.getDrawable(R.styleable.TitleBar_rightForeground) : this.mCurrentStyle.getRightTitleForeground(context));
        }
        this.setLineVisible(array.getBoolean(R.styleable.TitleBar_lineVisible, this.mCurrentStyle.isLineVisible(context)));
        if (array.hasValue(R.styleable.TitleBar_lineDrawable)) {
            this.setLineDrawable(array.getResourceId(R.styleable.TitleBar_lineDrawable, 0) != R.drawable.bar_drawable_placeholder ? array.getDrawable(R.styleable.TitleBar_lineDrawable) : this.mCurrentStyle.getLineDrawable(context));
        }
        if (array.hasValue(R.styleable.TitleBar_lineSize)) {
            this.setLineSize(array.getDimensionPixelSize(R.styleable.TitleBar_lineSize, 0));
        }
        this.mLeftHorizontalPadding = array.getDimensionPixelSize(R.styleable.TitleBar_leftHorizontalPadding, this.mCurrentStyle.getLeftHorizontalPadding(context));
        this.mTitleHorizontalPadding = array.getDimensionPixelSize(R.styleable.TitleBar_titleHorizontalPadding, this.mCurrentStyle.getTitleHorizontalPadding(context));
        this.mRightHorizontalPadding = array.getDimensionPixelSize(R.styleable.TitleBar_rightHorizontalPadding, this.mCurrentStyle.getRightHorizontalPadding(context));
        this.setChildHorizontalPadding(this.mLeftHorizontalPadding, this.mTitleHorizontalPadding, this.mRightHorizontalPadding);
        this.mVerticalPadding = array.getDimensionPixelSize(R.styleable.TitleBar_childVerticalPadding, this.mCurrentStyle.getChildVerticalPadding(context));
        this.setChildVerticalPadding(this.mVerticalPadding);
        array.recycle();
        this.addView((View)this.mTitleView, 0);
        this.addView((View)this.mLeftView, 1);
        this.addView((View)this.mRightView, 2);
        this.addView(this.mLineView, 3);
        this.addOnLayoutChangeListener(this);
        if (this.isInEditMode()) {
            this.measure(0, 0);
            this.mTitleView.measure(0, 0);
            this.mLeftView.measure(0, 0);
            this.mRightView.measure(0, 0);
            int horizontalMargin = Math.max(this.mLeftView.getMeasuredWidth() + this.mLeftHorizontalPadding * 2, this.mRightView.getMeasuredWidth() + this.mRightHorizontalPadding * 2);
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mTitleView.getLayoutParams();
            layoutParams.setMargins(horizontalMargin, 0, horizontalMargin, 0);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isInEditMode()) {
            return;
        }
        int titleBarWidth = this.getMeasuredWidth();
        int leftViewWidth = this.mLeftView.getMeasuredWidth();
        int centerViewWidth = this.mTitleView.getMeasuredWidth();
        int rightViewWidth = this.mRightView.getMeasuredWidth();
        int maxEdgeWidth = Math.max(leftViewWidth, rightViewWidth);
        int calculateTotalWidth = maxEdgeWidth * 2 + centerViewWidth;
        if (calculateTotalWidth <= titleBarWidth) {
            return;
        }
        if (maxEdgeWidth > titleBarWidth / 3) {
            this.measureChildWithMargins((View)this.mLeftView, View.MeasureSpec.makeMeasureSpec((int)(titleBarWidth / 4), (int)0x40000000), 0, View.MeasureSpec.makeMeasureSpec((int)this.mLeftView.getMeasuredHeight(), (int)0x40000000), 0);
            this.measureChildWithMargins((View)this.mTitleView, View.MeasureSpec.makeMeasureSpec((int)(titleBarWidth / 2), (int)0x40000000), 0, View.MeasureSpec.makeMeasureSpec((int)this.mTitleView.getMeasuredHeight(), (int)0x40000000), 0);
            this.measureChildWithMargins((View)this.mRightView, View.MeasureSpec.makeMeasureSpec((int)(titleBarWidth / 4), (int)0x40000000), 0, View.MeasureSpec.makeMeasureSpec((int)this.mRightView.getMeasuredHeight(), (int)0x40000000), 0);
        } else {
            this.measureChildWithMargins((View)this.mLeftView, View.MeasureSpec.makeMeasureSpec((int)maxEdgeWidth, (int)0x40000000), 0, View.MeasureSpec.makeMeasureSpec((int)this.mLeftView.getMeasuredHeight(), (int)0x40000000), 0);
            this.measureChildWithMargins((View)this.mTitleView, View.MeasureSpec.makeMeasureSpec((int)(titleBarWidth - maxEdgeWidth * 2), (int)0x40000000), 0, View.MeasureSpec.makeMeasureSpec((int)this.mTitleView.getMeasuredHeight(), (int)0x40000000), 0);
            this.measureChildWithMargins((View)this.mRightView, View.MeasureSpec.makeMeasureSpec((int)maxEdgeWidth, (int)0x40000000), 0, View.MeasureSpec.makeMeasureSpec((int)this.mRightView.getMeasuredHeight(), (int)0x40000000), 0);
        }
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (!this.mLeftView.isClickable()) {
            this.mLeftView.setClickable(true);
        }
        if (!this.mTitleView.isClickable()) {
            this.mTitleView.setClickable(true);
        }
        if (!this.mRightView.isClickable()) {
            this.mRightView.setClickable(true);
        }
        if (!this.mLeftView.isEnabled()) {
            this.mLeftView.setEnabled(TitleBarSupport.isContainContent(this.mLeftView));
        }
        if (!this.mTitleView.isEnabled()) {
            this.mTitleView.setEnabled(TitleBarSupport.isContainContent(this.mTitleView));
        }
        if (!this.mRightView.isEnabled()) {
            this.mRightView.setEnabled(TitleBarSupport.isContainContent(this.mRightView));
        }
    }

    public void onClick(View view) {
        if (this.mListener == null) {
            return;
        }
        if (view == this.mLeftView) {
            this.mListener.onLeftClick(this);
        } else if (view == this.mRightView) {
            this.mListener.onRightClick(this);
        } else if (view == this.mTitleView) {
            this.mListener.onTitleClick(this);
        }
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (params.width == -2) {
            params.width = -1;
        }
        int verticalPadding = 0;
        if (params.height == -2) {
            verticalPadding = this.mVerticalPadding;
        }
        this.setChildVerticalPadding(verticalPadding);
        super.setLayoutParams(params);
    }

    protected FrameLayout.LayoutParams generateDefaultLayoutParams() {
        return new FrameLayout.LayoutParams(-1, -2);
    }

    public TitleBar setOnTitleBarListener(OnTitleBarListener listener) {
        this.mListener = listener;
        this.mTitleView.setOnClickListener((View.OnClickListener)this);
        this.mLeftView.setOnClickListener((View.OnClickListener)this);
        this.mRightView.setOnClickListener((View.OnClickListener)this);
        return this;
    }

    public TitleBar setTitle(int id) {
        return this.setTitle(this.getResources().getString(id));
    }

    public TitleBar setTitle(CharSequence text) {
        this.mTitleView.setText(text);
        return this;
    }

    public CharSequence getTitle() {
        return this.mTitleView.getText();
    }

    public TitleBar setLeftTitle(int id) {
        return this.setLeftTitle(this.getResources().getString(id));
    }

    public TitleBar setLeftTitle(CharSequence text) {
        this.mLeftView.setText(text);
        return this;
    }

    public CharSequence getLeftTitle() {
        return this.mLeftView.getText();
    }

    public TitleBar setRightTitle(int id) {
        return this.setRightTitle(this.getResources().getString(id));
    }

    public TitleBar setRightTitle(CharSequence text) {
        this.mRightView.setText(text);
        return this;
    }

    public CharSequence getRightTitle() {
        return this.mRightView.getText();
    }

    public TitleBar setTitleStyle(int style2) {
        return this.setTitleStyle(TitleBarSupport.getTextTypeface(style2), style2);
    }

    public TitleBar setTitleStyle(Typeface typeface, int style2) {
        this.mTitleView.setTypeface(typeface, style2);
        return this;
    }

    public TitleBar setLeftTitleStyle(int style2) {
        return this.setLeftTitleStyle(TitleBarSupport.getTextTypeface(style2), style2);
    }

    public TitleBar setLeftTitleStyle(Typeface typeface, int style2) {
        this.mLeftView.setTypeface(typeface, style2);
        return this;
    }

    public TitleBar setRightTitleStyle(int style2) {
        return this.setRightTitleStyle(TitleBarSupport.getTextTypeface(style2), style2);
    }

    public TitleBar setRightTitleStyle(Typeface typeface, int style2) {
        this.mRightView.setTypeface(typeface, style2);
        return this;
    }

    public TitleBar setTitleColor(int color) {
        return this.setTitleColor(ColorStateList.valueOf((int)color));
    }

    public TitleBar setTitleColor(ColorStateList color) {
        if (color != null) {
            this.mTitleView.setTextColor(color);
        }
        return this;
    }

    public TitleBar setLeftTitleColor(int color) {
        return this.setLeftTitleColor(ColorStateList.valueOf((int)color));
    }

    public TitleBar setLeftTitleColor(ColorStateList color) {
        if (color != null) {
            this.mLeftView.setTextColor(color);
        }
        return this;
    }

    public TitleBar setRightTitleColor(int color) {
        return this.setRightTitleColor(ColorStateList.valueOf((int)color));
    }

    public TitleBar setRightTitleColor(ColorStateList color) {
        if (color != null) {
            this.mRightView.setTextColor(color);
        }
        return this;
    }

    public TitleBar setTitleSize(float size) {
        return this.setTitleSize(2, size);
    }

    public TitleBar setTitleSize(int unit, float size) {
        this.mTitleView.setTextSize(unit, size);
        return this;
    }

    public TitleBar setLeftTitleSize(float size) {
        return this.setLeftTitleSize(2, size);
    }

    public TitleBar setLeftTitleSize(int unit, float size) {
        this.mLeftView.setTextSize(unit, size);
        return this;
    }

    public TitleBar setRightTitleSize(float size) {
        return this.setRightTitleSize(2, size);
    }

    public TitleBar setRightTitleSize(int unit, float size) {
        this.mRightView.setTextSize(unit, size);
        return this;
    }

    public TitleBar setTitleIcon(int id) {
        return this.setTitleIcon(TitleBarSupport.getDrawable(this.getContext(), id));
    }

    public TitleBar setTitleIcon(Drawable drawable2) {
        TitleBarSupport.setDrawableTint(drawable2, this.mTitleIconTint);
        TitleBarSupport.setDrawableSize(drawable2, this.mTitleIconWidth, this.mTitleIconHeight);
        TitleBarSupport.setTextCompoundDrawable(this.mTitleView, drawable2, this.mTitleIconGravity);
        return this;
    }

    public Drawable getTitleIcon() {
        return TitleBarSupport.getTextCompoundDrawable(this.mTitleView, this.mTitleIconGravity);
    }

    public TitleBar setLeftIcon(int id) {
        return this.setLeftIcon(TitleBarSupport.getDrawable(this.getContext(), id));
    }

    public TitleBar setLeftIcon(Drawable drawable2) {
        TitleBarSupport.setDrawableTint(drawable2, this.mLeftIconTint);
        TitleBarSupport.setDrawableSize(drawable2, this.mLeftIconWidth, this.mLeftIconHeight);
        TitleBarSupport.setTextCompoundDrawable(this.mLeftView, drawable2, this.mLeftIconGravity);
        return this;
    }

    public Drawable getLeftIcon() {
        return TitleBarSupport.getTextCompoundDrawable(this.mLeftView, this.mLeftIconGravity);
    }

    public TitleBar setRightIcon(int id) {
        return this.setRightIcon(TitleBarSupport.getDrawable(this.getContext(), id));
    }

    public TitleBar setRightIcon(Drawable drawable2) {
        TitleBarSupport.setDrawableTint(drawable2, this.mRightIconTint);
        TitleBarSupport.setDrawableSize(drawable2, this.mRightIconWidth, this.mRightIconHeight);
        TitleBarSupport.setTextCompoundDrawable(this.mRightView, drawable2, this.mRightIconGravity);
        return this;
    }

    public Drawable getRightIcon() {
        return TitleBarSupport.getTextCompoundDrawable(this.mRightView, this.mRightIconGravity);
    }

    public TitleBar setTitleIconSize(int width, int height) {
        this.mTitleIconWidth = width;
        this.mTitleIconHeight = height;
        TitleBarSupport.setDrawableSize(this.getTitleIcon(), width, height);
        return this;
    }

    public TitleBar setLeftIconSize(int width, int height) {
        this.mLeftIconWidth = width;
        this.mLeftIconHeight = height;
        TitleBarSupport.setDrawableSize(this.getLeftIcon(), width, height);
        return this;
    }

    public TitleBar setRightIconSize(int width, int height) {
        this.mRightIconWidth = width;
        this.mRightIconHeight = height;
        TitleBarSupport.setDrawableSize(this.getRightIcon(), width, height);
        return this;
    }

    public TitleBar setTitleIconPadding(int padding) {
        this.mTitleView.setCompoundDrawablePadding(padding);
        return this;
    }

    public TitleBar setLeftIconPadding(int padding) {
        this.mLeftView.setCompoundDrawablePadding(padding);
        return this;
    }

    public TitleBar setRightIconPadding(int padding) {
        this.mRightView.setCompoundDrawablePadding(padding);
        return this;
    }

    public TitleBar setTitleIconTint(int color) {
        this.mTitleIconTint = color;
        TitleBarSupport.setDrawableTint(this.getTitleIcon(), color);
        return this;
    }

    public TitleBar setLeftIconTint(int color) {
        this.mLeftIconTint = color;
        TitleBarSupport.setDrawableTint(this.getLeftIcon(), color);
        return this;
    }

    public TitleBar setRightIconTint(int color) {
        this.mRightIconTint = color;
        TitleBarSupport.setDrawableTint(this.getRightIcon(), color);
        return this;
    }

    public TitleBar clearTitleIconTint() {
        this.mTitleIconTint = 0;
        TitleBarSupport.clearDrawableTint(this.getTitleIcon());
        return this;
    }

    public TitleBar clearLeftIconTint() {
        this.mLeftIconTint = 0;
        TitleBarSupport.clearDrawableTint(this.getLeftIcon());
        return this;
    }

    public TitleBar clearRightIconTint() {
        this.mRightIconTint = 0;
        TitleBarSupport.clearDrawableTint(this.getRightIcon());
        return this;
    }

    public TitleBar setTitleIconGravity(int gravity) {
        Drawable drawable2 = this.getTitleIcon();
        this.mTitleIconGravity = gravity;
        if (drawable2 != null) {
            TitleBarSupport.setTextCompoundDrawable(this.mTitleView, drawable2, gravity);
        }
        return this;
    }

    public TitleBar setLeftIconGravity(int gravity) {
        Drawable drawable2 = this.getLeftIcon();
        this.mLeftIconGravity = gravity;
        if (drawable2 != null) {
            TitleBarSupport.setTextCompoundDrawable(this.mLeftView, drawable2, gravity);
        }
        return this;
    }

    public TitleBar setRightIconGravity(int gravity) {
        Drawable drawable2 = this.getRightIcon();
        this.mRightIconGravity = gravity;
        if (drawable2 != null) {
            TitleBarSupport.setTextCompoundDrawable(this.mRightView, drawable2, gravity);
        }
        return this;
    }

    public TitleBar setLeftBackground(int id) {
        return this.setLeftBackground(TitleBarSupport.getDrawable(this.getContext(), id));
    }

    public TitleBar setLeftBackground(Drawable drawable2) {
        TitleBarSupport.setBackground((View)this.mLeftView, drawable2);
        return this;
    }

    public TitleBar setRightBackground(int id) {
        return this.setRightBackground(TitleBarSupport.getDrawable(this.getContext(), id));
    }

    public TitleBar setRightBackground(Drawable drawable2) {
        TitleBarSupport.setBackground((View)this.mRightView, drawable2);
        return this;
    }

    public TitleBar setLeftForeground(int id) {
        return this.setLeftForeground(TitleBarSupport.getDrawable(this.getContext(), id));
    }

    public TitleBar setLeftForeground(Drawable drawable2) {
        TitleBarSupport.setForeground((View)this.mLeftView, drawable2);
        return this;
    }

    public TitleBar setRightForeground(int id) {
        return this.setRightForeground(TitleBarSupport.getDrawable(this.getContext(), id));
    }

    public TitleBar setRightForeground(Drawable drawable2) {
        TitleBarSupport.setForeground((View)this.mRightView, drawable2);
        return this;
    }

    public TitleBar setLineVisible(boolean visible) {
        this.mLineView.setVisibility(visible ? 0 : 4);
        return this;
    }

    public TitleBar setLineColor(int color) {
        return this.setLineDrawable((Drawable)new ColorDrawable(color));
    }

    public TitleBar setLineDrawable(Drawable drawable2) {
        TitleBarSupport.setBackground(this.mLineView, drawable2);
        return this;
    }

    public TitleBar setLineSize(int px) {
        ViewGroup.LayoutParams layoutParams = this.mLineView.getLayoutParams();
        layoutParams.height = px;
        this.mLineView.setLayoutParams(layoutParams);
        return this;
    }

    @SuppressLint(value={"RtlHardcoded"})
    public TitleBar setTitleGravity(int gravity) {
        if ((gravity = TitleBarSupport.getAbsoluteGravity((View)this, gravity)) == 3 && TitleBarSupport.isContainContent(TitleBarSupport.isLayoutRtl(this.getContext()) ? this.mRightView : this.mLeftView)) {
            Log.e((String)LOG_TAG, (String)"Title center of gravity for the left, the left title can not have content");
            return this;
        }
        if (gravity == 5 && TitleBarSupport.isContainContent(TitleBarSupport.isLayoutRtl(this.getContext()) ? this.mLeftView : this.mRightView)) {
            Log.e((String)LOG_TAG, (String)"Title center of gravity for the right, the right title can not have content");
            return this;
        }
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mTitleView.getLayoutParams();
        params.gravity = gravity;
        this.mTitleView.setLayoutParams((ViewGroup.LayoutParams)params);
        return this;
    }

    public TitleBar setChildVerticalPadding(int verticalPadding) {
        this.mVerticalPadding = verticalPadding;
        this.mLeftView.setPadding(this.mLeftHorizontalPadding, this.mVerticalPadding, this.mLeftHorizontalPadding, this.mVerticalPadding);
        this.mTitleView.setPadding(this.mTitleHorizontalPadding, this.mVerticalPadding, this.mTitleHorizontalPadding, this.mVerticalPadding);
        this.mRightView.setPadding(this.mRightHorizontalPadding, this.mVerticalPadding, this.mRightHorizontalPadding, this.mVerticalPadding);
        return this;
    }

    public TitleBar setChildHorizontalPadding(int leftHorizontalPadding, int titleHorizontalPadding, int rightHorizontalPadding) {
        this.mLeftHorizontalPadding = leftHorizontalPadding;
        this.mTitleHorizontalPadding = titleHorizontalPadding;
        this.mRightHorizontalPadding = rightHorizontalPadding;
        this.mLeftView.setPadding(this.mLeftHorizontalPadding, this.mVerticalPadding, this.mLeftHorizontalPadding, this.mVerticalPadding);
        this.mTitleView.setPadding(this.mTitleHorizontalPadding, this.mVerticalPadding, this.mTitleHorizontalPadding, this.mVerticalPadding);
        this.mRightView.setPadding(this.mRightHorizontalPadding, this.mVerticalPadding, this.mRightHorizontalPadding, this.mVerticalPadding);
        return this;
    }

    public TextView getLeftView() {
        return this.mLeftView;
    }

    public TextView getTitleView() {
        return this.mTitleView;
    }

    public TextView getRightView() {
        return this.mRightView;
    }

    public View getLineView() {
        return this.mLineView;
    }

    public ITitleBarStyle getCurrentStyle() {
        return this.mCurrentStyle;
    }

    public static void setDefaultStyle(ITitleBarStyle style2) {
        sGlobalStyle = style2;
    }
}

