/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.style.ReplacementSpan;

public abstract class CommonFontSpan
extends ReplacementSpan {
    private float mMeasureTextWidth;

    public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fontMetricsInt) {
        this.mMeasureTextWidth = this.onMeasure(paint, fontMetricsInt, text, start, end);
        Paint.FontMetricsInt metrics = paint.getFontMetricsInt();
        if (fontMetricsInt != null) {
            fontMetricsInt.top = metrics.top;
            fontMetricsInt.ascent = metrics.ascent;
            fontMetricsInt.descent = metrics.descent;
            fontMetricsInt.bottom = metrics.bottom;
        }
        return (int)this.mMeasureTextWidth;
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        int alpha = paint.getAlpha();
        if (alpha != 255) {
            paint.setAlpha(255);
        }
        this.onDraw(canvas, paint, text, start, end, x, top, y, bottom);
        paint.setAlpha(alpha);
    }

    public float onMeasure(@NonNull Paint paint, @Nullable Paint.FontMetricsInt fontMetricsInt, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end) {
        return paint.measureText(text, start, end);
    }

    public abstract void onDraw(@NonNull Canvas var1, @NonNull Paint var2, CharSequence var3, @IntRange(from=0L) int var4, @IntRange(from=0L) int var5, float var6, int var7, int var8, int var9);

    public float getMeasureTextWidth() {
        return this.mMeasureTextWidth;
    }
}

