/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.drawable;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.graphics.ColorUtils;
import android.view.View;
import com.hjq.shape.drawable.ShapeGradientOrientation;
import com.hjq.shape.drawable.ShapeState;

public class ShapeDrawable
extends Drawable {
    private ShapeState mShapeState;
    private final Paint mFillPaint = new Paint(1);
    private Rect mPadding;
    private final Paint mStrokePaint = new Paint(1);
    private Paint mShadowPaint;
    private ColorFilter mColorFilter;
    private int mAlpha = 255;
    private boolean mDither;
    private final Path mPath = new Path();
    private final RectF mRect = new RectF();
    private final RectF mShadowRect = new RectF();
    private final Path mShadowPath = new Path();
    private Paint mLayerPaint;
    private boolean mRectIsDirty;
    private boolean mMutated;
    private Path mRingPath;
    private boolean mPathIsDirty = true;

    public ShapeDrawable() {
        this(new ShapeState());
    }

    public ShapeDrawable(ShapeState state) {
        this.mShapeState = state;
        this.initializeWithState(state);
        this.mRectIsDirty = true;
        this.mMutated = false;
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
    }

    public ShapeState getShapeState() {
        return this.mShapeState;
    }

    public boolean getPadding(@NonNull Rect padding) {
        if (this.mPadding != null) {
            padding.set(this.mPadding);
            return true;
        }
        return super.getPadding(padding);
    }

    public ShapeDrawable setPadding(Rect padding) {
        this.mPadding = padding;
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setShape(int shape) {
        this.mRingPath = null;
        this.mShapeState.setShape(shape);
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setSize(int width, int height) {
        this.mShapeState.setSize(width, height);
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setRadius(float radius) {
        this.mShapeState.setCornerRadius(radius);
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setRadius(float topLeftRadius, float topRightRadius, float bottomLeftRadius, float bottomRightRadius) {
        if (topLeftRadius == topRightRadius && topLeftRadius == bottomLeftRadius && topLeftRadius == bottomRightRadius) {
            return this.setRadius(topLeftRadius);
        }
        this.mShapeState.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius});
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setSolidColor(int startColor, int endColor) {
        return this.setSolidColor(new int[]{startColor, endColor});
    }

    public ShapeDrawable setSolidColor(int startColor, int centerColor, int endColor) {
        return this.setSolidColor(new int[]{startColor, centerColor, endColor});
    }

    public ShapeDrawable setSolidColor(int ... colors) {
        this.mShapeState.setSolidColor(colors);
        if (colors == null) {
            this.mFillPaint.setColor(0);
        } else if (colors.length == 1) {
            this.mFillPaint.setColor(colors[0]);
            this.mFillPaint.clearShadowLayer();
        }
        this.mRectIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setStrokeColor(int startColor, int endColor) {
        return this.setStrokeColor(new int[]{startColor, endColor});
    }

    public ShapeDrawable setStrokeColor(int startColor, int centerColor, int endColor) {
        return this.setStrokeColor(new int[]{startColor, centerColor, endColor});
    }

    public ShapeDrawable setStrokeColor(int ... colors) {
        this.mShapeState.setStrokeColor(colors);
        if (colors == null) {
            this.mStrokePaint.setColor(0);
        } else if (colors.length == 1) {
            this.mStrokePaint.setColor(colors[0]);
            this.mStrokePaint.clearShadowLayer();
        }
        this.mRectIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setStrokeWidth(int width) {
        this.mShapeState.setStrokeWidth(width);
        this.mStrokePaint.setStrokeWidth((float)width);
        this.mRectIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setStrokeDash(float dashWidth, float dashGap) {
        this.mShapeState.setStrokeDash(dashWidth, dashGap);
        this.mStrokePaint.setPathEffect((PathEffect)(dashWidth > 0.0f ? new DashPathEffect(new float[]{dashWidth, dashGap}, 0.0f) : null));
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setGradientType(int type) {
        this.mShapeState.setGradientType(type);
        this.mRectIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setGradientCenter(float x, float y) {
        this.mShapeState.setGradientCenter(x, y);
        this.mRectIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setGradientRadius(float radius) {
        this.mShapeState.setGradientRadius(radius);
        this.mRectIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setUseLevel(boolean useLevel) {
        this.mShapeState.mUseLevel = useLevel;
        this.mRectIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setGradientAngle(int angle) {
        if ((angle %= 360) % 45 == 0) {
            switch (angle) {
                case 0: {
                    this.setGradientOrientation(ShapeGradientOrientation.LEFT_RIGHT);
                    break;
                }
                case 45: {
                    this.setGradientOrientation(ShapeGradientOrientation.BL_TR);
                    break;
                }
                case 90: {
                    this.setGradientOrientation(ShapeGradientOrientation.BOTTOM_TOP);
                    break;
                }
                case 135: {
                    this.setGradientOrientation(ShapeGradientOrientation.BR_TL);
                    break;
                }
                case 180: {
                    this.setGradientOrientation(ShapeGradientOrientation.RIGHT_LEFT);
                    break;
                }
                case 225: {
                    this.setGradientOrientation(ShapeGradientOrientation.TR_BL);
                    break;
                }
                case 270: {
                    this.setGradientOrientation(ShapeGradientOrientation.TOP_BOTTOM);
                    break;
                }
                case 315: {
                    this.setGradientOrientation(ShapeGradientOrientation.TL_BR);
                    break;
                }
            }
        }
        return this;
    }

    public ShapeDrawable setGradientOrientation(ShapeGradientOrientation orientation) {
        this.mShapeState.mGradientOrientation = orientation;
        this.mRectIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setInnerRadius(int radius) {
        this.mShapeState.mInnerRadius = radius;
        this.mRectIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setInnerRadiusRatio(float radiusRatio) {
        this.mShapeState.mInnerRadiusRatio = radiusRatio;
        this.mRectIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setThickness(int size) {
        this.mShapeState.mThickness = size;
        this.mRectIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setThicknessRatio(float radiusRatio) {
        this.mShapeState.mThicknessRatio = radiusRatio;
        this.mRectIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setShadowColor(int color) {
        this.mShapeState.setShadowColor(color);
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setShadowSize(int size) {
        this.mShapeState.setShadowSize(size);
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setShadowOffsetX(int offsetX) {
        this.mShapeState.setShadowOffsetX(offsetX);
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setShadowOffsetY(int offsetY) {
        this.mShapeState.setShadowOffsetY(offsetY);
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return this;
    }

    public void intoBackground(View view) {
        if (this.mShapeState.mStrokeDashGap > 0.0f || this.mShapeState.mShadowSize > 0) {
            view.setLayerType(1, null);
        }
        view.setBackground((Drawable)this);
    }

    @SuppressLint(value={"WrongConstant"})
    public void draw(@NonNull Canvas canvas) {
        boolean useLayer;
        if (!this.ensureValidRect()) {
            return;
        }
        int prevFillAlpha = this.mFillPaint.getAlpha();
        int prevStrokeAlpha = this.mStrokePaint.getAlpha();
        int currFillAlpha = this.modulateAlpha(prevFillAlpha);
        int currStrokeAlpha = this.modulateAlpha(prevStrokeAlpha);
        boolean haveShadow = this.mShapeState.mShadowSize > 0;
        boolean haveStroke = currStrokeAlpha > 0 && this.mStrokePaint.getStrokeWidth() > 0.0f;
        boolean haveFill = currFillAlpha > 0;
        ShapeState st = this.mShapeState;
        boolean bl = useLayer = haveStroke && haveFill && st.mShapeType != 2 && currStrokeAlpha < 255 && (this.mAlpha < 255 || this.mColorFilter != null);
        if (useLayer) {
            if (this.mLayerPaint == null) {
                this.mLayerPaint = new Paint();
            }
            this.mLayerPaint.setDither(this.mDither);
            this.mLayerPaint.setAlpha(this.mAlpha);
            this.mLayerPaint.setColorFilter(this.mColorFilter);
            float rad = this.mStrokePaint.getStrokeWidth();
            if (Build.VERSION.SDK_INT >= 21) {
                canvas.saveLayer(this.mRect.left - rad, this.mRect.top - rad, this.mRect.right + rad, this.mRect.bottom + rad, this.mLayerPaint);
            } else {
                canvas.saveLayer(this.mRect.left - rad, this.mRect.top - rad, this.mRect.right + rad, this.mRect.bottom + rad, this.mLayerPaint, 4);
            }
            this.mFillPaint.setColorFilter(null);
            this.mStrokePaint.setColorFilter(null);
        } else {
            this.mFillPaint.setAlpha(currFillAlpha);
            this.mFillPaint.setDither(this.mDither);
            this.mFillPaint.setColorFilter(this.mColorFilter);
            if (this.mColorFilter != null && !this.mShapeState.mHasSolidColor) {
                this.mFillPaint.setColor(this.mAlpha << 24);
            }
            if (haveStroke) {
                this.mStrokePaint.setAlpha(currStrokeAlpha);
                this.mStrokePaint.setDither(this.mDither);
                this.mStrokePaint.setColorFilter(this.mColorFilter);
            }
        }
        if (haveShadow) {
            if (this.mShadowPaint == null) {
                this.mShadowPaint = new Paint();
                this.mShadowPaint.setColor(0);
                this.mShadowPaint.setStyle(Paint.Style.STROKE);
            }
            if (haveStroke) {
                this.mShadowPaint.setStrokeWidth(this.mStrokePaint.getStrokeWidth());
            } else {
                this.mShadowPaint.setStrokeWidth((float)this.mShapeState.mShadowSize / 4.0f);
            }
            int shadowColor = this.mShapeState.mShadowColor;
            if (ColorUtils.setAlphaComponent((int)this.mShapeState.mShadowColor, (int)255) == this.mShapeState.mShadowColor) {
                shadowColor = ColorUtils.setAlphaComponent((int)this.mShapeState.mShadowColor, (int)254);
            }
            float shadowOffsetX = 0.0f;
            if (this.mShapeState.mShadowOffsetX > 0) {
                shadowOffsetX = this.mShapeState.mShadowOffsetX;
            }
            float shadowOffsetY = 0.0f;
            if (this.mShapeState.mShadowOffsetY > 0) {
                shadowOffsetY = this.mShapeState.mShadowOffsetY;
            }
            this.mShadowPaint.setShadowLayer((float)this.mShapeState.mShadowSize, shadowOffsetX, shadowOffsetY, shadowColor);
        } else if (this.mShadowPaint != null) {
            this.mShadowPaint.clearShadowLayer();
        }
        switch (st.mShapeType) {
            case 0: {
                if (st.mRadiusArray != null) {
                    if (this.mPathIsDirty || this.mRectIsDirty) {
                        this.mPath.reset();
                        this.mPath.addRoundRect(this.mRect, st.mRadiusArray, Path.Direction.CW);
                        this.mRectIsDirty = false;
                        this.mPathIsDirty = false;
                    }
                    if (haveShadow) {
                        this.mShadowPath.reset();
                        this.mShadowPath.addRoundRect(this.mShadowRect, st.mRadiusArray, Path.Direction.CW);
                        canvas.drawPath(this.mShadowPath, this.mShadowPaint);
                    }
                    canvas.drawPath(this.mPath, this.mFillPaint);
                    if (!haveStroke) break;
                    canvas.drawPath(this.mPath, this.mStrokePaint);
                    break;
                }
                if (st.mRadius > 0.0f) {
                    float rad = st.mRadius;
                    float r = Math.min(this.mRect.width(), this.mRect.height()) * 0.5f;
                    if (rad > r) {
                        rad = r;
                    }
                    if (haveShadow) {
                        canvas.drawRoundRect(this.mShadowRect, rad, rad, this.mShadowPaint);
                    }
                    canvas.drawRoundRect(this.mRect, rad, rad, this.mFillPaint);
                    if (!haveStroke) break;
                    canvas.drawRoundRect(this.mRect, rad, rad, this.mStrokePaint);
                    break;
                }
                if (haveShadow) {
                    canvas.drawRect(this.mShadowRect, this.mShadowPaint);
                }
                if (this.mFillPaint.getColor() != 0 || this.mColorFilter != null || this.mFillPaint.getShader() != null) {
                    canvas.drawRect(this.mRect, this.mFillPaint);
                }
                if (!haveStroke) break;
                canvas.drawRect(this.mRect, this.mStrokePaint);
                break;
            }
            case 1: {
                if (haveShadow) {
                    canvas.drawOval(this.mShadowRect, this.mShadowPaint);
                }
                canvas.drawOval(this.mRect, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawOval(this.mRect, this.mStrokePaint);
                break;
            }
            case 2: {
                RectF r = this.mRect;
                float y = r.centerY();
                if (haveShadow) {
                    canvas.drawLine(r.left, y, r.right, y, this.mShadowPaint);
                }
                canvas.drawLine(r.left, y, r.right, y, this.mStrokePaint);
                break;
            }
            case 3: {
                Path path = this.buildRing(st);
                if (haveShadow) {
                    canvas.drawPath(path, this.mShadowPaint);
                }
                canvas.drawPath(path, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawPath(path, this.mStrokePaint);
                break;
            }
        }
        if (useLayer) {
            canvas.restore();
        } else {
            this.mFillPaint.setAlpha(prevFillAlpha);
            if (haveStroke) {
                this.mStrokePaint.setAlpha(prevStrokeAlpha);
            }
        }
    }

    private int modulateAlpha(int alpha) {
        int scale = this.mAlpha + (this.mAlpha >> 7);
        return alpha * scale >> 8;
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mShapeState.mChangingConfigurations;
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setDither(boolean dither) {
        if (dither != this.mDither) {
            this.mDither = dither;
            this.invalidateSelf();
        }
    }

    public void setColorFilter(ColorFilter cf) {
        if (cf != this.mColorFilter) {
            this.mColorFilter = cf;
            this.invalidateSelf();
        }
    }

    public int getOpacity() {
        return this.mShapeState.mOpaque ? -1 : -3;
    }

    protected void onBoundsChange(Rect r) {
        super.onBoundsChange(r);
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mRectIsDirty = true;
    }

    protected boolean onLevelChange(int level) {
        super.onLevelChange(level);
        this.mRectIsDirty = true;
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return true;
    }

    private Path buildRing(ShapeState st) {
        if (!(this.mRingPath == null || st.mUseLevelForShape && this.mPathIsDirty)) {
            return this.mRingPath;
        }
        this.mPathIsDirty = false;
        float sweep = st.mUseLevelForShape ? 360.0f * (float)this.getLevel() / 10000.0f : 360.0f;
        RectF bounds = new RectF(this.mRect);
        float x = bounds.width() / 2.0f;
        float y = bounds.height() / 2.0f;
        float thickness = st.mThickness != -1 ? (float)st.mThickness : bounds.width() / st.mThicknessRatio;
        float radius = st.mInnerRadius != -1 ? (float)st.mInnerRadius : bounds.width() / st.mInnerRadiusRatio;
        RectF innerBounds = new RectF(bounds);
        innerBounds.inset(x - radius, y - radius);
        bounds = new RectF(innerBounds);
        bounds.inset(-thickness, -thickness);
        if (this.mRingPath == null) {
            this.mRingPath = new Path();
        } else {
            this.mRingPath.reset();
        }
        Path ringPath = this.mRingPath;
        if (sweep < 360.0f && sweep > -360.0f) {
            ringPath.setFillType(Path.FillType.EVEN_ODD);
            ringPath.moveTo(x + radius, y);
            ringPath.lineTo(x + radius + thickness, y);
            ringPath.arcTo(bounds, 0.0f, sweep, false);
            ringPath.arcTo(innerBounds, sweep, -sweep, false);
            ringPath.close();
        } else {
            ringPath.addOval(bounds, Path.Direction.CW);
            ringPath.addOval(innerBounds, Path.Direction.CCW);
        }
        return ringPath;
    }

    private boolean ensureValidRect() {
        if (this.mRectIsDirty) {
            float shadowBottom;
            float shadowTop;
            float shadowRight;
            float shadowLet;
            this.mRectIsDirty = false;
            Rect bounds = this.getBounds();
            float inset = this.mStrokePaint.getStrokeWidth() * 0.5f;
            ShapeState st = this.mShapeState;
            float let = (float)bounds.left + inset + (float)this.mShapeState.mShadowSize * 1.2f;
            float top = (float)bounds.top + inset + (float)this.mShapeState.mShadowSize * 1.2f;
            float right = (float)bounds.right - inset - (float)this.mShapeState.mShadowSize * 1.2f;
            float bottom = (float)bounds.bottom - inset - (float)this.mShapeState.mShadowSize * 1.2f;
            this.mRect.set(let, top, right, bottom);
            if (this.mShapeState.mShadowOffsetX > 0) {
                shadowLet = let + (float)this.mShapeState.mShadowOffsetX;
                shadowRight = right - (float)this.mShapeState.mShadowOffsetX;
            } else {
                shadowLet = let;
                shadowRight = right + (float)this.mShapeState.mShadowOffsetX;
            }
            if (this.mShapeState.mShadowOffsetY > 0) {
                shadowTop = top + (float)this.mShapeState.mShadowOffsetY;
                shadowBottom = bottom - (float)this.mShapeState.mShadowOffsetY;
            } else {
                shadowTop = top;
                shadowBottom = bottom + (float)this.mShapeState.mShadowOffsetY;
            }
            this.mShadowRect.set(shadowLet, shadowTop, shadowRight, shadowBottom);
            if (st.mSolidColors != null || st.mStrokeColors != null) {
                RectF r = this.mRect;
                if (st.mGradientType == 0) {
                    float y1;
                    float x1;
                    float y0;
                    float x0;
                    float level = st.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    switch (st.mGradientOrientation) {
                        case TOP_BOTTOM: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = x0;
                            y1 = level * r.bottom;
                            break;
                        }
                        case TR_BL: {
                            x0 = r.right;
                            y0 = r.top;
                            x1 = level * r.left;
                            y1 = level * r.bottom;
                            break;
                        }
                        case RIGHT_LEFT: {
                            x0 = r.right;
                            y0 = r.top;
                            x1 = level * r.left;
                            y1 = y0;
                            break;
                        }
                        case BR_TL: {
                            x0 = r.right;
                            y0 = r.bottom;
                            x1 = level * r.left;
                            y1 = level * r.top;
                            break;
                        }
                        case BOTTOM_TOP: {
                            x0 = r.left;
                            y0 = r.bottom;
                            x1 = x0;
                            y1 = level * r.top;
                            break;
                        }
                        case BL_TR: {
                            x0 = r.left;
                            y0 = r.bottom;
                            x1 = level * r.right;
                            y1 = level * r.top;
                            break;
                        }
                        case LEFT_RIGHT: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = level * r.right;
                            y1 = y0;
                            break;
                        }
                        default: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = level * r.right;
                            y1 = level * r.bottom;
                        }
                    }
                    if (st.mSolidColors != null) {
                        this.mFillPaint.setShader((Shader)new LinearGradient(x0, y0, x1, y1, st.mSolidColors, st.mPositions, Shader.TileMode.CLAMP));
                    }
                    if (st.mStrokeColors != null) {
                        this.mStrokePaint.setShader((Shader)new LinearGradient(x0, y0, x1, y1, st.mStrokeColors, st.mPositions, Shader.TileMode.CLAMP));
                    }
                } else if (st.mGradientType == 1) {
                    float level;
                    float x0 = r.left + (r.right - r.left) * st.mCenterX;
                    float y0 = r.top + (r.bottom - r.top) * st.mCenterY;
                    float f = level = st.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    if (st.mSolidColors != null) {
                        this.mFillPaint.setShader((Shader)new RadialGradient(x0, y0, level * st.mGradientRadius, st.mSolidColors, null, Shader.TileMode.CLAMP));
                    }
                    if (st.mStrokeColors != null) {
                        this.mStrokePaint.setShader((Shader)new RadialGradient(x0, y0, level * st.mGradientRadius, st.mStrokeColors, null, Shader.TileMode.CLAMP));
                    }
                } else if (st.mGradientType == 2) {
                    int i;
                    float level;
                    float fraction;
                    int length;
                    float x0 = r.left + (r.right - r.left) * st.mCenterX;
                    float y0 = r.top + (r.bottom - r.top) * st.mCenterY;
                    if (st.mSolidColors != null) {
                        int[] tempSolidColors = st.mSolidColors;
                        float[] tempSolidPositions = null;
                        if (st.mUseLevel) {
                            tempSolidColors = st.mTempSolidColors;
                            length = st.mSolidColors.length;
                            if (tempSolidColors == null || tempSolidColors.length != length + 1) {
                                st.mTempSolidColors = new int[length + 1];
                                tempSolidColors = st.mTempSolidColors;
                            }
                            System.arraycopy(st.mSolidColors, 0, tempSolidColors, 0, length);
                            tempSolidColors[length] = st.mSolidColors[length - 1];
                            tempSolidPositions = st.mTempSolidPositions;
                            fraction = 1.0f / (float)(length - 1);
                            if (tempSolidPositions == null || tempSolidPositions.length != length + 1) {
                                tempSolidPositions = st.mTempSolidPositions = new float[length + 1];
                            }
                            level = (float)this.getLevel() / 10000.0f;
                            for (i = 0; i < length; ++i) {
                                tempSolidPositions[i] = (float)i * fraction * level;
                            }
                            tempSolidPositions[length] = 1.0f;
                        }
                        this.mFillPaint.setShader((Shader)new SweepGradient(x0, y0, tempSolidColors, tempSolidPositions));
                    }
                    if (st.mStrokeColors != null) {
                        int[] tempStrokeColors = st.mStrokeColors;
                        float[] tempStrokePositions = null;
                        if (st.mUseLevel) {
                            tempStrokeColors = st.mTempStrokeColors;
                            length = st.mStrokeColors.length;
                            if (tempStrokeColors == null || tempStrokeColors.length != length + 1) {
                                st.mTempStrokeColors = new int[length + 1];
                                tempStrokeColors = st.mTempStrokeColors;
                            }
                            System.arraycopy(st.mStrokeColors, 0, tempStrokeColors, 0, length);
                            tempStrokeColors[length] = st.mStrokeColors[length - 1];
                            tempStrokePositions = st.mTempStrokePositions;
                            fraction = 1.0f / (float)(length - 1);
                            if (tempStrokePositions == null || tempStrokePositions.length != length + 1) {
                                tempStrokePositions = st.mTempStrokePositions = new float[length + 1];
                            }
                            level = (float)this.getLevel() / 10000.0f;
                            for (i = 0; i < length; ++i) {
                                tempStrokePositions[i] = (float)i * fraction * level;
                            }
                            tempStrokePositions[length] = 1.0f;
                        }
                        this.mStrokePaint.setShader((Shader)new SweepGradient(x0, y0, tempStrokeColors, tempStrokePositions));
                    }
                }
                if (!st.mHasSolidColor) {
                    this.mFillPaint.setColor(-16777216);
                }
                if (!st.mHasStrokeColor) {
                    this.mStrokePaint.setColor(-16777216);
                }
            }
        }
        return !this.mRect.isEmpty();
    }

    public int getIntrinsicWidth() {
        return this.mShapeState.mWidth;
    }

    public int getIntrinsicHeight() {
        return this.mShapeState.mHeight;
    }

    public Drawable.ConstantState getConstantState() {
        this.mShapeState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mShapeState;
    }

    @NonNull
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mShapeState = new ShapeState(this.mShapeState);
            this.initializeWithState(this.mShapeState);
            this.mMutated = true;
        }
        return this;
    }

    private void initializeWithState(ShapeState state) {
        if (state.mHasSolidColor) {
            this.mFillPaint.setColor(state.mSolidColor);
        } else if (state.mSolidColors == null) {
            this.mFillPaint.setColor(0);
        } else {
            this.mFillPaint.setColor(-16777216);
        }
        this.mPadding = state.mPadding;
        if (state.mStrokeWidth >= 0) {
            if (state.mHasStrokeColor) {
                this.setStrokeColor(state.mStrokeColor);
            } else {
                this.setStrokeColor(state.mStrokeColors);
            }
            this.setStrokeWidth(state.mStrokeWidth);
            this.setStrokeDash(state.mStrokeDashWidth, state.mStrokeDashGap);
        }
    }
}

