/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;

public interface IShapeDrawable<V extends View> {
    public static final int DEFAULT_SHAPE = 0;
    public static final int DEFAULT_SHAPE_WIDTH = -1;
    public static final int DEFAULT_SHAPE_HEIGHT = -1;
    public static final int DEFAULT_SHAPE_SOLID_COLOR = 0;
    public static final int DEFAULT_SHAPE_RADIUS = 0;
    public static final int DEFAULT_SHAPE_START_COLOR = 0;
    public static final int DEFAULT_SHAPE_CENTER_COLOR = 0;
    public static final int DEFAULT_SHAPE_END_COLOR = 0;
    public static final boolean DEFAULT_SHAPE_USE_LEVEL = false;
    public static final int DEFAULT_SHAPE_GRADIENT_TYPE = 0;
    public static final int DEFAULT_SHAPE_ANGLE = 0;
    public static final float DEFAULT_SHAPE_CENTER_X = 0.5f;
    public static final float DEFAULT_SHAPE_CENTER_Y = 0.5f;
    public static final int DEFAULT_SHAPE_STROKE_COLOR = 0;
    public static final int DEFAULT_SHAPE_STROKE_WIDTH = 0;
    public static final int DEFAULT_SHAPE_DASH_WIDTH = 0;
    public static final int DEFAULT_SHAPE_DASH_GAP = 0;

    public V setShape(int var1);

    public int getShape();

    public V setShapeWidth(int var1);

    public int getShapeWidth();

    public V setShapeHeight(int var1);

    public int getShapeHeight();

    public V setSolidColor(int var1);

    public int getSolidColor();

    default public V setSolidPressedColor(int color) {
        return this.setSolidColor(color);
    }

    default public int getSolidPressedColor() {
        return this.getSolidColor();
    }

    default public V setSolidCheckedColor(int color) {
        return this.setSolidColor(color);
    }

    default public int getSolidCheckedColor() {
        return this.getSolidColor();
    }

    default public V setSolidDisabledColor(int color) {
        return this.setSolidColor(color);
    }

    default public int getSolidDisabledColor() {
        return this.getSolidColor();
    }

    default public V setSolidFocusedColor(int color) {
        return this.setSolidColor(color);
    }

    default public int getSolidFocusedColor() {
        return this.getSolidColor();
    }

    default public V setSolidSelectedColor(int color) {
        return this.setSolidColor(color);
    }

    default public int getSolidSelectedColor() {
        return this.getSolidColor();
    }

    default public V setRadius(int radius) {
        this.setTopLeftRadius(radius);
        this.setTopRightRadius(radius);
        this.setBottomLeftRadius(radius);
        return this.setBottomRightRadius(radius);
    }

    public V setTopLeftRadius(int var1);

    public int getTopLeftRadius();

    public V setTopRightRadius(int var1);

    public int getTopRightRadius();

    public V setBottomLeftRadius(int var1);

    public int getBottomLeftRadius();

    public V setBottomRightRadius(int var1);

    public int getBottomRightRadius();

    public V setStartColor(int var1);

    public int getStartColor();

    public V setCenterColor(int var1);

    public int getCenterColor();

    public V setEndColor(int var1);

    public int getEndColor();

    public V setUseLevel(boolean var1);

    public boolean isUseLevel();

    public V setAngle(int var1);

    public int getAngle();

    public V setGradientType(int var1);

    public int getGradientType();

    public V setCenterX(float var1);

    public float getCenterX();

    public V setCenterY(float var1);

    public float getCenterY();

    public V setGradientRadius(int var1);

    public int getGradientRadius();

    public V setStrokeColor(int var1);

    public int getStrokeColor();

    default public V setStrokePressedColor(int color) {
        return this.setStrokeColor(color);
    }

    default public int getStrokePressedColor() {
        return this.getStrokeColor();
    }

    default public V setStrokeCheckedColor(int color) {
        return this.setStrokeColor(color);
    }

    default public int getStrokeCheckedColor() {
        return this.getStrokeColor();
    }

    default public V setStrokeDisabledColor(int color) {
        return this.setStrokeColor(color);
    }

    default public int getStrokeDisabledColor() {
        return this.getStrokeColor();
    }

    default public V setStrokeFocusedColor(int color) {
        return this.setStrokeColor(color);
    }

    default public int getStrokeFocusedColor() {
        return this.getStrokeColor();
    }

    default public V setStrokeSelectedColor(int color) {
        return this.setStrokeColor(color);
    }

    default public int getStrokeSelectedColor() {
        return this.getStrokeColor();
    }

    public V setStrokeWidth(int var1);

    public int getStrokeWidth();

    public V setDashWidth(int var1);

    public int getDashWidth();

    public V setDashGap(int var1);

    public int getDashGap();

    default public Drawable buildDrawable() {
        if (this.getSolidColor() != this.getSolidPressedColor() || this.getStrokeColor() != this.getStrokePressedColor() || this.getSolidColor() != this.getSolidCheckedColor() || this.getStrokeColor() != this.getStrokeCheckedColor() || this.getSolidColor() != this.getSolidDisabledColor() || this.getStrokeColor() != this.getStrokeDisabledColor() || this.getSolidColor() != this.getSolidFocusedColor() || this.getStrokeColor() != this.getStrokeFocusedColor() || this.getSolidColor() != this.getSolidSelectedColor() || this.getStrokeColor() != this.getStrokeSelectedColor()) {
            StateListDrawable drawable = new StateListDrawable();
            if (this.getSolidColor() != this.getSolidPressedColor() || this.getStrokeColor() != this.getStrokePressedColor()) {
                drawable.addState(new int[]{16842919}, this.createDrawable(this.getSolidPressedColor(), this.getStrokePressedColor()));
            }
            if (this.getSolidColor() != this.getSolidCheckedColor() || this.getStrokeColor() != this.getStrokeCheckedColor()) {
                drawable.addState(new int[]{0x10100A0}, this.createDrawable(this.getSolidCheckedColor(), this.getStrokeCheckedColor()));
            }
            if (this.getSolidColor() != this.getSolidDisabledColor() || this.getStrokeColor() != this.getStrokeDisabledColor()) {
                drawable.addState(new int[]{-16842910}, this.createDrawable(this.getSolidDisabledColor(), this.getStrokeDisabledColor()));
            }
            if (this.getSolidColor() != this.getSolidFocusedColor() || this.getStrokeColor() != this.getStrokeFocusedColor()) {
                drawable.addState(new int[]{16842908}, this.createDrawable(this.getSolidFocusedColor(), this.getStrokeFocusedColor()));
            }
            if (this.getSolidColor() != this.getSolidSelectedColor() || this.getStrokeColor() != this.getStrokeSelectedColor()) {
                drawable.addState(new int[]{0x10100A1}, this.createDrawable(this.getSolidSelectedColor(), this.getStrokeSelectedColor()));
            }
            drawable.addState(new int[0], this.createDrawable(this.getSolidColor(), this.getStrokeColor()));
            return drawable;
        }
        return this.createDrawable(this.getSolidColor(), this.getStrokeColor());
    }

    default public Drawable createDrawable(int solidColor, int strokeColor) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setShape(this.getShape());
        drawable.setSize(this.getShapeWidth(), this.getShapeHeight());
        drawable.setCornerRadii(new float[]{this.getTopLeftRadius(), this.getTopLeftRadius(), this.getTopRightRadius(), this.getTopRightRadius(), this.getBottomRightRadius(), this.getBottomRightRadius(), this.getBottomLeftRadius(), this.getBottomLeftRadius()});
        drawable.setColor(solidColor);
        int startColor = this.getStartColor();
        int centerColor = this.getCenterColor();
        int endColor = this.getEndColor();
        if (startColor != 0 || centerColor != 0 || endColor != 0) {
            if (centerColor == 0) {
                drawable.setColors(new int[]{startColor, endColor});
            } else {
                drawable.setColors(new int[]{startColor, centerColor, endColor});
            }
        }
        drawable.setGradientCenter(this.getCenterX(), this.getCenterY());
        drawable.setUseLevel(this.isUseLevel());
        int angle = this.getAngle();
        if ((angle %= 360) % 45 == 0) {
            switch (angle) {
                case 0: {
                    drawable.setOrientation(GradientDrawable.Orientation.LEFT_RIGHT);
                    break;
                }
                case 45: {
                    drawable.setOrientation(GradientDrawable.Orientation.BL_TR);
                    break;
                }
                case 90: {
                    drawable.setOrientation(GradientDrawable.Orientation.BOTTOM_TOP);
                    break;
                }
                case 135: {
                    drawable.setOrientation(GradientDrawable.Orientation.BR_TL);
                    break;
                }
                case 180: {
                    drawable.setOrientation(GradientDrawable.Orientation.RIGHT_LEFT);
                    break;
                }
                case 225: {
                    drawable.setOrientation(GradientDrawable.Orientation.TR_BL);
                    break;
                }
                case 270: {
                    drawable.setOrientation(GradientDrawable.Orientation.TOP_BOTTOM);
                    break;
                }
                case 315: {
                    drawable.setOrientation(GradientDrawable.Orientation.TL_BR);
                    break;
                }
            }
        }
        drawable.setGradientType(this.getGradientType());
        drawable.setGradientRadius((float)this.getGradientRadius());
        drawable.setStroke(this.getStrokeWidth(), strokeColor, (float)this.getDashWidth(), (float)this.getDashGap());
        return drawable;
    }

    public void intoBackground();
}

