/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatCheckBox;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.hjq.shape.R;
import com.hjq.shape.builder.ButtonDrawableBuilder;
import com.hjq.shape.builder.ShapeDrawableBuilder;
import com.hjq.shape.builder.TextColorBuilder;
import com.hjq.shape.config.IGetButtonDrawableBuilder;
import com.hjq.shape.config.IGetShapeDrawableBuilder;
import com.hjq.shape.config.IGetTextColorBuilder;
import com.hjq.shape.styleable.ShapeCheckBoxStyleable;

public class ShapeCheckBox
extends AppCompatCheckBox
implements IGetShapeDrawableBuilder,
IGetTextColorBuilder,
IGetButtonDrawableBuilder {
    private static final ShapeCheckBoxStyleable STYLEABLE = new ShapeCheckBoxStyleable();
    private final ShapeDrawableBuilder mShapeDrawableBuilder;
    private final TextColorBuilder mTextColorBuilder;
    private final ButtonDrawableBuilder mButtonDrawableBuilder;

    public ShapeCheckBox(Context context) {
        this(context, null);
    }

    public ShapeCheckBox(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.checkboxStyle);
    }

    public ShapeCheckBox(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeCheckBox, 0, R.style.ShapeCheckBoxStyle);
        this.mShapeDrawableBuilder = new ShapeDrawableBuilder((View)this, typedArray, STYLEABLE);
        this.mTextColorBuilder = new TextColorBuilder((TextView)this, typedArray, STYLEABLE);
        this.mButtonDrawableBuilder = new ButtonDrawableBuilder((CompoundButton)this, typedArray, STYLEABLE);
        typedArray.recycle();
        this.mShapeDrawableBuilder.intoBackground();
        this.mTextColorBuilder.intoTextColor();
        this.mButtonDrawableBuilder.intoButtonDrawable();
    }

    public void setTextColor(int color) {
        super.setTextColor(color);
        if (this.mTextColorBuilder == null) {
            return;
        }
        this.mTextColorBuilder.setTextColor(color);
    }

    public void setButtonDrawable(Drawable drawable2) {
        super.setButtonDrawable(drawable2);
        if (this.mButtonDrawableBuilder == null) {
            return;
        }
        this.mButtonDrawableBuilder.setButtonDrawable(drawable2);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (type != TextView.BufferType.SPANNABLE && this.mTextColorBuilder != null && this.mTextColorBuilder.isTextStrokeColorEnable()) {
            super.setText((CharSequence)this.mTextColorBuilder.buildStrokeFontSpannable(text), TextView.BufferType.SPANNABLE);
        } else {
            super.setText(text, type);
        }
    }

    protected void onDraw(Canvas canvas) {
        this.mTextColorBuilder.onDraw((View)this, canvas, (Paint)this.getPaint());
        super.onDraw(canvas);
    }

    @Override
    public ShapeDrawableBuilder getShapeDrawableBuilder() {
        return this.mShapeDrawableBuilder;
    }

    @Override
    public TextColorBuilder getTextColorBuilder() {
        return this.mTextColorBuilder;
    }

    @Override
    public ButtonDrawableBuilder getButtonDrawableBuilder() {
        return this.mButtonDrawableBuilder;
    }
}

