/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.drawable;

import android.annotation.SuppressLint;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.view.Gravity;
import android.view.View;
import com.hjq.shape.drawable.ShapeDrawableUtils;
import com.hjq.shape.drawable.ShapeState;

public class ShapeDrawable
extends Drawable {
    private ShapeState mShapeState;
    private final Paint mSolidPaint = new Paint(1);
    private Rect mPadding;
    private final Paint mStrokePaint = new Paint(1);
    private Paint mShadowPaint;
    private ColorFilter mColorFilter;
    private int mAlpha = 255;
    private boolean mDither;
    private final Path mPath = new Path();
    private final RectF mRect = new RectF();
    private final RectF mShadowRect = new RectF();
    private final Path mShadowPath = new Path();
    private Paint mLayerPaint;
    private boolean mRectDirty;
    private boolean mMutated;
    private Path mRingPath;
    private boolean mPathDirty = true;

    public ShapeDrawable() {
        this(new ShapeState());
    }

    public ShapeDrawable(ShapeState state) {
        this.mShapeState = state;
        this.initializeWithState(state);
        this.mRectDirty = true;
        this.mMutated = false;
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
    }

    public ShapeState getShapeState() {
        return this.mShapeState;
    }

    public boolean getPadding(@NonNull Rect padding) {
        if (this.mPadding != null) {
            padding.set(this.mPadding);
            return true;
        }
        return super.getPadding(padding);
    }

    public ShapeDrawable setPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        return this.setPadding(new Rect(paddingLeft, paddingTop, paddingRight, paddingBottom));
    }

    public ShapeDrawable setPadding(Rect padding) {
        this.mPadding = padding;
        this.mPathDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setType(int shape) {
        this.mRingPath = null;
        this.mShapeState.setType(shape);
        this.mPathDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setWidth(int width) {
        this.mShapeState.width = width;
        this.mPathDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setHeight(int height) {
        this.mShapeState.height = height;
        this.mPathDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setRadius(float radius) {
        this.mShapeState.setCornerRadius(radius);
        this.mPathDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setRadius(float topLeftRadius, float topRightRadius, float bottomLeftRadius, float bottomRightRadius) {
        if (topLeftRadius == topRightRadius && topLeftRadius == bottomLeftRadius && topLeftRadius == bottomRightRadius) {
            return this.setRadius(topLeftRadius);
        }
        this.mShapeState.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius});
        this.mPathDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setSolidColor(@ColorInt int startColor, @ColorInt int endColor) {
        return this.setSolidColor(new int[]{startColor, endColor});
    }

    public ShapeDrawable setSolidColor(@ColorInt int startColor, @ColorInt int centerColor, @ColorInt int endColor) {
        return this.setSolidColor(new int[]{startColor, centerColor, endColor});
    }

    public ShapeDrawable setSolidColor(int ... colors) {
        this.mShapeState.setSolidColor(colors);
        if (colors == null) {
            this.mSolidPaint.setColor(0);
        } else if (colors.length == 1) {
            this.mSolidPaint.setColor(colors[0]);
            this.mSolidPaint.clearShadowLayer();
        }
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setSolidGradientType(int type) {
        this.mShapeState.setSolidGradientType(type);
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setSolidGradientOrientation(int orientation) {
        this.mShapeState.solidGradientOrientation = orientation;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setSolidGradientCenterX(float centerX) {
        this.mShapeState.solidCenterX = centerX;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setSolidGradientCenterY(float centerY) {
        this.mShapeState.solidCenterY = centerY;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setSolidGradientRadius(float radius) {
        this.mShapeState.gradientRadius = radius;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setStrokeColor(@ColorInt int startColor, @ColorInt int endColor) {
        return this.setStrokeColor(new int[]{startColor, endColor});
    }

    public ShapeDrawable setStrokeColor(@ColorInt int startColor, @ColorInt int centerColor, @ColorInt int endColor) {
        return this.setStrokeColor(new int[]{startColor, centerColor, endColor});
    }

    public ShapeDrawable setStrokeColor(int ... colors) {
        this.mShapeState.setStrokeColor(colors);
        if (colors == null) {
            this.mStrokePaint.setColor(0);
        } else if (colors.length == 1) {
            this.mStrokePaint.setColor(colors[0]);
            this.mStrokePaint.clearShadowLayer();
        }
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setStrokeGradientOrientation(int orientation) {
        this.mShapeState.strokeGradientOrientation = orientation;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setStrokeSize(int size) {
        this.mShapeState.setStrokeSize(size);
        this.mStrokePaint.setStrokeWidth((float)size);
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setStrokeDashSize(float dashSize) {
        this.mShapeState.strokeDashSize = dashSize;
        this.mStrokePaint.setPathEffect((PathEffect)(dashSize > 0.0f ? new DashPathEffect(new float[]{dashSize, this.mShapeState.strokeDashGap}, 0.0f) : null));
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setStrokeDashGap(float dashGap) {
        this.mShapeState.strokeDashGap = dashGap;
        this.mStrokePaint.setPathEffect((PathEffect)(this.mShapeState.strokeDashSize > 0.0f ? new DashPathEffect(new float[]{this.mShapeState.strokeDashSize, dashGap}, 0.0f) : null));
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setUseLevel(boolean useLevel) {
        this.mShapeState.useLevel = useLevel;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setShadowColor(@ColorInt int color) {
        this.mShapeState.shadowColor = color;
        this.mPathDirty = true;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setShadowSize(int size) {
        this.mShapeState.shadowSize = size;
        this.mPathDirty = true;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setShadowOffsetX(int offsetX) {
        this.mShapeState.shadowOffsetX = offsetX;
        this.mPathDirty = true;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setShadowOffsetY(int offsetY) {
        this.mShapeState.shadowOffsetY = offsetY;
        this.mPathDirty = true;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setRingInnerRadiusSize(int size) {
        this.mShapeState.ringInnerRadiusSize = size;
        this.mShapeState.ringInnerRadiusRatio = 0.0f;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setRingInnerRadiusRatio(float ratio) {
        this.mShapeState.ringInnerRadiusRatio = ratio;
        this.mShapeState.ringInnerRadiusSize = -1;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setRingThicknessSize(int size) {
        this.mShapeState.ringThicknessSize = size;
        this.mShapeState.ringThicknessRatio = 0.0f;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setRingThicknessRatio(float ratio) {
        this.mShapeState.ringThicknessRatio = ratio;
        this.mShapeState.ringThicknessSize = -1;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public ShapeDrawable setLineGravity(int lineGravity) {
        this.mShapeState.lineGravity = lineGravity;
        this.mRectDirty = true;
        this.invalidateSelf();
        return this;
    }

    public void intoBackground(View view) {
        if (this.mShapeState.strokeDashGap > 0.0f || this.mShapeState.shadowSize > 0) {
            view.setLayerType(1, null);
        }
        view.setBackground((Drawable)this);
        if (Build.VERSION.SDK_INT >= 17) {
            int layoutDirection = view.getLayoutDirection();
            if (Build.VERSION.SDK_INT >= 23) {
                this.setLayoutDirection(layoutDirection);
            }
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public void draw(@NonNull Canvas canvas) {
        boolean useLayer;
        if (!this.ensureValidRect()) {
            return;
        }
        int prevFillAlpha = this.mSolidPaint.getAlpha();
        int prevStrokeAlpha = this.mStrokePaint.getAlpha();
        int currFillAlpha = this.modulateAlpha(prevFillAlpha);
        int currStrokeAlpha = this.modulateAlpha(prevStrokeAlpha);
        boolean haveShadow = this.mShapeState.shadowSize > 0;
        boolean haveStroke = currStrokeAlpha > 0 && this.mStrokePaint.getStrokeWidth() > 0.0f;
        boolean haveFill = currFillAlpha > 0;
        ShapeState st = this.mShapeState;
        boolean bl = useLayer = haveStroke && haveFill && st.shapeType != 2 && currStrokeAlpha < 255 && (this.mAlpha < 255 || this.mColorFilter != null);
        if (useLayer) {
            if (this.mLayerPaint == null) {
                this.mLayerPaint = new Paint();
            }
            this.mLayerPaint.setDither(this.mDither);
            this.mLayerPaint.setAlpha(this.mAlpha);
            this.mLayerPaint.setColorFilter(this.mColorFilter);
            float rad = this.mStrokePaint.getStrokeWidth();
            ShapeDrawableUtils.saveCanvasLayer(canvas, this.mRect.left - rad, this.mRect.top - rad, this.mRect.right + rad, this.mRect.bottom + rad, this.mLayerPaint);
            this.mSolidPaint.setColorFilter(null);
            this.mStrokePaint.setColorFilter(null);
        } else {
            this.mSolidPaint.setAlpha(currFillAlpha);
            this.mSolidPaint.setDither(this.mDither);
            this.mSolidPaint.setColorFilter(this.mColorFilter);
            if (this.mColorFilter != null && !this.mShapeState.hasSolidColor) {
                this.mSolidPaint.setColor(this.mAlpha << 24);
            }
            if (haveStroke) {
                this.mStrokePaint.setAlpha(currStrokeAlpha);
                this.mStrokePaint.setDither(this.mDither);
                this.mStrokePaint.setColorFilter(this.mColorFilter);
            }
        }
        if (haveShadow) {
            if (this.mShadowPaint == null) {
                this.mShadowPaint = new Paint();
                this.mShadowPaint.setColor(0);
                this.mShadowPaint.setStyle(Paint.Style.STROKE);
            }
            if (haveStroke) {
                this.mShadowPaint.setStrokeWidth(this.mStrokePaint.getStrokeWidth());
            } else {
                this.mShadowPaint.setStrokeWidth((float)this.mShapeState.shadowSize / 4.0f);
            }
            int shadowColor = this.mShapeState.shadowColor;
            if (ShapeDrawableUtils.setColorAlphaComponent(this.mShapeState.shadowColor, 255) == this.mShapeState.shadowColor) {
                shadowColor = ShapeDrawableUtils.setColorAlphaComponent(this.mShapeState.shadowColor, 254);
            }
            this.mShadowPaint.setColor(shadowColor);
            float shadowRadius = Build.VERSION.SDK_INT >= 28 ? (float)this.mShapeState.shadowSize / 2.0f : (float)this.mShapeState.shadowSize / 3.0f;
            this.mShadowPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(shadowRadius, BlurMaskFilter.Blur.NORMAL));
        } else if (this.mShadowPaint != null) {
            this.mShadowPaint.clearShadowLayer();
        }
        switch (st.shapeType) {
            case 0: {
                if (st.radiusArray != null) {
                    if (this.mPathDirty || this.mRectDirty) {
                        this.mPath.reset();
                        this.mPath.addRoundRect(this.mRect, st.radiusArray, Path.Direction.CW);
                        this.mRectDirty = false;
                        this.mPathDirty = false;
                    }
                    if (haveShadow) {
                        this.mShadowPath.reset();
                        this.mShadowPath.addRoundRect(this.mShadowRect, st.radiusArray, Path.Direction.CW);
                        canvas.drawPath(this.mShadowPath, this.mShadowPaint);
                    }
                    canvas.drawPath(this.mPath, this.mSolidPaint);
                    if (!haveStroke) break;
                    canvas.drawPath(this.mPath, this.mStrokePaint);
                    break;
                }
                if (st.radius > 0.0f) {
                    float rad = st.radius;
                    float r = Math.min(this.mRect.width(), this.mRect.height()) * 0.5f;
                    if (rad > r) {
                        rad = r;
                    }
                    if (haveShadow) {
                        canvas.drawRoundRect(this.mShadowRect, rad, rad, this.mShadowPaint);
                    }
                    canvas.drawRoundRect(this.mRect, rad, rad, this.mSolidPaint);
                    if (!haveStroke) break;
                    canvas.drawRoundRect(this.mRect, rad, rad, this.mStrokePaint);
                    break;
                }
                if (haveShadow) {
                    canvas.drawRect(this.mShadowRect, this.mShadowPaint);
                }
                if (this.mSolidPaint.getColor() != 0 || this.mColorFilter != null || this.mSolidPaint.getShader() != null) {
                    canvas.drawRect(this.mRect, this.mSolidPaint);
                }
                if (!haveStroke) break;
                canvas.drawRect(this.mRect, this.mStrokePaint);
                break;
            }
            case 1: {
                if (haveShadow) {
                    canvas.drawOval(this.mShadowRect, this.mShadowPaint);
                }
                canvas.drawOval(this.mRect, this.mSolidPaint);
                if (!haveStroke) break;
                canvas.drawOval(this.mRect, this.mStrokePaint);
                break;
            }
            case 2: {
                float stopY;
                float stopX;
                float startY;
                float startX;
                int lineGravity;
                RectF r = this.mRect;
                Drawable.Callback callback = this.getCallback();
                if (Build.VERSION.SDK_INT >= 17 && callback instanceof View) {
                    int layoutDirection = ((View)callback).getContext().getResources().getConfiguration().getLayoutDirection();
                    lineGravity = Gravity.getAbsoluteGravity((int)st.lineGravity, (int)layoutDirection);
                } else {
                    lineGravity = st.lineGravity;
                }
                switch (lineGravity) {
                    case 3: {
                        startX = 0.0f;
                        startY = 0.0f;
                        stopX = 0.0f;
                        stopY = r.bottom;
                        break;
                    }
                    case 5: {
                        startX = r.right;
                        startY = 0.0f;
                        stopX = r.right;
                        stopY = r.bottom;
                        break;
                    }
                    case 48: {
                        startX = 0.0f;
                        startY = 0.0f;
                        stopX = r.right;
                        stopY = 0.0f;
                        break;
                    }
                    case 80: {
                        startX = 0.0f;
                        startY = r.bottom;
                        stopX = r.right;
                        stopY = r.bottom;
                        break;
                    }
                    default: {
                        float y = r.centerY();
                        startX = r.left;
                        startY = y;
                        stopX = r.right;
                        stopY = y;
                    }
                }
                if (haveShadow) {
                    canvas.drawLine(startX, startY, stopX, stopY, this.mShadowPaint);
                }
                canvas.drawLine(startX, startY, stopX, stopY, this.mStrokePaint);
                break;
            }
            case 3: {
                Path path = this.buildRing(st);
                if (haveShadow) {
                    canvas.drawPath(path, this.mShadowPaint);
                }
                canvas.drawPath(path, this.mSolidPaint);
                if (!haveStroke) break;
                canvas.drawPath(path, this.mStrokePaint);
                break;
            }
        }
        if (useLayer) {
            canvas.restore();
        } else {
            this.mSolidPaint.setAlpha(prevFillAlpha);
            if (haveStroke) {
                this.mStrokePaint.setAlpha(prevStrokeAlpha);
            }
        }
    }

    public boolean onLayoutDirectionChanged(int layoutDirection) {
        return this.mShapeState.shapeType == 2;
    }

    private int modulateAlpha(int alpha) {
        int scale = this.mAlpha + (this.mAlpha >> 7);
        return alpha * scale >> 8;
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mShapeState.changingConfigurations;
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setDither(boolean dither) {
        if (dither != this.mDither) {
            this.mDither = dither;
            this.invalidateSelf();
        }
    }

    public void setColorFilter(ColorFilter cf) {
        if (cf != this.mColorFilter) {
            this.mColorFilter = cf;
            this.invalidateSelf();
        }
    }

    public int getOpacity() {
        return this.mShapeState.opaque ? -1 : -3;
    }

    protected void onBoundsChange(Rect r) {
        super.onBoundsChange(r);
        this.mRingPath = null;
        this.mPathDirty = true;
        this.mRectDirty = true;
    }

    protected boolean onLevelChange(int level) {
        super.onLevelChange(level);
        this.mRectDirty = true;
        this.mPathDirty = true;
        this.invalidateSelf();
        return true;
    }

    private Path buildRing(ShapeState shapeState) {
        if (!(this.mRingPath == null || shapeState.useLevelForShape && this.mPathDirty)) {
            return this.mRingPath;
        }
        this.mPathDirty = false;
        float sweep = shapeState.useLevelForShape ? 360.0f * (float)this.getLevel() / 10000.0f : 360.0f;
        RectF bounds = new RectF(this.mRect);
        float x = bounds.width() / 2.0f;
        float y = bounds.height() / 2.0f;
        float thickness = shapeState.ringThicknessSize != -1 ? (float)shapeState.ringThicknessSize : bounds.width() / shapeState.ringThicknessRatio;
        float radius = shapeState.ringInnerRadiusSize != -1 ? (float)shapeState.ringInnerRadiusSize : bounds.width() / shapeState.ringInnerRadiusRatio;
        RectF innerBounds = new RectF(bounds);
        innerBounds.inset(x - radius, y - radius);
        bounds = new RectF(innerBounds);
        bounds.inset(-thickness, -thickness);
        if (this.mRingPath == null) {
            this.mRingPath = new Path();
        } else {
            this.mRingPath.reset();
        }
        Path ringPath = this.mRingPath;
        if (sweep < 360.0f && sweep > -360.0f) {
            ringPath.setFillType(Path.FillType.EVEN_ODD);
            ringPath.moveTo(x + radius, y);
            ringPath.lineTo(x + radius + thickness, y);
            ringPath.arcTo(bounds, 0.0f, sweep, false);
            ringPath.arcTo(innerBounds, sweep, -sweep, false);
            ringPath.close();
        } else {
            ringPath.addOval(bounds, Path.Direction.CW);
            ringPath.addOval(innerBounds, Path.Direction.CCW);
        }
        return ringPath;
    }

    private boolean ensureValidRect() {
        float shadowBottom;
        float shadowTop;
        float shadowRight;
        float shadowLet;
        if (!this.mRectDirty) {
            return !this.mRect.isEmpty();
        }
        this.mRectDirty = false;
        Rect bounds = this.getBounds();
        float inset = this.mStrokePaint.getStrokeWidth() * 0.5f;
        ShapeState st = this.mShapeState;
        float let = (float)bounds.left + inset + (float)this.mShapeState.shadowSize;
        float top = (float)bounds.top + inset + (float)this.mShapeState.shadowSize;
        float right = (float)bounds.right - inset - (float)this.mShapeState.shadowSize;
        float bottom = (float)bounds.bottom - inset - (float)this.mShapeState.shadowSize;
        this.mRect.set(let, top, right, bottom);
        if (this.mShapeState.shadowOffsetX > 0) {
            shadowLet = let + (float)this.mShapeState.shadowOffsetX;
            shadowRight = right;
        } else {
            shadowLet = let;
            shadowRight = right + (float)this.mShapeState.shadowOffsetX;
        }
        if (this.mShapeState.shadowOffsetY > 0) {
            shadowTop = top + (float)this.mShapeState.shadowOffsetY;
            shadowBottom = bottom;
        } else {
            shadowTop = top;
            shadowBottom = bottom + (float)this.mShapeState.shadowOffsetY;
        }
        this.mShadowRect.set(shadowLet, shadowTop, shadowRight, shadowBottom);
        if (st.solidColors == null) {
            this.mSolidPaint.setShader(null);
        }
        if (st.strokeColors == null) {
            this.mStrokePaint.setShader(null);
        }
        if (st.solidColors != null) {
            RectF rect = this.mRect;
            switch (st.solidGradientType) {
                case 0: {
                    float level = st.useLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    float[] coordinate = ShapeDrawableUtils.computeLinearGradientCoordinate(this.mRect, level, st.solidGradientOrientation);
                    this.mSolidPaint.setShader((Shader)new LinearGradient(coordinate[0], coordinate[1], coordinate[2], coordinate[3], st.solidColors, st.positions, Shader.TileMode.CLAMP));
                    break;
                }
                case 1: {
                    float x0 = rect.left + (rect.right - rect.left) * st.solidCenterX;
                    float y0 = rect.top + (rect.bottom - rect.top) * st.solidCenterY;
                    float level = st.useLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    this.mSolidPaint.setShader((Shader)new RadialGradient(x0, y0, level * st.gradientRadius, st.solidColors, null, Shader.TileMode.CLAMP));
                    break;
                }
                case 2: {
                    float x0 = rect.left + (rect.right - rect.left) * st.solidCenterX;
                    float y0 = rect.top + (rect.bottom - rect.top) * st.solidCenterY;
                    int[] tempSolidColors = st.solidColors;
                    float[] tempSolidPositions = null;
                    if (st.useLevel) {
                        tempSolidColors = st.tempSolidColors;
                        int length = st.solidColors.length;
                        if (tempSolidColors == null || tempSolidColors.length != length + 1) {
                            st.tempSolidColors = new int[length + 1];
                            tempSolidColors = st.tempSolidColors;
                        }
                        System.arraycopy(st.solidColors, 0, tempSolidColors, 0, length);
                        tempSolidColors[length] = st.solidColors[length - 1];
                        tempSolidPositions = st.tempSolidPositions;
                        float fraction = 1.0f / (float)(length - 1);
                        if (tempSolidPositions == null || tempSolidPositions.length != length + 1) {
                            tempSolidPositions = st.tempSolidPositions = new float[length + 1];
                        }
                        float level = (float)this.getLevel() / 10000.0f;
                        for (int i = 0; i < length; ++i) {
                            tempSolidPositions[i] = (float)i * fraction * level;
                        }
                        tempSolidPositions[length] = 1.0f;
                    }
                    this.mSolidPaint.setShader((Shader)new SweepGradient(x0, y0, tempSolidColors, tempSolidPositions));
                    break;
                }
            }
            if (!st.hasSolidColor) {
                this.mSolidPaint.setColor(-16777216);
            }
        }
        if (st.strokeColors != null) {
            float level = st.useLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
            float[] coordinate = ShapeDrawableUtils.computeLinearGradientCoordinate(this.mRect, level, st.strokeGradientOrientation);
            this.mStrokePaint.setShader((Shader)new LinearGradient(coordinate[0], coordinate[1], coordinate[2], coordinate[3], st.strokeColors, st.positions, Shader.TileMode.CLAMP));
            if (!st.hasStrokeColor) {
                this.mStrokePaint.setColor(-16777216);
            }
        }
        return !this.mRect.isEmpty();
    }

    public int getIntrinsicWidth() {
        return this.mShapeState.width;
    }

    public int getIntrinsicHeight() {
        return this.mShapeState.height;
    }

    public Drawable.ConstantState getConstantState() {
        this.mShapeState.changingConfigurations = this.getChangingConfigurations();
        return this.mShapeState;
    }

    @NonNull
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mShapeState = new ShapeState(this.mShapeState);
            this.initializeWithState(this.mShapeState);
            this.mMutated = true;
        }
        return this;
    }

    private void initializeWithState(ShapeState state) {
        if (state.hasSolidColor) {
            this.mSolidPaint.setColor(state.solidColor);
        } else if (state.solidColors == null) {
            this.mSolidPaint.setColor(0);
        } else {
            this.mSolidPaint.setColor(-16777216);
        }
        this.mPadding = state.padding;
        if (state.strokeSize >= 0) {
            if (state.hasStrokeColor) {
                this.setStrokeColor(state.strokeColor);
            } else {
                this.setStrokeColor(state.strokeColors);
            }
            this.setStrokeSize(state.strokeSize);
            this.setStrokeDashSize(state.strokeDashSize);
            this.setStrokeDashGap(state.strokeDashGap);
        }
    }
}

