/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import com.hjq.logcat.LogcatInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

final class LogcatManager {
    private static volatile Listener sListener;
    private static volatile boolean FLAG_WORK;
    private static final List<LogcatInfo> LOG_BACKUP;

    LogcatManager() {
    }

    static void start(Listener listener) {
        FLAG_WORK = true;
        new Thread(new LogRunnable()).start();
        sListener = listener;
    }

    static void resume() {
        FLAG_WORK = true;
        Listener listener = sListener;
        if (listener != null && !LOG_BACKUP.isEmpty()) {
            for (LogcatInfo info : LOG_BACKUP) {
                if (info == null) continue;
                listener.onReceiveLog(info);
            }
        }
        LOG_BACKUP.clear();
    }

    static void pause() {
        FLAG_WORK = false;
    }

    static void destroy() {
        FLAG_WORK = false;
        sListener = null;
    }

    static void clear() {
        try {
            new ProcessBuilder("logcat", "-c").start();
            FLAG_WORK = true;
            new Thread(new LogRunnable()).start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        LOG_BACKUP = new ArrayList<LogcatInfo>();
    }

    public static interface Listener {
        public void onReceiveLog(LogcatInfo var1);
    }

    private static class LogRunnable
    implements Runnable {
        private LogRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            BufferedReader reader = null;
            try {
                String line;
                Process process = new ProcessBuilder("logcat", "-v", "threadtime").start();
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    Class<LogcatManager> clazz = LogcatManager.class;
                    // MONITORENTER : com.hjq.logcat.LogcatManager.class
                    if (LogcatInfo.IGNORED_LOG.contains(line)) {
                        // MONITOREXIT : clazz
                        continue;
                    }
                    LogcatInfo info = LogcatInfo.create(line);
                    if (info == null) {
                        // MONITOREXIT : clazz
                        continue;
                    }
                    if (FLAG_WORK) {
                        Listener listener = sListener;
                        if (listener != null) {
                            listener.onReceiveLog(info);
                        }
                    } else {
                        LOG_BACKUP.add(info);
                    }
                    // MONITOREXIT : clazz
                }
                LogcatManager.pause();
                return;
            }
            catch (IOException ignored) {
                LogcatManager.pause();
                return;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

