/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class LogcatInfo {
    private static final String LINE_SPACE = "\n    ";
    private static final Pattern PATTERN = Pattern.compile("([0-9^-]+-[0-9^ ]+\\s[0-9^:]+:[0-9^:]+\\.[0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s([VDIWEF])\\s([^\\s]*)\\s*:\\s(.*)");
    static final ArrayList<String> IGNORED_LOG = new ArrayList<String>(){
        {
            this.add("--------- beginning of crash");
            this.add("--------- beginning of main");
            this.add("--------- beginning of system");
        }
    };
    private String time;
    private String level;
    private String tag;
    private String log;
    private String pid;

    static LogcatInfo create(String line) {
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        LogcatInfo info = new LogcatInfo();
        info.time = matcher.group(1);
        info.pid = matcher.group(3);
        info.level = matcher.group(4);
        info.tag = matcher.group(5);
        info.log = matcher.group(6);
        return info;
    }

    private LogcatInfo() {
    }

    String getTime() {
        return this.time;
    }

    String getLevel() {
        return this.level;
    }

    String getTag() {
        return this.tag;
    }

    String getLog() {
        return this.log;
    }

    String getPid() {
        return this.pid;
    }

    void addLog(String text) {
        this.log = (this.log.startsWith(LINE_SPACE) ? "" : LINE_SPACE) + this.log + LINE_SPACE + text;
    }

    public String toString() {
        return String.format("%s   %s   %s", this.time, this.tag, this.log);
    }
}

