/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import com.hjq.logcat.LogcatInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

final class LogcatManager {
    private static Listener sListener;
    private static boolean FLAG_WORK;

    LogcatManager() {
    }

    static void setListener(Listener listener) {
        sListener = listener;
    }

    static void start() {
        if (!FLAG_WORK) {
            FLAG_WORK = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedReader reader = null;
                    try {
                        String line;
                        Process process = new ProcessBuilder("logcat", "-v", "threadtime").start();
                        reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        while (FLAG_WORK && (line = reader.readLine()) != null) {
                            if (LogcatInfo.IGNORED_LOG.contains(line)) continue;
                            try {
                                if (sListener == null) continue;
                                sListener.onReceiveLog(line);
                            }
                            catch (IllegalStateException | NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        LogcatManager.stop();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        LogcatManager.stop();
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
        }
    }

    static void stop() {
        FLAG_WORK = false;
    }

    static void clear() {
        try {
            new ProcessBuilder("logcat", "-c").start();
            LogcatManager.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface Listener {
        public void onReceiveLog(String var1);
    }
}

