/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class LogcatInfo {
    private static final Pattern PATTERN = Pattern.compile("([0-9^-]+-[0-9^ ]+ [0-9^:]+:[0-9^:]+\\.[0-9]+) +([0-9]+) +([0-9]+) ([VDIWEF]) ([^ ]*) *: (.*)");
    static final ArrayList<String> IGNORED_LOG = new ArrayList<String>(){
        {
            this.add("--------- beginning of crash");
            this.add("--------- beginning of main");
            this.add("--------- beginning of system");
        }
    };
    private String time;
    private String level;
    private String tag;
    private String log;

    LogcatInfo(String line) {
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.find()) {
            throw new IllegalStateException("logcat pattern not match: " + line);
        }
        this.time = matcher.group(1);
        this.level = matcher.group(4);
        this.tag = matcher.group(5);
        this.log = matcher.group(6);
    }

    String getTime() {
        return this.time;
    }

    String getLevel() {
        return this.level;
    }

    String getTag() {
        return this.tag;
    }

    String getLog() {
        return this.log;
    }

    void addLog(String text) {
        this.log = (this.log.startsWith("\n\t\t\t\t") ? "" : "\n\t\t\t\t") + this.log + "\n\t\t\t\t" + text;
    }
}

