/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.AdapterView;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.hjq.logcat.ChooseWindow;
import com.hjq.logcat.LogcatAdapter;
import com.hjq.logcat.LogcatConfig;
import com.hjq.logcat.LogcatInfo;
import com.hjq.logcat.LogcatManager;
import com.hjq.logcat.R;
import com.hjq.xtoast.XToast;
import java.util.ArrayList;
import java.util.List;

public final class LogcatActivity
extends Activity
implements View.OnLongClickListener,
View.OnClickListener,
CompoundButton.OnCheckedChangeListener,
LogcatManager.Listener,
AdapterView.OnItemLongClickListener,
AdapterView.OnItemClickListener,
TextWatcher {
    private static final String[] ARRAY_LOG_LEVEL = new String[]{"Verbose", "Debug", "Info", "Warn", "Error"};
    private List<LogcatInfo> mLogData = new ArrayList<LogcatInfo>();
    private CheckBox mSwitchView;
    private TextView mLevelView;
    private EditText mSearchView;
    private View mCleanView;
    private View mCloseView;
    private ListView mListView;
    private LogcatAdapter mAdapter;
    private String mLogLevel = "V";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.logcat_window_logcat);
        this.mSwitchView = (CheckBox)this.findViewById(R.id.iv_log_switch);
        this.mLevelView = (TextView)this.findViewById(R.id.tv_log_level);
        this.mSearchView = (EditText)this.findViewById(R.id.et_log_search);
        this.mCleanView = this.findViewById(R.id.iv_log_clean);
        this.mCloseView = this.findViewById(R.id.iv_log_close);
        this.mListView = (ListView)this.findViewById(R.id.lv_log_list);
        this.mAdapter = new LogcatAdapter();
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mListView.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
        this.mSwitchView.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.mSearchView.addTextChangedListener((TextWatcher)this);
        this.mSearchView.setText((CharSequence)LogcatConfig.getLogcatText());
        this.setLogLevel(LogcatConfig.getLogcatLevel());
        this.mLevelView.setOnClickListener((View.OnClickListener)this);
        this.mCleanView.setOnClickListener((View.OnClickListener)this);
        this.mCloseView.setOnClickListener((View.OnClickListener)this);
        this.mSwitchView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mLevelView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mCleanView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mCloseView.setOnLongClickListener((View.OnLongClickListener)this);
        LogcatManager.setListener(this);
        LogcatManager.start();
        this.mListView.postDelayed(new Runnable(){

            @Override
            public void run() {
                LogcatActivity.this.mListView.setSelection(LogcatActivity.this.mAdapter.getCount() - 1);
            }
        }, 1000L);
    }

    @Override
    public void onReceiveLog(String line) {
        this.mListView.post((Runnable)new LogRunnable(new LogcatInfo(line)));
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mAdapter.onItemClick(position);
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, final int location, long id2) {
        new ChooseWindow(this).setList("\u590d\u5236\u65e5\u5fd7", "\u5206\u4eab\u65e5\u5fd7").setListener(new ChooseWindow.OnListener(){

            @Override
            public void onSelected(int position) {
                switch (position) {
                    case 0: {
                        ClipboardManager manager = (ClipboardManager)LogcatActivity.this.getSystemService("clipboard");
                        if (manager == null) break;
                        manager.setPrimaryClip(ClipData.newPlainText((CharSequence)"log", (CharSequence)LogcatActivity.this.mAdapter.getItem(location).getLog()));
                        LogcatActivity.this.toast("\u65e5\u5fd7\u590d\u5236\u6210\u529f");
                        break;
                    }
                    case 1: {
                        Intent intent = new Intent("android.intent.action.SEND");
                        intent.setType("text/plain");
                        intent.putExtra("android.intent.extra.TEXT", LogcatActivity.this.mAdapter.getItem(location).getLog());
                        LogcatActivity.this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\u5206\u4eab\u6587\u672c"));
                        break;
                    }
                }
            }
        }).show();
        return true;
    }

    public boolean onLongClick(View v) {
        if (v == this.mSwitchView) {
            this.toast("\u65e5\u5fd7\u6355\u83b7\u5f00\u5173");
        } else if (v == this.mLevelView) {
            this.toast("\u65e5\u5fd7\u7b49\u7ea7\u8fc7\u6ee4");
        } else if (v == this.mCleanView) {
            this.toast("\u6e05\u7a7a\u65e5\u5fd7");
        } else if (v == this.mCloseView) {
            this.toast("\u5173\u95ed\u663e\u793a");
        }
        return true;
    }

    public void onClick(View view) {
        if (view == this.mLevelView) {
            new ChooseWindow(this).setList(ARRAY_LOG_LEVEL).setListener(new ChooseWindow.OnListener(){

                @Override
                public void onSelected(int position) {
                    switch (position) {
                        case 0: {
                            LogcatActivity.this.setLogLevel("V");
                            break;
                        }
                        case 1: {
                            LogcatActivity.this.setLogLevel("D");
                            break;
                        }
                        case 2: {
                            LogcatActivity.this.setLogLevel("I");
                            break;
                        }
                        case 3: {
                            LogcatActivity.this.setLogLevel("W");
                            break;
                        }
                        case 4: {
                            LogcatActivity.this.setLogLevel("E");
                            break;
                        }
                    }
                }
            }).show();
        } else if (view == this.mCleanView) {
            LogcatManager.clear();
            this.mAdapter.clearData();
        } else if (view == this.mCloseView) {
            this.onBackPressed();
        }
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (isChecked) {
            this.toast("\u65e5\u5fd7\u6355\u6349\u5df2\u6682\u505c");
            LogcatManager.stop();
        } else {
            LogcatManager.start();
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        String keyword = s.toString().trim();
        LogcatConfig.setLogcatText(keyword);
        this.mAdapter.setKeyword(keyword);
        this.mAdapter.clearData();
        for (LogcatInfo info : this.mLogData) {
            if (!"V".equals(this.mLogLevel) && !info.getLevel().equals(this.mLogLevel)) continue;
            if (!"".equals(keyword)) {
                if (!info.getLog().contains(keyword) && !info.getTag().contains(keyword)) continue;
                this.mAdapter.addItem(info);
                continue;
            }
            this.mAdapter.addItem(info);
        }
        this.mListView.setSelection(this.mAdapter.getCount() - 1);
    }

    private void setLogLevel(String level) {
        if (!level.equals(this.mLogLevel)) {
            this.mLogLevel = level;
            LogcatConfig.setLogcatLevel(level);
            this.afterTextChanged(this.mSearchView.getText());
            switch (level) {
                case "V": {
                    this.mLevelView.setText((CharSequence)ARRAY_LOG_LEVEL[0]);
                    break;
                }
                case "D": {
                    this.mLevelView.setText((CharSequence)ARRAY_LOG_LEVEL[1]);
                    break;
                }
                case "I": {
                    this.mLevelView.setText((CharSequence)ARRAY_LOG_LEVEL[2]);
                    break;
                }
                case "W": {
                    this.mLevelView.setText((CharSequence)ARRAY_LOG_LEVEL[3]);
                    break;
                }
                case "E": {
                    this.mLevelView.setText((CharSequence)ARRAY_LOG_LEVEL[4]);
                    break;
                }
            }
        }
    }

    private void toast(CharSequence text) {
        new XToast((Activity)this).setView(R.layout.logcat_window_toast).setDuration(3000).setGravity(17).setAnimStyle(16973828).setText(16908299, text).show();
    }

    public void onBackPressed() {
        this.moveTaskToBack(false);
    }

    private class LogRunnable
    implements Runnable {
        private LogcatInfo info;

        private LogRunnable(LogcatInfo info) {
            this.info = info;
        }

        @Override
        public void run() {
            if (LogcatActivity.this.mLogData.size() > 0) {
                LogcatInfo lastInfo = (LogcatInfo)LogcatActivity.this.mLogData.get(LogcatActivity.this.mLogData.size() - 1);
                if (this.info.getLevel().equals(lastInfo.getLevel()) && this.info.getTag().equals(lastInfo.getTag())) {
                    lastInfo.addLog(this.info.getLog());
                    LogcatActivity.this.mAdapter.notifyDataSetChanged();
                    return;
                }
            }
            LogcatActivity.this.mLogData.add(this.info);
            String content = LogcatActivity.this.mSearchView.getText().toString();
            if ("".equals(content) && "V".equals(LogcatActivity.this.mLogLevel)) {
                LogcatActivity.this.mAdapter.addItem(this.info);
            } else if (this.info.getLevel().equals(LogcatActivity.this.mLogLevel) && (this.info.getLog().contains(content) || this.info.getTag().contains(content))) {
                LogcatActivity.this.mAdapter.addItem(this.info);
            }
        }
    }
}

