/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.Display;
import android.view.WindowManager;
import com.hjq.logcat.LogcatInfo;
import com.hjq.logcat.R;
import com.hjq.window.EasyWindow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

final class LogcatUtils {
    private static final String FILE_TYPE = "Logcat";
    private static final String LOGCAT_TAG_FILTER_FILE = "logcat_tag_filter.txt";
    private static final Charset CHARSET_UTF_8 = Build.VERSION.SDK_INT >= 19 ? StandardCharsets.UTF_8 : Charset.forName("UTF-8");

    LogcatUtils() {
    }

    static boolean isPortrait(Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }

    static boolean isActivityReverse(Activity activity) {
        int activityRotation = 0;
        if (Build.VERSION.SDK_INT >= 30) {
            Display display = activity.getDisplay();
            if (display != null) {
                activityRotation = display.getRotation();
            }
        } else {
            WindowManager windowManager = activity.getWindowManager();
            Display defaultDisplay = null;
            if (windowManager != null) {
                defaultDisplay = windowManager.getDefaultDisplay();
            }
            if (defaultDisplay != null) {
                activityRotation = defaultDisplay.getRotation();
            }
        }
        switch (activityRotation) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    static int getStatusBarHeight(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    @Nullable
    static Boolean getMetaBooleanData(Context context, String metaKey) {
        try {
            Bundle metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (metaData != null && metaData.containsKey(metaKey)) {
                return Boolean.parseBoolean(String.valueOf(metaData.get(metaKey)));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    static String getMetaStringData(Context context, String metaKey) {
        try {
            Bundle metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (metaData != null && metaData.containsKey(metaKey)) {
                return String.valueOf(metaData.get(metaKey));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    static void toast(Activity activity, int stringId) {
        LogcatUtils.toast(activity, activity.getResources().getString(stringId));
    }

    static void toast(Activity activity, CharSequence text) {
        EasyWindow.with((Activity)activity).setContentView(R.layout.logcat_window_toast).setWindowDuration(3000).setWindowLocation(17, 0, 0).setWindowAnim(16973828).setTextByTextView(16908299, text).show();
    }

    static File saveLogToFile(Context context, List<LogcatInfo> data) throws IOException {
        File file;
        File directory = context.getExternalFilesDir(FILE_TYPE);
        if (directory == null) {
            throw new IOException("The file does not exist.");
        }
        if (!directory.isDirectory()) {
            directory.delete();
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!(file = new File(directory, new SimpleDateFormat("yyyyMMdd_kkmmss", Locale.getDefault()).format(new Date()) + ".txt")).isFile()) {
            file.delete();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), CHARSET_UTF_8));
        for (LogcatInfo info : data) {
            writer.write(info.toString().replace("\n", "\r\n") + "\r\n\r\n");
        }
        writer.flush();
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    static List<String> readTagFilter(Context context) throws IOException {
        String tag;
        ArrayList<String> tagFilter = new ArrayList<String>();
        File file = new File(context.getExternalFilesDir(FILE_TYPE), LOGCAT_TAG_FILTER_FILE);
        if (!file.exists() || !file.isFile()) {
            return tagFilter;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CHARSET_UTF_8));
        while ((tag = reader.readLine()) != null) {
            if (tag.isEmpty() || tagFilter.contains(tag)) continue;
            tagFilter.add(tag);
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tagFilter;
    }

    static File writeTagFilter(Context context, List<String> tagFilter) throws IOException {
        File directory = context.getExternalFilesDir(FILE_TYPE);
        if (directory == null) {
            throw new IOException("The file does not exist.");
        }
        File file = new File(directory, LOGCAT_TAG_FILTER_FILE);
        if (tagFilter == null || tagFilter.isEmpty()) {
            return file;
        }
        if (!file.isFile()) {
            file.delete();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), CHARSET_UTF_8));
        for (String temp : tagFilter) {
            writer.write(temp + "\r\n");
        }
        writer.flush();
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public static String computeMD5Hash(String string2) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string2.getBytes(CHARSET_UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }
}

