/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.content.Context;
import android.support.annotation.Nullable;
import com.hjq.logcat.LogcatUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class LogcatInfo {
    static final String SPACE = "  ";
    static final String LINE_SPACE = "\n  ";
    private static final String LOG_SEPARATOR = "\\s{1,4}";
    private static final String LOG_TIME = "([0-9^-]+-[0-9^ ]+\\s[0-9^:]+:[0-9^:]+\\.[0-9]+)";
    private static final String LOG_UID = "(.*)";
    private static final String LOG_PID = "([0-9]+)";
    private static final String LOG_TID = "([0-9]+)";
    private static final String LOG_LEVEL = "([VDIWEF])";
    private static final String LOG_TAG = "([^:]*):";
    private static final String LOG_CONTENT = "(.*)";
    private static final Pattern LOG_PATTERN_DEFAULT = Pattern.compile("([0-9^-]+-[0-9^ ]+\\s[0-9^:]+:[0-9^:]+\\.[0-9]+)\\s{1,4}([0-9]+)\\s{1,4}([0-9]+)\\s{1,4}([VDIWEF])\\s{1,4}([^:]*):\\s{1,4}(.*)");
    private static final Pattern LOG_PATTERN_ADD_UID = Pattern.compile("([0-9^-]+-[0-9^ ]+\\s[0-9^:]+:[0-9^:]+\\.[0-9]+)\\s{1,4}(.*)\\s{1,4}([0-9]+)\\s{1,4}([0-9]+)\\s{1,4}([VDIWEF])\\s{1,4}([^:]*):\\s{1,4}(.*)");
    static final ArrayList<String> IGNORED_LOG = new ArrayList<String>(){
        {
            this.add("--------- beginning of crash");
            this.add("--------- beginning of main");
            this.add("--------- beginning of system");
        }
    };
    private String time;
    @Nullable
    private String uid;
    private String tid;
    private String pid;
    private String level;
    private String tag;
    private String content;

    static LogcatInfo create(String line, boolean obtainUid) {
        if (line == null) {
            return null;
        }
        Matcher matcher = obtainUid ? LOG_PATTERN_ADD_UID.matcher(line) : LOG_PATTERN_DEFAULT.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        LogcatInfo info = new LogcatInfo();
        info.time = matcher.group(1);
        if (obtainUid) {
            info.uid = matcher.group(2);
            info.pid = matcher.group(3);
            info.tid = matcher.group(4);
            info.level = matcher.group(5);
            info.tag = matcher.group(6);
            info.content = matcher.group(7);
        } else {
            info.pid = matcher.group(2);
            info.tid = matcher.group(3);
            info.level = matcher.group(4);
            info.tag = matcher.group(5);
            info.content = matcher.group(6);
        }
        return info;
    }

    private LogcatInfo() {
    }

    String getTime() {
        return this.time;
    }

    @Nullable
    String getUid() {
        return this.uid;
    }

    String getPid() {
        return this.pid;
    }

    String getTid() {
        return this.tid;
    }

    String getLevel() {
        return this.level;
    }

    String getTag() {
        return this.tag;
    }

    String getContent() {
        return this.content;
    }

    void addLogContent(String text) {
        this.content = (this.content.startsWith(LINE_SPACE) ? "" : LINE_SPACE) + this.content + LINE_SPACE + text;
    }

    public String toString() {
        return String.format("%s  %s  %s", this.time, this.tag, this.content);
    }

    public String toString(Context context) {
        if (!LogcatUtils.isPortrait(context)) {
            return this.toString();
        }
        String log = this.getContent();
        return String.format("%s  %s" + (log.startsWith("\n") ? SPACE : "\n") + "%s", this.time, this.tag, log);
    }
}

