/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.v4.app.NotificationManagerCompat;
import android.widget.Toast;
import com.hjq.logcat.ForegroundServiceStartTask;
import com.hjq.logcat.LogcatConfig;
import com.hjq.logcat.LogcatDispatcher;
import com.hjq.logcat.LogcatUtils;
import com.hjq.logcat.R;

public final class LogcatProvider
extends ContentProvider {
    public boolean onCreate() {
        Context context = this.getContext();
        if (context != null) {
            Boolean notifyEntrance = LogcatUtils.getMetaBooleanData(context, "LogcatNotifyEntrance");
            Boolean windowEntrance = LogcatUtils.getMetaBooleanData(context, "LogcatWindowEntrance");
            if (notifyEntrance == null && windowEntrance == null) {
                if (NotificationManagerCompat.from((Context)context).areNotificationsEnabled()) {
                    notifyEntrance = true;
                } else {
                    windowEntrance = true;
                }
            }
            if (notifyEntrance != null && notifyEntrance.booleanValue()) {
                LogcatConfig.init(context.getApplicationContext());
                if (context instanceof Application) {
                    ForegroundServiceStartTask.with((Application)context);
                }
            }
            if (windowEntrance != null && windowEntrance.booleanValue()) {
                if (context instanceof Application) {
                    LogcatDispatcher.with((Application)context);
                } else {
                    Toast.makeText((Context)context, (int)R.string.logcat_launch_error, (int)1).show();
                }
            }
        }
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }
}

