/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import com.hjq.logcat.LogcatInfo;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

final class LogcatManager {
    private static volatile Callback sCallback;
    private static volatile boolean FLAG_WORK;
    private static final List<LogcatInfo> LOG_BACKUP;

    LogcatManager() {
    }

    static void start(Callback callback) {
        FLAG_WORK = true;
        new Thread(new LogRunnable()).start();
        sCallback = callback;
    }

    static void resume() {
        FLAG_WORK = true;
        Callback callback = sCallback;
        if (callback != null && !LOG_BACKUP.isEmpty()) {
            for (LogcatInfo info : LOG_BACKUP) {
                if (info == null) continue;
                callback.onReceiveLog(info);
            }
        }
        LOG_BACKUP.clear();
    }

    static void pause() {
        FLAG_WORK = false;
    }

    static void destroy() {
        FLAG_WORK = false;
        sCallback = null;
    }

    static void clear() {
        try {
            new ProcessBuilder("logcat", "-c").start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static BufferedReader createLogcatBufferedReader() throws IOException {
        Process process = new ProcessBuilder("logcat", "-v", "threadtime").start();
        return new BufferedReader(new InputStreamReader(process.getInputStream()));
    }

    private static void closeStream(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        LOG_BACKUP = new ArrayList<LogcatInfo>();
    }

    public static interface Callback {
        public void onReceiveLog(LogcatInfo var1);
    }

    private static class LogRunnable
    implements Runnable {
        private LogRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            BufferedReader reader = null;
            while (true) {
                String line;
                Class<LogcatManager> clazz = LogcatManager.class;
                // MONITORENTER : com.hjq.logcat.LogcatManager.class
                if (reader == null) {
                    try {
                        reader = LogcatManager.createLogcatBufferedReader();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        // MONITOREXIT : clazz
                        return;
                    }
                }
                try {
                    line = reader.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LogcatManager.closeStream(reader);
                    // MONITOREXIT : clazz
                    return;
                }
                if (line == null) {
                    try {
                        LogcatManager.closeStream(reader);
                        reader = null;
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (LogcatInfo.IGNORED_LOG.contains(line)) {
                    // MONITOREXIT : clazz
                    continue;
                }
                LogcatInfo info = LogcatInfo.create(line);
                if (info == null) {
                    // MONITOREXIT : clazz
                    continue;
                }
                if (!FLAG_WORK) {
                    LOG_BACKUP.add(info);
                    // MONITOREXIT : clazz
                    continue;
                }
                Callback callback = sCallback;
                if (callback != null) {
                    callback.onReceiveLog(info);
                }
                // MONITOREXIT : clazz
            }
        }
    }
}

