/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;
import com.hjq.logcat.LogcatActivity;
import com.hjq.logcat.R;

public final class LogcatService
extends Service {
    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Intent notificationIntent = new Intent((Context)this, LogcatActivity.class);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)notificationIntent, (int)0);
        String applicationName = this.getApplicationName();
        if (TextUtils.isEmpty((CharSequence)applicationName)) {
            applicationName = this.getPackageName();
        }
        Notification.Builder builder = new Notification.Builder((Context)this).setLargeIcon(BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.logcat_floating_normal)).setContentTitle((CharSequence)this.getString(R.string.logcat_notify_title)).setContentText((CharSequence)this.getString(R.string.logcat_notify_content, new Object[]{applicationName})).setSmallIcon(R.drawable.logcat_floating_pressed).setContentIntent(pendingIntent);
        if (Build.VERSION.SDK_INT >= 26) {
            String notificationChannelId = "logcat";
            NotificationChannel channel = new NotificationChannel(notificationChannelId, (CharSequence)this.getString(R.string.logcat_notify_channel_name), 1);
            channel.setDescription(this.getString(R.string.logcat_notify_channel_description));
            channel.setImportance(1);
            channel.enableVibration(false);
            channel.enableLights(false);
            NotificationManager manager = (NotificationManager)this.getSystemService("notification");
            manager.createNotificationChannel(channel);
            builder.setChannelId(notificationChannelId);
        } else {
            builder.setSound(null);
            builder.setVibrate(null);
            builder.setLights(0, 0, 0);
        }
        this.startForeground(2, builder.build());
        return super.onStartCommand(intent, flags, startId);
    }

    private String getApplicationName() {
        PackageManager packageManager = this.getPackageManager();
        try {
            return packageManager.getApplicationLabel(packageManager.getApplicationInfo(this.getPackageName(), 128)).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }
}

