/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.element;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.hjq.gson.factory.GsonFactory;
import com.hjq.gson.factory.ParseExceptionCallback;
import com.hjq.gson.factory.element.TypeAdapterRuntimeTypeWrapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

public class MapTypeAdapter<K, V>
extends TypeAdapter<Map<K, V>> {
    private final TypeAdapter<K> mKeyTypeAdapter;
    private final TypeAdapter<V> mValueTypeAdapter;
    private final ObjectConstructor<? extends Map<K, V>> mConstructor;
    private final boolean mComplexMapKeySerialization;
    private TypeToken<?> mTypeToken;
    private String mFieldName;

    public MapTypeAdapter(Gson context, Type keyType, TypeAdapter<K> keyTypeAdapter, Type valueType, TypeAdapter<V> valueTypeAdapter, ObjectConstructor<? extends Map<K, V>> constructor, boolean complexMapKeySerialization) {
        this.mKeyTypeAdapter = new TypeAdapterRuntimeTypeWrapper<K>(context, keyTypeAdapter, keyType);
        this.mValueTypeAdapter = new TypeAdapterRuntimeTypeWrapper<V>(context, valueTypeAdapter, valueType);
        this.mConstructor = constructor;
        this.mComplexMapKeySerialization = complexMapKeySerialization;
    }

    public void setReflectiveType(TypeToken<?> typeToken, String fieldName) {
        this.mTypeToken = typeToken;
        this.mFieldName = fieldName;
    }

    public Map<K, V> read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        Map map = (Map)this.mConstructor.construct();
        if (jsonToken == JsonToken.NULL) {
            in.nextNull();
            return map;
        }
        if (jsonToken == JsonToken.BEGIN_ARRAY) {
            in.beginArray();
            while (in.hasNext()) {
                if (in.peek() == JsonToken.BEGIN_ARRAY) {
                    in.beginArray();
                    Object key = this.mKeyTypeAdapter.read(in);
                    Object value = this.mValueTypeAdapter.read(in);
                    map.put(key, value);
                    in.endArray();
                    continue;
                }
                in.skipValue();
                ParseExceptionCallback callback = GsonFactory.getParseExceptionCallback();
                if (callback == null) continue;
                callback.onParseObjectException(this.mTypeToken, this.mFieldName, jsonToken);
            }
            in.endArray();
        } else if (jsonToken == JsonToken.BEGIN_OBJECT) {
            in.beginObject();
            while (in.hasNext()) {
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                JsonToken itemJsonToken = null;
                Object key = null;
                try {
                    key = this.mKeyTypeAdapter.read(in);
                    itemJsonToken = in.peek();
                    Object value = this.mValueTypeAdapter.read(in);
                    map.put(key, value);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    ParseExceptionCallback callback = GsonFactory.getParseExceptionCallback();
                    if (callback == null) continue;
                    callback.onParseMapItemException(this.mTypeToken, this.mFieldName, String.valueOf(key), itemJsonToken);
                }
            }
            in.endObject();
        } else {
            in.skipValue();
            ParseExceptionCallback callback = GsonFactory.getParseExceptionCallback();
            if (callback != null) {
                callback.onParseObjectException(this.mTypeToken, this.mFieldName, jsonToken);
            }
        }
        return map;
    }

    public void write(JsonWriter out, Map<K, V> map) throws IOException {
        JsonElement keyElement;
        if (map == null) {
            out.nullValue();
            return;
        }
        if (!this.mComplexMapKeySerialization) {
            out.beginObject();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                out.name(String.valueOf(entry.getKey()));
                this.mValueTypeAdapter.write(out, entry.getValue());
            }
            out.endObject();
            return;
        }
        boolean hasComplexKeys = false;
        ArrayList<JsonElement> keys = new ArrayList<JsonElement>(map.size());
        ArrayList<V> values = new ArrayList<V>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keyElement = this.mKeyTypeAdapter.toJsonTree(entry.getKey());
            keys.add(keyElement);
            values.add(entry.getValue());
            hasComplexKeys |= keyElement.isJsonArray() || keyElement.isJsonObject();
        }
        if (hasComplexKeys) {
            out.beginArray();
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                out.beginArray();
                Streams.write((JsonElement)((JsonElement)keys.get(i)), (JsonWriter)out);
                this.mValueTypeAdapter.write(out, values.get(i));
                out.endArray();
            }
            out.endArray();
        } else {
            out.beginObject();
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                keyElement = (JsonElement)keys.get(i);
                out.name(this.keyToString(keyElement));
                this.mValueTypeAdapter.write(out, values.get(i));
            }
            out.endObject();
        }
    }

    private String keyToString(JsonElement keyElement) {
        if (keyElement.isJsonPrimitive()) {
            JsonPrimitive primitive = keyElement.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return String.valueOf(primitive.getAsNumber());
            }
            if (primitive.isBoolean()) {
                return Boolean.toString(primitive.getAsBoolean());
            }
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            throw new AssertionError();
        }
        if (keyElement.isJsonNull()) {
            return "null";
        }
        throw new AssertionError();
    }
}

