/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.element;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.hjq.gson.factory.constructor.MainConstructor;
import com.hjq.gson.factory.element.CollectionTypeAdapter;
import com.hjq.gson.factory.element.MapTypeAdapter;
import com.hjq.gson.factory.element.ReflectiveFieldBound;
import com.hjq.gson.factory.element.ReflectiveTypeAdapter;
import com.hjq.gson.factory.element.TypeAdapterRuntimeTypeWrapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class ReflectiveTypeUtils {
    private static final ArrayList<Class<?>> TYPE_TOKENS = new ArrayList();

    public static boolean containsClass(Class<?> clazz) {
        return TYPE_TOKENS.contains(clazz);
    }

    public static ReflectiveFieldBound createBoundField(final Gson gson, final MainConstructor constructor, final Field field, final String fieldName, final TypeToken<?> fieldType, boolean serialize, boolean deserialize) {
        return new ReflectiveFieldBound(fieldName, serialize, deserialize){
            final TypeAdapter<?> typeAdapter;
            {
                super(name, serialized, deserialized);
                this.typeAdapter = ReflectiveTypeUtils.getFieldAdapter(gson, constructor, field, fieldType, fieldName);
            }

            @Override
            public void write(JsonWriter writer, Object value) throws IOException, IllegalAccessException {
                Object fieldValue = field.get(value);
                TypeAdapterRuntimeTypeWrapper typeWrapper = new TypeAdapterRuntimeTypeWrapper(gson, this.typeAdapter, fieldType.getType());
                typeWrapper.write(writer, fieldValue);
            }

            @Override
            public void read(JsonReader reader, Object value) throws IOException, IllegalAccessException {
                Object fieldValue = this.typeAdapter.read(reader);
                if (fieldValue == null) {
                    return;
                }
                field.set(value, fieldValue);
            }

            @Override
            public boolean writeField(Object value) throws IOException, IllegalAccessException {
                if (!this.isSerialized()) {
                    return false;
                }
                Object fieldValue = field.get(value);
                return fieldValue != value;
            }
        };
    }

    public static TypeAdapter<?> getFieldAdapter(Gson gson, MainConstructor constructor, Field field, TypeToken<?> fieldType, String fieldName) {
        TypeAdapter adapter = null;
        JsonAdapter annotation = field.getAnnotation(JsonAdapter.class);
        if (annotation != null) {
            adapter = ReflectiveTypeUtils.getTypeAdapter(constructor, gson, fieldType, annotation);
        }
        if (adapter == null) {
            adapter = gson.getAdapter(fieldType);
        }
        if (adapter instanceof CollectionTypeAdapter) {
            ((CollectionTypeAdapter)adapter).setReflectiveType(TypeToken.get(field.getDeclaringClass()), fieldName);
        }
        if (adapter instanceof ReflectiveTypeAdapter) {
            ((ReflectiveTypeAdapter)adapter).setReflectiveType(TypeToken.get(field.getDeclaringClass()), fieldName);
        }
        if (adapter instanceof MapTypeAdapter) {
            ((MapTypeAdapter)adapter).setReflectiveType(TypeToken.get(field.getDeclaringClass()), fieldName);
        }
        return adapter;
    }

    public static TypeAdapter<?> getTypeAdapter(MainConstructor constructor, Gson gson, TypeToken<?> fieldType, JsonAdapter annotation) {
        TypeAdapter typeAdapter;
        Class value = annotation.value();
        if (TypeAdapter.class.isAssignableFrom(value)) {
            Class typeAdapterClass = value;
            typeAdapter = (TypeAdapter)constructor.get(TypeToken.get((Class)typeAdapterClass)).construct();
        } else if (TypeAdapterFactory.class.isAssignableFrom(value)) {
            Class typeAdapterFactory = value;
            typeAdapter = ((TypeAdapterFactory)constructor.get(TypeToken.get((Class)typeAdapterFactory)).construct()).create(gson, fieldType);
        } else {
            throw new IllegalArgumentException("@JsonAdapter value must be TypeAdapter or TypeAdapterFactory reference.");
        }
        if (typeAdapter != null) {
            typeAdapter = typeAdapter.nullSafe();
        }
        return typeAdapter;
    }

    public static List<String> getFieldNames(FieldNamingStrategy fieldNamingPolicy, Field field) {
        SerializedName annotation = field.getAnnotation(SerializedName.class);
        if (annotation == null) {
            String name = fieldNamingPolicy.translateName(field);
            return Collections.singletonList(name);
        }
        String serializedName = annotation.value();
        String[] alternates = annotation.alternate();
        if (alternates.length == 0) {
            return Collections.singletonList(serializedName);
        }
        ArrayList<String> fieldNames = new ArrayList<String>(alternates.length + 1);
        fieldNames.add(serializedName);
        Collections.addAll(fieldNames, alternates);
        return fieldNames;
    }

    static {
        TYPE_TOKENS.add(String.class);
        TYPE_TOKENS.add(Integer.class);
        TYPE_TOKENS.add(Boolean.class);
        TYPE_TOKENS.add(Byte.class);
        TYPE_TOKENS.add(Short.class);
        TYPE_TOKENS.add(Long.class);
        TYPE_TOKENS.add(Double.class);
        TYPE_TOKENS.add(Float.class);
        TYPE_TOKENS.add(Number.class);
        TYPE_TOKENS.add(AtomicInteger.class);
        TYPE_TOKENS.add(AtomicBoolean.class);
        TYPE_TOKENS.add(AtomicLong.class);
        TYPE_TOKENS.add(AtomicLongArray.class);
        TYPE_TOKENS.add(AtomicIntegerArray.class);
        TYPE_TOKENS.add(Character.class);
        TYPE_TOKENS.add(StringBuilder.class);
        TYPE_TOKENS.add(StringBuffer.class);
        TYPE_TOKENS.add(BigDecimal.class);
        TYPE_TOKENS.add(BigInteger.class);
        TYPE_TOKENS.add(URL.class);
        TYPE_TOKENS.add(URI.class);
        TYPE_TOKENS.add(UUID.class);
        TYPE_TOKENS.add(Currency.class);
        TYPE_TOKENS.add(Locale.class);
        TYPE_TOKENS.add(InetAddress.class);
        TYPE_TOKENS.add(BitSet.class);
        TYPE_TOKENS.add(java.util.Date.class);
        TYPE_TOKENS.add(GregorianCalendar.class);
        TYPE_TOKENS.add(Calendar.class);
        TYPE_TOKENS.add(Time.class);
        TYPE_TOKENS.add(Date.class);
        TYPE_TOKENS.add(Timestamp.class);
        TYPE_TOKENS.add(Class.class);
    }
}

