/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.element;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.internal.;
import com.google.gson.internal.Excluder;
import com.google.gson.reflect.TypeToken;
import com.hjq.gson.factory.constructor.MainConstructor;
import com.hjq.gson.factory.element.ReflectiveFieldBound;
import com.hjq.gson.factory.element.ReflectiveTypeAdapter;
import com.hjq.gson.factory.element.ReflectiveTypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final MainConstructor mMainConstructor;
    private final FieldNamingStrategy mFieldNamingPolicy;
    private final Excluder mExcluder;

    public ReflectiveTypeAdapterFactory(MainConstructor constructor, FieldNamingStrategy strategy, Excluder excluder) {
        this.mMainConstructor = constructor;
        this.mFieldNamingPolicy = strategy;
        this.mExcluder = excluder;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class raw = type.getRawType();
        if (ReflectiveTypeUtils.containsClass(raw)) {
            return null;
        }
        if (type.getType() instanceof GenericArrayType || type.getType() instanceof Class && ((Class)type.getType()).isArray()) {
            return null;
        }
        if (!Object.class.isAssignableFrom(raw)) {
            return null;
        }
        if (Collection.class.isAssignableFrom(raw)) {
            return null;
        }
        if (Map.class.isAssignableFrom(raw)) {
            return null;
        }
        JsonAdapter annotation = raw.getAnnotation(JsonAdapter.class);
        if (annotation != null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(raw) && raw != Enum.class) {
            return null;
        }
        ReflectiveTypeAdapter<T> reflectiveTypeAdapter = new ReflectiveTypeAdapter<T>(this.mMainConstructor.get(type), this.getBoundFields(gson, type, raw));
        reflectiveTypeAdapter.setReflectiveType(type, null);
        return reflectiveTypeAdapter;
    }

    private Map<String, ReflectiveFieldBound> getBoundFields(Gson gson, TypeToken<?> type, Class<?> raw) {
        LinkedHashMap<String, ReflectiveFieldBound> result = new LinkedHashMap<String, ReflectiveFieldBound>();
        if (raw.isInterface()) {
            return result;
        }
        Type declaredType = type.getType();
        while (raw != Object.class) {
            Field[] fields;
            for (Field field : fields = raw.getDeclaredFields()) {
                boolean serialize = this.excludeField(field, true);
                boolean deserialize = this.excludeField(field, false);
                if (!serialize && !deserialize) continue;
                field.setAccessible(true);
                Type fieldType = .Gson.Types.resolve((Type)type.getType(), (Class)raw, (Type)field.getGenericType());
                List<String> fieldNames = this.getFieldNames(field);
                ReflectiveFieldBound previous = null;
                for (int i = 0; i < fieldNames.size(); ++i) {
                    String name = fieldNames.get(i);
                    if (i != 0) {
                        serialize = false;
                    }
                    ReflectiveFieldBound fieldBound = ReflectiveTypeUtils.createBoundField(gson, this.mMainConstructor, field, name, TypeToken.get((Type)fieldType), serialize, deserialize);
                    ReflectiveFieldBound replaced = result.put(name, fieldBound);
                    if (previous != null) continue;
                    previous = replaced;
                }
                if (previous == null) continue;
                throw new IllegalArgumentException(declaredType + " declares multiple JSON fields named " + previous.getFieldName());
            }
            type = TypeToken.get((Type).Gson.Types.resolve((Type)type.getType(), raw, (Type)raw.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return result;
    }

    private boolean excludeField(Field field, boolean serialize) {
        return ReflectiveTypeAdapterFactory.excludeField(field, serialize, this.mExcluder);
    }

    private static boolean excludeField(Field field, boolean serialize, Excluder excluder) {
        return !excluder.excludeClass(field.getType(), serialize) && !excluder.excludeField(field, serialize);
    }

    private List<String> getFieldNames(Field field) {
        return ReflectiveTypeUtils.getFieldNames(this.mFieldNamingPolicy, field);
    }
}

