/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.constructor;

import com.google.gson.InstanceCreator;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.ReflectionAccessFilterHelper;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import com.hjq.gson.factory.constructor.ConcurrentMapConstructor;
import com.hjq.gson.factory.constructor.ConcurrentSkipListMapConstructor;
import com.hjq.gson.factory.constructor.EnumMapConstructor;
import com.hjq.gson.factory.constructor.EnumSetConstructor;
import com.hjq.gson.factory.constructor.ExceptionConstructor;
import com.hjq.gson.factory.constructor.InstanceCreatorConstructor;
import com.hjq.gson.factory.constructor.LinkedHashMapConstructor;
import com.hjq.gson.factory.constructor.LinkedTreeMapConstructor;
import com.hjq.gson.factory.constructor.ListConstructor;
import com.hjq.gson.factory.constructor.QueueConstructor;
import com.hjq.gson.factory.constructor.ReflectCreatorConstructor;
import com.hjq.gson.factory.constructor.ReflectSafeCreatorConstructor;
import com.hjq.gson.factory.constructor.SetConstructor;
import com.hjq.gson.factory.constructor.SortedMapConstructor;
import com.hjq.gson.factory.constructor.SortedSetConstructor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;

public final class MainConstructor {
    private final Map<Type, InstanceCreator<?>> mInstanceCreators;
    private final boolean mUseJdkUnsafe;
    private final List<ReflectionAccessFilter> mReflectionFilters;

    public MainConstructor(Map<Type, InstanceCreator<?>> instanceCreators, boolean useJdkUnsafe, List<ReflectionAccessFilter> reflectionFilters) {
        this.mInstanceCreators = instanceCreators;
        this.mUseJdkUnsafe = useJdkUnsafe;
        this.mReflectionFilters = reflectionFilters;
    }

    static String checkInstantiable(Class<?> c) {
        int modifiers = c.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            return "Interfaces can't be instantiated! Register an InstanceCreator or a TypeAdapter for this type. Interface name: " + c.getName();
        }
        if (Modifier.isAbstract(modifiers)) {
            return "Abstract classes can't be instantiated! Register an InstanceCreator or a TypeAdapter for this type. Class name: " + c.getName();
        }
        return null;
    }

    public <T> ObjectConstructor<T> get(TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class rawType = typeToken.getRawType();
        InstanceCreator<?> typeCreator = this.mInstanceCreators.get(type);
        if (typeCreator != null) {
            return new InstanceCreatorConstructor(typeCreator, type);
        }
        InstanceCreator<?> rawTypeCreator = this.mInstanceCreators.get(rawType);
        if (rawTypeCreator != null) {
            return new InstanceCreatorConstructor(rawTypeCreator, type);
        }
        ObjectConstructor<T> specialConstructor = MainConstructor.newSpecialCollectionConstructor(type, rawType);
        if (specialConstructor != null) {
            return specialConstructor;
        }
        ReflectionAccessFilter.FilterResult filterResult = ReflectionAccessFilterHelper.getFilterResult(this.mReflectionFilters, (Class)rawType);
        ObjectConstructor<T> defaultConstructor = MainConstructor.newDefaultConstructor(rawType, filterResult);
        if (defaultConstructor != null) {
            return defaultConstructor;
        }
        ObjectConstructor<T> defaultImplementation = MainConstructor.newDefaultImplementationConstructor(type, rawType);
        if (defaultImplementation != null) {
            return defaultImplementation;
        }
        String exceptionMessage = MainConstructor.checkInstantiable(rawType);
        if (exceptionMessage != null) {
            return new ExceptionConstructor(exceptionMessage);
        }
        if (filterResult == ReflectionAccessFilter.FilterResult.ALLOW) {
            return this.newUnsafeAllocator(rawType);
        }
        String message = "Unable to create instance of " + rawType + "; ReflectionAccessFilter does not permit using reflection or Unsafe. Register an InstanceCreator or a TypeAdapter for this type or adjust the access filter to allow using reflection.";
        return new ExceptionConstructor(message);
    }

    private static <T> ObjectConstructor<T> newSpecialCollectionConstructor(Type type, Class<? super T> rawType) {
        if (EnumSet.class.isAssignableFrom(rawType)) {
            return new EnumSetConstructor(type);
        }
        if (rawType == EnumMap.class) {
            return new EnumMapConstructor(type);
        }
        return null;
    }

    private static <T> ObjectConstructor<T> newDefaultConstructor(Class<? super T> rawType, ReflectionAccessFilter.FilterResult filterResult) {
        String exceptionMessage;
        boolean canAccess;
        Constructor<T> constructor;
        if (Modifier.isAbstract(rawType.getModifiers())) {
            return null;
        }
        try {
            constructor = rawType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        boolean bl = canAccess = filterResult == ReflectionAccessFilter.FilterResult.ALLOW || ReflectionAccessFilterHelper.canAccess(constructor, null) && (filterResult != ReflectionAccessFilter.FilterResult.BLOCK_ALL || Modifier.isPublic(constructor.getModifiers()));
        if (!canAccess) {
            String message = "Unable to invoke no-args constructor of " + rawType + "; constructor is not accessible and ReflectionAccessFilter does not permit making it accessible. Register an InstanceCreator or a TypeAdapter for this type, change the visibility of the constructor or adjust the access filter.";
            return new ExceptionConstructor(message);
        }
        if (filterResult == ReflectionAccessFilter.FilterResult.ALLOW && (exceptionMessage = ReflectionHelper.tryMakeAccessible(constructor)) != null) {
            return new ExceptionConstructor(exceptionMessage);
        }
        return new ReflectCreatorConstructor<T>(rawType, constructor);
    }

    private static <T> ObjectConstructor<T> newDefaultImplementationConstructor(Type type, Class<? super T> rawType) {
        if (Collection.class.isAssignableFrom(rawType)) {
            if (SortedSet.class.isAssignableFrom(rawType)) {
                return SortedSetConstructor.getInstance();
            }
            if (Set.class.isAssignableFrom(rawType)) {
                return SetConstructor.getInstance();
            }
            if (Queue.class.isAssignableFrom(rawType)) {
                return QueueConstructor.getInstance();
            }
            return ListConstructor.getInstance();
        }
        if (Map.class.isAssignableFrom(rawType)) {
            if (ConcurrentNavigableMap.class.isAssignableFrom(rawType)) {
                return ConcurrentSkipListMapConstructor.getInstance();
            }
            if (ConcurrentMap.class.isAssignableFrom(rawType)) {
                return ConcurrentMapConstructor.getInstance();
            }
            if (SortedMap.class.isAssignableFrom(rawType)) {
                return SortedMapConstructor.getInstance();
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(TypeToken.get((Type)((ParameterizedType)type).getActualTypeArguments()[0]).getRawType())) {
                return LinkedHashMapConstructor.getInstance();
            }
            return LinkedTreeMapConstructor.getInstance();
        }
        return null;
    }

    private <T> ObjectConstructor<T> newUnsafeAllocator(Class<? super T> rawType) {
        if (this.mUseJdkUnsafe) {
            return new ReflectSafeCreatorConstructor<T>(rawType);
        }
        String exceptionMessage = "Unable to create instance of " + rawType + "; usage of JDK Unsafe is disabled. Registering an InstanceCreator or a TypeAdapter for this type, adding a no-args constructor, or enabling usage of JDK Unsafe may fix this problem.";
        return new ExceptionConstructor(exceptionMessage);
    }

    public String toString() {
        return this.mInstanceCreators.toString();
    }
}

