/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.element;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.hjq.gson.factory.GsonFactory;
import com.hjq.gson.factory.JsonCallback;
import com.hjq.gson.factory.element.ReflectiveFieldBound;
import java.io.IOException;
import java.util.Map;

public class ReflectiveTypeAdapter<T>
extends TypeAdapter<T> {
    private final ObjectConstructor<T> mConstructor;
    private final Map<String, ReflectiveFieldBound> mBoundFields;
    private TypeToken<?> mTypeToken;
    private String mFieldName;

    public ReflectiveTypeAdapter(ObjectConstructor<T> constructor, Map<String, ReflectiveFieldBound> fields) {
        this.mConstructor = constructor;
        this.mBoundFields = fields;
    }

    public void setReflectiveType(TypeToken<?> typeToken, String fieldName) {
        this.mTypeToken = typeToken;
        this.mFieldName = fieldName;
    }

    public T read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        if (jsonToken == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (jsonToken != JsonToken.BEGIN_OBJECT) {
            in.skipValue();
            JsonCallback callback = GsonFactory.getJsonCallback();
            if (callback != null) {
                callback.onTypeException(this.mTypeToken, this.mFieldName, jsonToken);
            }
            return null;
        }
        Object instance = this.mConstructor.construct();
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            ReflectiveFieldBound field = this.mBoundFields.get(name);
            if (field == null || !field.isDeserialized()) {
                in.skipValue();
                continue;
            }
            JsonToken peek = in.peek();
            try {
                field.read(in, instance);
            }
            catch (IllegalStateException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalArgumentException e) {
                JsonCallback callback = GsonFactory.getJsonCallback();
                if (callback == null) continue;
                callback.onTypeException(TypeToken.get(instance.getClass()), field.getFieldName(), peek);
            }
        }
        in.endObject();
        return (T)instance;
    }

    public void write(JsonWriter out, T value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        for (ReflectiveFieldBound fieldBound : this.mBoundFields.values()) {
            try {
                if (!fieldBound.writeField(value)) continue;
                out.name(fieldBound.getFieldName());
                fieldBound.write(out, value);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
        out.endObject();
    }
}

