/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.body;

import androidx.annotation.NonNull;
import com.hjq.http.EasyUtils;
import com.hjq.http.model.ContentType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonRequestBody
extends RequestBody {
    private final String mJson;
    private final byte[] mBytes;

    public JsonRequestBody(Map<?, ?> map) {
        this(new JSONObject(map));
    }

    public JsonRequestBody(List<?> list) {
        this(new JSONArray(list));
    }

    public JsonRequestBody(JSONObject jsonObject) {
        this.mJson = EasyUtils.unescapeJson(jsonObject.toString());
        this.mBytes = this.mJson.getBytes();
    }

    public JsonRequestBody(JSONArray jsonArray) {
        this.mJson = EasyUtils.unescapeJson(jsonArray.toString());
        this.mBytes = this.mJson.getBytes();
    }

    public JsonRequestBody(String json) {
        this.mJson = json;
        this.mBytes = this.mJson.getBytes();
    }

    public MediaType contentType() {
        return ContentType.JSON;
    }

    public long contentLength() {
        return this.mBytes.length;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        sink.write(this.mBytes, 0, this.mBytes.length);
    }

    @NonNull
    public String toString() {
        return this.mJson;
    }

    @NonNull
    public String getJson() {
        return this.mJson;
    }
}

