/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.body.JsonBody;
import com.hjq.http.body.ProgressBody;
import com.hjq.http.body.StringBody;
import com.hjq.http.body.UpdateBody;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.listener.OnUpdateListener;
import com.hjq.http.model.BodyType;
import com.hjq.http.model.CacheMode;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.BaseRequest;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import okhttp3.CacheControl;
import okhttp3.FormBody;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public abstract class BodyRequest<T extends BodyRequest<?>>
extends BaseRequest<T> {
    private OnUpdateListener<?> mUpdateListener;
    private RequestBody mRequestBody;

    public BodyRequest(LifecycleOwner lifecycleOwner) {
        super(lifecycleOwner);
    }

    public T json(Map<?, ?> map) {
        if (map == null) {
            return (T)this;
        }
        return this.body(new JsonBody(map));
    }

    public T json(List<?> list) {
        if (list == null) {
            return (T)this;
        }
        return this.body(new JsonBody(list));
    }

    public T json(String json) {
        if (json == null) {
            return (T)this;
        }
        return this.body(new JsonBody(json));
    }

    public T text(String text) {
        if (text == null) {
            return (T)this;
        }
        return this.body(new StringBody(text));
    }

    public T body(RequestBody body) {
        this.mRequestBody = body;
        return (T)this;
    }

    @Override
    protected Request createRequest(String url, String tag, HttpParams params, HttpHeaders headers, BodyType type) {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        EasyLog.print("RequestUrl", url);
        EasyLog.print("RequestMethod", this.getRequestMethod());
        if (tag != null) {
            requestBuilder.tag((Object)tag);
        }
        if (this.getRequestCache().getMode() == CacheMode.NO_CACHE) {
            requestBuilder.cacheControl(new CacheControl.Builder().noCache().build());
        }
        if (!headers.isEmpty()) {
            for (String key : headers.getNames()) {
                requestBuilder.addHeader(key, headers.get(key));
            }
        }
        RequestBody body = this.mRequestBody != null ? this.mRequestBody : this.createBody(params, type);
        requestBuilder.method(this.getRequestMethod(), body);
        if (EasyConfig.getInstance().isLogEnabled()) {
            if (!headers.isEmpty() || !params.isEmpty()) {
                EasyLog.print();
            }
            for (String key : headers.getNames()) {
                EasyLog.print(key, headers.get(key));
            }
            if (!headers.isEmpty() && !params.isEmpty()) {
                EasyLog.print();
            }
            if (body instanceof FormBody || body instanceof MultipartBody || body instanceof ProgressBody) {
                for (String key : params.getNames()) {
                    Object value = params.get(key);
                    if (value instanceof String) {
                        EasyLog.print(key, "\"" + value + "\"");
                        continue;
                    }
                    EasyLog.print(key, String.valueOf(value));
                }
            } else if (body instanceof JsonBody) {
                EasyLog.json(body.toString());
            } else {
                EasyLog.print(body.toString());
            }
            if (!headers.isEmpty() || !params.isEmpty()) {
                EasyLog.print();
            }
        }
        return this.getRequestHandler().requestStart(this.getLifecycleOwner(), this.getRequestApi(), requestBuilder);
    }

    @Override
    public void request(OnHttpListener<?> listener) {
        if (listener instanceof OnUpdateListener) {
            this.mUpdateListener = (OnUpdateListener)listener;
        }
        super.request(listener);
    }

    private RequestBody createBody(HttpParams params, BodyType type) {
        JsonBody requestBody;
        if (params.isMultipart() && !params.isEmpty()) {
            MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
            bodyBuilder.setType(MultipartBody.FORM);
            for (String key : params.getNames()) {
                MultipartBody.Part part;
                Object object = params.get(key);
                if (object instanceof File) {
                    part = EasyUtils.createPart(key, (File)object);
                    if (part == null) continue;
                    bodyBuilder.addPart(part);
                    continue;
                }
                if (object instanceof InputStream) {
                    part = EasyUtils.createPart(key, (InputStream)object);
                    if (part == null) continue;
                    bodyBuilder.addPart(part);
                    continue;
                }
                if (object instanceof MultipartBody.Part) {
                    bodyBuilder.addPart((MultipartBody.Part)object);
                    continue;
                }
                if (object instanceof RequestBody) {
                    if (object instanceof UpdateBody) {
                        bodyBuilder.addFormDataPart(key, EasyUtils.encodeString(((UpdateBody)((Object)object)).getKeyName()), (RequestBody)object);
                        continue;
                    }
                    bodyBuilder.addFormDataPart(key, null, (RequestBody)object);
                    continue;
                }
                if (object instanceof List && EasyUtils.isFileList((List)object)) {
                    for (Object item : (List)object) {
                        MultipartBody.Part part2 = EasyUtils.createPart(key, (File)item);
                        if (part2 == null) continue;
                        bodyBuilder.addPart(part2);
                    }
                    continue;
                }
                bodyBuilder.addFormDataPart(key, String.valueOf(object));
            }
            try {
                requestBody = bodyBuilder.build();
            }
            catch (IllegalStateException ignored) {
                requestBody = new FormBody.Builder().build();
            }
        } else if (type == BodyType.JSON) {
            requestBody = new JsonBody(params.getParams());
        } else {
            FormBody.Builder bodyBuilder = new FormBody.Builder();
            if (!params.isEmpty()) {
                for (String key : params.getNames()) {
                    bodyBuilder.add(key, String.valueOf(params.get(key)));
                }
            }
            requestBody = bodyBuilder.build();
        }
        return this.mUpdateListener == null ? requestBody : new ProgressBody(requestBody, this.getLifecycleOwner(), this.mUpdateListener);
    }
}

