/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import android.text.TextUtils;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.callback.BaseCallback;
import com.hjq.http.exception.MD5Exception;
import com.hjq.http.exception.NullBodyException;
import com.hjq.http.lifecycle.HttpLifecycleManager;
import com.hjq.http.listener.OnDownloadListener;
import com.hjq.http.model.FileWrapper;
import com.hjq.http.request.BaseRequest;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.Call;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class DownloadCallback
extends BaseCallback {
    private final BaseRequest<?> mBaseRequest;
    private static final String FILE_MD5_REGEX = "^[\\w]{32}$";
    private FileWrapper mFile;
    private String mMd5;
    private OnDownloadListener mListener;
    private long mTotalByte;
    private long mDownloadByte;
    private int mDownloadProgress;

    public DownloadCallback(BaseRequest<?> request) {
        super(request);
        this.mBaseRequest = request;
    }

    public DownloadCallback setFile(FileWrapper file) {
        this.mFile = file;
        return this;
    }

    public DownloadCallback setMd5(String md5) {
        this.mMd5 = md5;
        return this;
    }

    public DownloadCallback setListener(OnDownloadListener listener) {
        this.mListener = listener;
        return this;
    }

    @Override
    protected void onStart(Call call) {
        EasyUtils.post(() -> {
            if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.mBaseRequest.getLifecycleOwner())) {
                return;
            }
            this.mListener.onStart(this.mFile);
        });
    }

    @Override
    protected void onResponse(Response response) throws Exception {
        int readLength;
        ResponseBody body;
        File parentFile;
        String md5;
        if (this.mMd5 == null && !TextUtils.isEmpty((CharSequence)(md5 = response.header("Content-MD5"))) && md5.matches(FILE_MD5_REGEX)) {
            this.mMd5 = md5;
        }
        if ((parentFile = this.mFile.getParentFile()) != null) {
            FileWrapper.createFolder(parentFile);
        }
        if ((body = response.body()) == null) {
            throw new NullBodyException("The response body is empty");
        }
        this.mTotalByte = body.contentLength();
        if (this.mTotalByte < 0L) {
            this.mTotalByte = 0L;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMd5) && this.mFile.isFile() && this.mMd5.equalsIgnoreCase(FileWrapper.getFileMd5(this.mFile.openInputStream()))) {
            EasyUtils.post(() -> {
                if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.mBaseRequest.getLifecycleOwner())) {
                    return;
                }
                this.mListener.onComplete(this.mFile);
                this.mListener.onEnd(this.mFile);
            });
            return;
        }
        this.mDownloadByte = 0L;
        byte[] bytes = new byte[8192];
        InputStream inputStream = body.byteStream();
        OutputStream outputStream = this.mFile.openOutputStream();
        while ((readLength = inputStream.read(bytes)) != -1) {
            this.mDownloadByte += (long)readLength;
            outputStream.write(bytes, 0, readLength);
            EasyUtils.post(() -> {
                if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.mBaseRequest.getLifecycleOwner())) {
                    return;
                }
                this.mListener.onByte(this.mFile, this.mTotalByte, this.mDownloadByte);
                int progress = EasyUtils.getProgressProgress(this.mTotalByte, this.mDownloadByte);
                if (progress != this.mDownloadProgress) {
                    this.mDownloadProgress = progress;
                    this.mListener.onProgress(this.mFile, this.mDownloadProgress);
                    EasyLog.print(this.mFile.getPath() + " \u6b63\u5728\u4e0b\u8f7d\uff0c\u603b\u5b57\u8282\uff1a" + this.mTotalByte + "\uff0c\u5df2\u4e0b\u8f7d\uff1a" + this.mDownloadByte + "\uff0c\u8fdb\u5ea6\uff1a" + progress + " %");
                }
            });
        }
        EasyUtils.closeStream(inputStream);
        EasyUtils.closeStream(outputStream);
        String md52 = FileWrapper.getFileMd5(this.mFile.openInputStream());
        if (!TextUtils.isEmpty((CharSequence)this.mMd5) && !this.mMd5.equalsIgnoreCase(md52)) {
            throw new MD5Exception("MD5 verify failure", md52);
        }
        EasyUtils.post(() -> {
            if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.mBaseRequest.getLifecycleOwner())) {
                return;
            }
            this.mListener.onComplete(this.mFile);
            this.mListener.onEnd(this.mFile);
        });
    }

    @Override
    protected void onFailure(Exception e) {
        Exception exception = this.mBaseRequest.getRequestHandler().requestFail(this.mBaseRequest.getLifecycleOwner(), this.mBaseRequest.getRequestApi(), e);
        EasyLog.print(exception);
        EasyUtils.post(() -> {
            if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.mBaseRequest.getLifecycleOwner())) {
                return;
            }
            this.mListener.onError(this.mFile, exception);
            this.mListener.onEnd(this.mFile);
        });
    }
}

