/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.body;

import androidx.annotation.NonNull;
import com.hjq.http.model.ContentType;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class StringBody
extends RequestBody {
    private final String mText;
    private final byte[] mBytes;

    public StringBody() {
        this("");
    }

    public StringBody(String text) {
        this.mText = text;
        this.mBytes = this.mText.getBytes();
    }

    public MediaType contentType() {
        return ContentType.TEXT;
    }

    public long contentLength() {
        return this.mBytes.length;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        sink.write(this.mBytes, 0, this.mBytes.length);
    }

    @NonNull
    public String toString() {
        return this.mText;
    }
}

