/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.body;

import androidx.annotation.NonNull;
import com.hjq.http.model.ContentType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonBody
extends RequestBody {
    private final String mJson;
    private final byte[] mBytes;

    public JsonBody(Map<?, ?> map) {
        this(new JSONObject(map));
    }

    public JsonBody(List<?> list) {
        this(new JSONArray(list));
    }

    public JsonBody(JSONObject jsonObject) {
        this.mJson = jsonObject.toString();
        this.mBytes = this.mJson.getBytes();
    }

    public JsonBody(JSONArray jsonArray) {
        this.mJson = jsonArray.toString();
        this.mBytes = this.mJson.getBytes();
    }

    public JsonBody(String json) {
        this.mJson = json;
        this.mBytes = this.mJson.getBytes();
    }

    public MediaType contentType() {
        return ContentType.JSON;
    }

    public long contentLength() {
        return this.mBytes.length;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        sink.write(this.mBytes, 0, this.mBytes.length);
    }

    public String getJson() {
        return this.mJson;
    }

    @NonNull
    public String toString() {
        return this.mJson;
    }
}

