/*
 * Decompiled with CFR 0.152.
 */
package com.drivemode.spotify.rest;

import com.drivemode.spotify.models.User;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class RestAdapterFactory {
    public static final String TAG = RestAdapterFactory.class.getSimpleName();
    public static final String SPOTIFY_WEB_API_ENDPOINT = "https://api.spotify.com/v1/";
    public static final String SPOTIFY_AUTHENTICATE_ENDPOINT = "https://accounts.spotify.com/";
    private OkHttpClient mOkClient;

    public Retrofit provideWebApiAdapter(Interceptor interceptor) {
        if (this.mOkClient == null || this.mOkClient.interceptors().size() == 0) {
            this.mOkClient = new OkHttpClient.Builder().addInterceptor(interceptor).build();
        }
        return new Retrofit.Builder().client(this.mOkClient).baseUrl(SPOTIFY_WEB_API_ENDPOINT).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new GsonBuilder().registerTypeAdapter(Call.class, new InterfaceAdapter()).create())).build();
    }

    public Retrofit provideAuthenticateApiAdapter() {
        if (this.mOkClient == null) {
            this.mOkClient = new OkHttpClient();
        }
        return new Retrofit.Builder().client(this.mOkClient).baseUrl(SPOTIFY_AUTHENTICATE_ENDPOINT).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new GsonBuilder().registerTypeAdapter(User.class, new InterfaceAdapter()).create())).build();
    }

    private static final class InterfaceAdapter<T>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        private InterfaceAdapter() {
        }

        public JsonElement serialize(T object, Type interfaceType, JsonSerializationContext context) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty("type", object.getClass().getName());
            wrapper.add("data", context.serialize(object));
            return wrapper;
        }

        public T deserialize(JsonElement elem, Type interfaceType, JsonDeserializationContext context) throws JsonParseException {
            JsonObject wrapper = (JsonObject)elem;
            JsonElement typeName = this.get(wrapper, "type");
            Type actualType = this.typeForName(typeName);
            return (T)new Gson().fromJson(elem, actualType);
        }

        private Type typeForName(JsonElement typeElem) {
            try {
                String className = typeElem.getAsString();
                return Class.forName("com.drivemode.spotify.models." + className.substring(0, 1).toUpperCase() + className.substring(1));
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException((Throwable)e);
            }
        }

        private JsonElement get(JsonObject wrapper, String memberName) {
            JsonElement elem = wrapper.get(memberName);
            if (elem == null) {
                throw new JsonParseException("no '" + memberName + "' member found in what was expected to be an interface wrapper");
            }
            return elem;
        }
    }
}

