/*
 * Decompiled with CFR 0.152.
 */
package com.drivemode.spotify;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpotifyUri {
    public static final String TAG = SpotifyUri.class.getSimpleName();
    public static final String SCHEME = "spotify";
    private static final Pattern PATTERN_DEFAULT_URI = Pattern.compile("spotify:(album|artist|track):([a-zA-Z0-9_-]+)");
    private static final Pattern PATTERN_PLAYLIST_MATCHER = Pattern.compile("spotify:user:([a-zA-Z0-9_-]+):(playlist):([a-zA-Z0-9_-]+)");
    private final String mScheme;
    private final String mUserId;
    private final ResourceType mResourceType;
    private final String mId;

    SpotifyUri(ResourceType resourceType, String id) {
        this(null, resourceType, id);
    }

    SpotifyUri(String userId, ResourceType resourceType, String id) {
        this(SCHEME, userId, resourceType, id);
    }

    SpotifyUri(String scheme, String userId, ResourceType resourceType, String id) {
        this.mScheme = scheme;
        this.mUserId = userId;
        this.mResourceType = resourceType;
        this.mId = id;
    }

    public String toString() {
        if (this.mUserId == null) {
            return "spotify:" + this.mResourceType.toString() + ":" + this.mId;
        }
        return "spotify:user:" + this.mUserId + ":" + this.mResourceType.toString() + ":" + this.mId;
    }

    @NonNull
    public String getScheme() {
        return this.mScheme;
    }

    @Nullable
    public String getUserId() {
        return this.mUserId;
    }

    @NonNull
    public ResourceType getResourceType() {
        return this.mResourceType;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    public static SpotifyUri parse(String uri) {
        Matcher playlistMatcher = PATTERN_PLAYLIST_MATCHER.matcher(uri);
        if (playlistMatcher.matches()) {
            String user = playlistMatcher.group(1);
            ResourceType type = ResourceType.from(playlistMatcher.group(2));
            String id = playlistMatcher.group(3);
            return new SpotifyUri(user, type, id);
        }
        Matcher publicMatcher = PATTERN_DEFAULT_URI.matcher(uri);
        if (publicMatcher.matches()) {
            ResourceType type = ResourceType.from(publicMatcher.group(1));
            String id = publicMatcher.group(2);
            return new SpotifyUri(type, id);
        }
        return null;
    }

    public static enum ResourceType {
        ALBUM("album"),
        ARTIST("artist"),
        TRACK("track"),
        PLAYLIST("playlist");

        private final String mRaw;

        private ResourceType(String raw) {
            this.mRaw = raw;
        }

        public static ResourceType from(String raw) {
            for (ResourceType type : ResourceType.values()) {
                if (!type.mRaw.equals(raw)) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.mRaw;
        }
    }
}

