/*
 * Decompiled with CFR 0.152.
 */
package com.drivemode.spotify;

import com.drivemode.spotify.annotations.DELETEWITHBODY;
import com.drivemode.spotify.models.Album;
import com.drivemode.spotify.models.Albums;
import com.drivemode.spotify.models.AlbumsPager;
import com.drivemode.spotify.models.Artist;
import com.drivemode.spotify.models.Artists;
import com.drivemode.spotify.models.ArtistsPager;
import com.drivemode.spotify.models.FeaturedPlaylists;
import com.drivemode.spotify.models.NewReleases;
import com.drivemode.spotify.models.Pager;
import com.drivemode.spotify.models.Playlist;
import com.drivemode.spotify.models.PlaylistTrack;
import com.drivemode.spotify.models.PlaylistsPager;
import com.drivemode.spotify.models.SavedTrack;
import com.drivemode.spotify.models.SnapshotId;
import com.drivemode.spotify.models.Track;
import com.drivemode.spotify.models.Tracks;
import com.drivemode.spotify.models.TracksPager;
import com.drivemode.spotify.models.TracksToRemove;
import com.drivemode.spotify.models.TracksToRemoveWithPosition;
import com.drivemode.spotify.models.User;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface SpotifyService {
    @GET(value="me")
    public Call<User> getMe();

    @GET(value="user/{id}")
    public Call<User> getUser(@Path(value="id") String var1);

    @GET(value="users/{id}/playlists")
    public Call<Pager<Playlist>> getPlaylists(@Path(value="id") String var1, @Query(value="offset") int var2, @Query(value="limit") int var3);

    @GET(value="users/{id}/playlists")
    public Call<Pager<Playlist>> getPlaylists(@Path(value="id") String var1);

    @GET(value="users/{user_id}/playlists/{playlist_id}")
    public Call<Playlist> getPlaylist(@Path(value="user_id") String var1, @Path(value="playlist_id") String var2);

    @GET(value="users/{user_id}/playlists/{playlist_id}/tracks")
    public Call<Pager<PlaylistTrack>> getPlaylistTracks(@Path(value="user_id") String var1, @Path(value="playlist_id") String var2, @Query(value="offset") int var3, @Query(value="limit") int var4);

    @GET(value="users/{user_id}/playlists/{playlist_id}/tracks")
    public Call<Pager<PlaylistTrack>> getPlaylistTracks(@Path(value="user_id") String var1, @Path(value="playlist_id") String var2);

    @POST(value="users/{user_id}/playlists")
    public Call<Playlist> createPlaylist(@Path(value="user_id") String var1, @Query(value="name") String var2);

    @POST(value="users/{user_id}/playlists")
    public Call<Playlist> createPlaylist(@Path(value="user_id") String var1, @Query(value="name") String var2, @Query(value="public") boolean var3);

    @POST(value="users/{user_id}/playlists/{playlist_id}/tracks")
    public Call<SnapshotId> addTracksToPlaylist(@Path(value="user_id") String var1, @Path(value="playlist_id") String var2, @Query(value="uris") String var3);

    @POST(value="users/{user_id}/playlists/{playlist_id}/tracks")
    public Call<SnapshotId> addTracksToPlaylist(@Path(value="user_id") String var1, @Path(value="playlist_id") String var2, @Query(value="uris") String var3, @Query(value="position") int var4);

    @DELETEWITHBODY(value="users/{user_id}/playlists/{playlist_id}/tracks")
    public Call<SnapshotId> removeTracksFromPlaylist(@Path(value="user_id") String var1, @Path(value="playlist_id") String var2, @Body TracksToRemove var3);

    @DELETEWITHBODY(value="users/{user_id}/playlists/{playlist_id}/tracks")
    public Call<SnapshotId> removeTracksFromPlaylist(@Path(value="user_id") String var1, @Path(value="playlist_id") String var2, @Body TracksToRemoveWithPosition var3);

    @PUT(value="users/{user_id}/playlists/{playlist_id}/tracks")
    public Call<Boolean> replaceTracksInPlaylist(@Path(value="user_id") String var1, @Path(value="playlist_id") String var2, @Query(value="uris") String var3);

    @PUT(value="users/{user_id}/playlists/{playlist_id}")
    public Call<Boolean> changePlaylistDetails(@Path(value="user_id") String var1, @Path(value="playlist_id") String var2, @Query(value="name") String var3);

    @PUT(value="users/{user_id}/playlists/{playlist_id}")
    public Call<Boolean> changePlaylistDetails(@Path(value="user_id") String var1, @Path(value="playlist_id") String var2, @Query(value="public") boolean var3);

    @GET(value="albums/{id}")
    public Call<Album> getAlbum(@Path(value="id") String var1);

    @GET(value="albums")
    public Call<Albums> getAlbums(@Query(value="ids") String var1);

    @GET(value="albums/{id}/tracks")
    public Call<Pager<Track>> getAlbumTracks(@Path(value="id") String var1);

    @GET(value="albums/{id}/tracks")
    public Call<Pager<Track>> getAlbumTracks(@Path(value="id") String var1, @Query(value="offset") int var2, @Query(value="limit") int var3);

    @GET(value="artists/{id}/albums")
    public Call<Pager<Album>> getArtistAlbums(@Path(value="id") String var1, @Query(value="offset") int var2, @Query(value="limit") int var3);

    @GET(value="artists/{id}/albums")
    public Call<Pager<Album>> getArtistAlbums(@Path(value="id") String var1);

    @GET(value="artists/{id}/top-tracks")
    public Call<Pager<Track>> getArtistTopTrack(@Path(value="id") String var1, @Query(value="offset") int var2, @Query(value="limit") int var3);

    @GET(value="artists/{id}/top-tracks")
    public Call<Pager<Track>> getArtistTopTrack(@Path(value="id") String var1);

    @GET(value="artists/{id}/related-artists")
    public Call<Pager<Artist>> getRelatedArtists(@Path(value="id") String var1, @Query(value="offset") int var2, @Query(value="limit") int var3);

    @GET(value="artists/{id}/related-artists")
    public Call<Pager<Artist>> getRelatedArtists(@Path(value="id") String var1);

    @GET(value="artists/{id}")
    public Call<Artist> getArtist(@Path(value="id") String var1);

    @GET(value="artists")
    public Call<Artists> getArtists(@Query(value="ids") String var1);

    @GET(value="tracks/{id}")
    public Call<Track> getTrack(@Path(value="id") String var1);

    @GET(value="tracks")
    public Call<Tracks> getTracks(@Query(value="ids") String var1);

    @GET(value="browse/featured-playlists")
    public Call<FeaturedPlaylists> getFeaturedPlaylists(@QueryMap Map<String, String> var1);

    @GET(value="browse/featured-playlists")
    public Call<FeaturedPlaylists> getFeaturedPlaylists(@QueryMap Map<String, String> var1, @Query(value="offset") int var2, @Query(value="limit") int var3);

    @GET(value="browse/new-releases")
    public Call<NewReleases> getNewReleases();

    @GET(value="browse/new-releases")
    public Call<NewReleases> getNewReleases(@Query(value="country") String var1);

    @GET(value="browse/new-releases")
    public Call<NewReleases> getNewReleases(@Query(value="country") String var1, @Query(value="offset") int var2, @Query(value="limit") int var3);

    @GET(value="me/tracks")
    public Call<Pager<SavedTrack>> getMySavedTracks();

    @GET(value="me/tracks")
    public Call<Pager<SavedTrack>> getMySavedTracks(@Query(value="offset") int var1, @Query(value="limit") int var2);

    @GET(value="me/tracks/contains")
    public Call<Boolean[]> containsMySavedTracks(@Query(value="ids") String var1);

    @PUT(value="me/tracks")
    public Call<Boolean> addToMySavedTracks(@Query(value="ids") String var1);

    @DELETE(value="me/tracks")
    public Call<Boolean> removeFromMySavedTracks(@Query(value="ids") String var1);

    @GET(value="search?type=track")
    public Call<TracksPager> searchTracks(@Query(value="q") String var1);

    @GET(value="search?type=track")
    public Call<TracksPager> searchTracks(@Query(value="q") String var1, @Query(value="market") String var2);

    @GET(value="search?type=track")
    public Call<TracksPager> searchTracks(@Query(value="q") String var1, @Query(value="offset") int var2, @Query(value="limit") int var3);

    @GET(value="search?type=track")
    public Call<TracksPager> searchTracks(@Query(value="q") String var1, @Query(value="market") String var2, @Query(value="offset") int var3, @Query(value="limit") int var4);

    @GET(value="search?type=artist")
    public Call<ArtistsPager> searchArtists(@Query(value="q") String var1);

    @GET(value="search?type=artist")
    public Call<ArtistsPager> searchArtists(@Query(value="q") String var1, @Query(value="market") String var2);

    @GET(value="search?type=artist")
    public Call<ArtistsPager> searchArtists(@Query(value="q") String var1, @Query(value="offset") int var2, @Query(value="limit") int var3);

    @GET(value="search?type=artist")
    public Call<ArtistsPager> searchArtists(@Query(value="q") String var1, @Query(value="market") String var2, @Query(value="offset") int var3, @Query(value="limit") int var4);

    @GET(value="search?type=album")
    public Call<AlbumsPager> searchAlbums(@Query(value="q") String var1);

    @GET(value="search?type=album")
    public Call<AlbumsPager> searchAlbums(@Query(value="q") String var1, @Query(value="market") String var2);

    @GET(value="search?type=album")
    public Call<AlbumsPager> searchAlbums(@Query(value="q") String var1, @Query(value="offset") int var2, @Query(value="limit") int var3);

    @GET(value="search?type=album")
    public Call<AlbumsPager> searchAlbums(@Query(value="q") String var1, @Query(value="market") String var2, @Query(value="offset") int var3, @Query(value="limit") int var4);

    @GET(value="search?type=playlist")
    public Call<PlaylistsPager> searchPlaylists(@Query(value="q") String var1);

    @GET(value="search?type=playlist")
    public Call<PlaylistsPager> searchPlaylists(@Query(value="q") String var1, @Query(value="market") String var2);

    @GET(value="search?type=playlist")
    public Call<PlaylistsPager> searchPlaylists(@Query(value="q") String var1, @Query(value="offset") int var2, @Query(value="limit") int var3);

    @GET(value="search?type=playlist")
    public Call<PlaylistsPager> searchPlaylists(@Query(value="q") String var1, @Query(value="market") String var2, @Query(value="offset") int var3, @Query(value="limit") int var4);
}

