/*
 * Decompiled with CFR 0.152.
 */
package com.drivemode.spotify;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.drivemode.spotify.ClientConfig;
import com.drivemode.spotify.SpotifyAuthenticateService;
import com.drivemode.spotify.SpotifyService;
import com.drivemode.spotify.auth.AccessToken;
import com.drivemode.spotify.auth.AccessTokenStore;
import com.drivemode.spotify.rest.RestAdapterFactory;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Retrofit;

public class SpotifyApi {
    public static final String TAG = SpotifyApi.class.getSimpleName();
    private static volatile SpotifyApi sSingleton;
    private final Application mApplication;
    private final ClientConfig mConfig;
    private final AccessTokenStore mTokenStore;
    private final RestAdapterFactory mAdapterFactory;
    private SpotifyService mSpotifyService;
    private SpotifyAuthenticateService mAuthenticateService;

    SpotifyApi(Application application, ClientConfig config) {
        this.mApplication = application;
        this.mConfig = config;
        this.mTokenStore = new AccessTokenStore(application);
        this.mAdapterFactory = new RestAdapterFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize(@NonNull Application application, @NonNull ClientConfig config) {
        if (sSingleton != null) return;
        Class<SpotifyApi> clazz = SpotifyApi.class;
        synchronized (SpotifyApi.class) {
            if (sSingleton != null) return;
            sSingleton = new SpotifyApi(application, config);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized SpotifyApi getInstance() {
        if (sSingleton == null) {
            throw new IllegalStateException("SpotifyApi is not yet initialized.");
        }
        return sSingleton;
    }

    public static synchronized void destroy() {
        sSingleton = null;
    }

    public synchronized SpotifyService getApiService() {
        if (this.mSpotifyService == null) {
            Retrofit adapter = this.mAdapterFactory.provideWebApiAdapter(new WebApiAuthenticator());
            this.mSpotifyService = (SpotifyService)adapter.create(SpotifyService.class);
        }
        return this.mSpotifyService;
    }

    public synchronized SpotifyAuthenticateService getAuthService() {
        if (this.mAuthenticateService == null) {
            Retrofit adapter = this.mAdapterFactory.provideAuthenticateApiAdapter();
            this.mAuthenticateService = (SpotifyAuthenticateService)adapter.create(SpotifyAuthenticateService.class);
        }
        return this.mAuthenticateService;
    }

    public boolean isAuthrorized() {
        AccessToken token = this.mTokenStore.read();
        return !TextUtils.isEmpty((CharSequence)token.accessToken);
    }

    public void authorize(Context context, String[] scopes) {
        this.authorize(context, scopes, false);
    }

    public void authorize(Context context, String[] scopes, boolean showDialog) {
        String scope = TextUtils.join((CharSequence)" ", (Object[])scopes);
        Uri uri = Uri.parse((String)"https://accounts.spotify.com/authorize").buildUpon().appendQueryParameter("client_id", this.mConfig.getClientId()).appendQueryParameter("response_type", "code").appendQueryParameter("redirect_uri", this.mConfig.getRedirectUri()).appendQueryParameter("scope", scope).appendQueryParameter("show_dialog", String.valueOf(showDialog)).build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        context.startActivity(intent);
    }

    public void onCallback(Uri data, final AuthenticationListener listener) {
        if (data == null) {
            return;
        }
        Log.v((String)TAG, (String)data.toString());
        String code = data.getQueryParameter("code");
        Call<AccessToken> call = this.getAuthService().getAccessToken("authorization_code", code, this.mConfig.getRedirectUri(), this.mConfig.getClientId(), this.mConfig.getClientSecret());
        call.enqueue((Callback)new Callback<AccessToken>(){

            public void onResponse(Call<AccessToken> call, retrofit2.Response<AccessToken> response) {
                if (response.isSuccessful()) {
                    Log.v((String)TAG, (String)("success retrieving access token: " + response.body()));
                    SpotifyApi.this.mTokenStore.store((AccessToken)response.body());
                    listener.onReady();
                } else {
                    Log.v((String)TAG, (String)"failed");
                }
            }

            public void onFailure(Call<AccessToken> call, Throwable t) {
                listener.onError();
            }
        });
    }

    public void refreshTokenIfNeeded(final AuthenticationListener listener) {
        if (!this.mTokenStore.isExpired()) {
            Log.v((String)TAG, (String)"no need to refresh");
            listener.onReady();
            return;
        }
        AccessToken token = this.mTokenStore.read();
        Call<AccessToken> call = this.getAuthService().refreshAccessToken("refresh_token", token.refreshToken, this.mConfig.getClientId(), this.mConfig.getClientSecret());
        call.enqueue((Callback)new Callback<AccessToken>(){

            public void onResponse(Call<AccessToken> call, retrofit2.Response<AccessToken> response) {
                Log.v((String)TAG, (String)("success refreshing access token: " + response.body()));
                SpotifyApi.this.mTokenStore.update((AccessToken)response.body());
                listener.onReady();
            }

            public void onFailure(Call<AccessToken> call, Throwable t) {
                listener.onError();
            }
        });
    }

    public void blockingRefreshTokenIfNeeded() {
        if (!this.mTokenStore.isExpired()) {
            Log.v((String)TAG, (String)"no need to refresh");
            return;
        }
        AccessToken token = this.mTokenStore.read();
        Call<AccessToken> newToken = this.getAuthService().refreshAccessToken("refresh_token", token.refreshToken, this.mConfig.getClientId(), this.mConfig.getClientSecret());
        try {
            this.mTokenStore.update((AccessToken)newToken.execute().body());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ClientConfig getConfig() {
        return this.mConfig;
    }

    public AccessTokenStore getTokenStore() {
        return this.mTokenStore;
    }

    public static interface AuthenticationListener {
        public void onReady();

        public void onError();
    }

    private class WebApiAuthenticator
    implements Interceptor {
        private WebApiAuthenticator() {
        }

        public Response intercept(Interceptor.Chain chain) {
            AccessToken token = SpotifyApi.this.mTokenStore.read();
            if (token != null) {
                try {
                    Request request = chain.request().newBuilder().addHeader("Authorization", token.tokenType + " " + token.accessToken).build();
                    return chain.proceed(request);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

