/*
 * Decompiled with CFR 0.152.
 */
package com.drivemode.spotify;

import android.support.annotation.NonNull;
import android.text.TextUtils;

public class ClientConfig {
    private final String mClientId;
    private final String mClientSecret;
    private final String mRedirectUri;

    ClientConfig(@NonNull String clientId, @NonNull String clientSecret, @NonNull String redirectUri) {
        this.mClientId = clientId;
        this.mClientSecret = clientSecret;
        this.mRedirectUri = redirectUri;
    }

    @NonNull
    public String getClientId() {
        return this.mClientId;
    }

    @NonNull
    public String getClientSecret() {
        return this.mClientSecret;
    }

    @NonNull
    public String getRedirectUri() {
        return this.mRedirectUri;
    }

    public static class Builder {
        private String mClientId;
        private String mClientSecret;
        private String mRedirectUri;

        @NonNull
        public Builder setClientId(@NonNull String clientId) {
            this.mClientId = clientId;
            return this;
        }

        @NonNull
        public Builder setClientSecret(@NonNull String clientSecret) {
            this.mClientSecret = clientSecret;
            return this;
        }

        @NonNull
        public Builder setRedirectUri(@NonNull String redirectUri) {
            this.mRedirectUri = redirectUri;
            return this;
        }

        @NonNull
        public ClientConfig build() {
            this.validate();
            return new ClientConfig(this.mClientId, this.mClientSecret, this.mRedirectUri);
        }

        void validate() {
            if (TextUtils.isEmpty((CharSequence)this.mClientId)) {
                throw new IllegalStateException("Client id may not be null or empty.");
            }
            if (TextUtils.isEmpty((CharSequence)this.mClientSecret)) {
                throw new IllegalStateException("Client secret may not be null or empty.");
            }
            if (TextUtils.isEmpty((CharSequence)this.mRedirectUri)) {
                throw new IllegalStateException("Redirect uri may not be null or empty.");
            }
        }
    }
}

