/*
 * Decompiled with CFR 0.152.
 */
package jp.co.recruit_lifestyle.android.floatingview;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import jp.co.recruit_lifestyle.android.floatingview.ScreenChangedListener;

class FullscreenObserverView
extends View
implements ViewTreeObserver.OnGlobalLayoutListener,
View.OnSystemUiVisibilityChangeListener {
    static final int NO_LAST_VISIBILITY = -1;
    private static final int OVERLAY_TYPE = Build.VERSION.SDK_INT <= 25 ? 2006 : 2038;
    private final WindowManager.LayoutParams mParams;
    private final ScreenChangedListener mScreenChangedListener;
    private int mLastUiVisibility;
    private final Rect mWindowRect;

    FullscreenObserverView(Context context, ScreenChangedListener listener) {
        super(context);
        this.mScreenChangedListener = listener;
        this.mParams = new WindowManager.LayoutParams();
        this.mParams.width = 1;
        this.mParams.height = -1;
        this.mParams.type = OVERLAY_TYPE;
        this.mParams.flags = 56;
        this.mParams.format = -3;
        this.mWindowRect = new Rect();
        this.mLastUiVisibility = -1;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.setOnSystemUiVisibilityChangeListener(this);
    }

    protected void onDetachedFromWindow() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        } else {
            this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.setOnSystemUiVisibilityChangeListener(null);
        super.onDetachedFromWindow();
    }

    public void onGlobalLayout() {
        if (this.mScreenChangedListener != null) {
            this.getWindowVisibleDisplayFrame(this.mWindowRect);
            this.mScreenChangedListener.onScreenChanged(this.mWindowRect, this.mLastUiVisibility);
        }
    }

    public void onSystemUiVisibilityChange(int visibility) {
        this.mLastUiVisibility = visibility;
        if (this.mScreenChangedListener != null) {
            this.getWindowVisibleDisplayFrame(this.mWindowRect);
            this.mScreenChangedListener.onScreenChanged(this.mWindowRect, visibility);
        }
    }

    WindowManager.LayoutParams getWindowLayoutParams() {
        return this.mParams;
    }
}

