/*
 * Decompiled with CFR 0.152.
 */
package jp.co.recruit_lifestyle.android.floatingview;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.support.animation.DynamicAnimation;
import android.support.animation.FlingAnimation;
import android.support.animation.FloatValueHolder;
import android.support.animation.SpringAnimation;
import android.support.animation.SpringForce;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.util.DisplayMetrics;
import android.view.KeyCharacterMap;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import java.lang.ref.WeakReference;

public class FloatingView
extends FrameLayout
implements ViewTreeObserver.OnPreDrawListener {
    private static final float MOVE_THRESHOLD_DP = 8.0f;
    private static final float SCALE_PRESSED = 0.9f;
    private static final float SCALE_NORMAL = 1.0f;
    private static final long MOVE_TO_EDGE_DURATION = 450L;
    private static final float MOVE_TO_EDGE_OVERSHOOT_TENSION = 1.25f;
    static final int STATE_NORMAL = 0;
    static final int STATE_INTERSECTING = 1;
    static final int STATE_FINISHING = 2;
    private ValueAnimator mMoveEdgeAnimatorY;
    private ValueAnimator mMoveEdgeAnimatorX;
    private static final int LONG_PRESS_TIMEOUT = (int)(1.5f * (float)ViewConfiguration.getLongPressTimeout());
    static final int DEFAULT_X = Integer.MIN_VALUE;
    static final int DEFAULT_Y = Integer.MIN_VALUE;
    static final int DEFAULT_WIDTH = -2;
    static final int DEFAULT_HEIGHT = -2;
    private static final int OVERLAY_TYPE = Build.VERSION.SDK_INT <= 25 ? 2007 : 2038;
    private final WindowManager mWindowManager;
    private final WindowManager.LayoutParams mParams;
    private VelocityTracker mVelocityTracker;
    private final DisplayMetrics mMetrics;
    private long mTouchDownTime;
    private boolean mBlockMoveToEdge;
    private float mScreenTouchDownX;
    private float mScreenTouchDownY;
    private boolean mIsMoveAccept;
    private float mScreenTouchX;
    private float mScreenTouchY;
    private float mLocalTouchX;
    private float mLocalTouchY;
    private int mInitX;
    private int mInitY;
    private boolean mIsInitialAnimationRunning;
    private boolean mAnimateInitialMove;
    private final int mBaseStatusBarHeight;
    private int mStatusBarHeight;
    private final int mBaseNavigationBarHeight;
    private final int mBaseNavigationBarRotatedHeight;
    private int mNavigationBarVerticalOffset;
    private int mNavigationBarHorizontalOffset;
    private ValueAnimator mMoveEdgeAnimator;
    private final TimeInterpolator mMoveEdgeInterpolator;
    private final Rect mMoveLimitRect;
    private final Rect mPositionLimitRect;
    private boolean mIsDraggable;
    private float mShape;
    private final FloatingAnimationHandler mAnimationHandler;
    private final LongPressHandler mLongPressHandler;
    private int mOverMargin;
    private View.OnTouchListener mOnTouchListener;
    private boolean mIsLongPressed;
    private int mMoveDirection;
    private boolean mUsePhysics;
    private final boolean mIsTablet;
    private int mRotation;

    FloatingView(Context context) {
        super(context);
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mParams = new WindowManager.LayoutParams();
        this.mMetrics = new DisplayMetrics();
        this.mWindowManager.getDefaultDisplay().getMetrics(this.mMetrics);
        this.mParams.width = -2;
        this.mParams.height = -2;
        this.mParams.type = OVERLAY_TYPE;
        this.mParams.flags = 552;
        this.mParams.format = -3;
        this.mParams.gravity = 83;
        this.mAnimationHandler = new FloatingAnimationHandler(this);
        this.mLongPressHandler = new LongPressHandler(this);
        this.mMoveEdgeInterpolator = new OvershootInterpolator(1.25f);
        this.mMoveDirection = 0;
        this.mUsePhysics = false;
        Resources resources = context.getResources();
        this.mIsTablet = (resources.getConfiguration().screenLayout & 0xF) >= 3;
        this.mRotation = this.mWindowManager.getDefaultDisplay().getRotation();
        this.mMoveLimitRect = new Rect();
        this.mPositionLimitRect = new Rect();
        this.mStatusBarHeight = this.mBaseStatusBarHeight = FloatingView.getSystemUiDimensionPixelSize(resources, "status_bar_height");
        boolean hasMenuKey = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
        if (hasMenuKey || hasBackKey) {
            this.mBaseNavigationBarHeight = 0;
            this.mBaseNavigationBarRotatedHeight = 0;
        } else {
            this.mBaseNavigationBarHeight = FloatingView.getSystemUiDimensionPixelSize(resources, "navigation_bar_height");
            String resName = this.mIsTablet ? "navigation_bar_height_landscape" : "navigation_bar_width";
            this.mBaseNavigationBarRotatedHeight = FloatingView.getSystemUiDimensionPixelSize(resources, resName);
        }
        this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    private static int getSystemUiDimensionPixelSize(Resources resources, String resName) {
        int pixelSize = 0;
        int resId = resources.getIdentifier(resName, "dimen", "android");
        if (resId > 0) {
            pixelSize = resources.getDimensionPixelSize(resId);
        }
        return pixelSize;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.refreshLimitRect();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.refreshLimitRect();
    }

    public boolean onPreDraw() {
        this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        if (this.mInitX == Integer.MIN_VALUE) {
            this.mInitX = 0;
        }
        if (this.mInitY == Integer.MIN_VALUE) {
            this.mInitY = this.mMetrics.heightPixels - this.mStatusBarHeight - this.getMeasuredHeight();
        }
        this.mParams.x = this.mInitX;
        this.mParams.y = this.mInitY;
        if (this.mMoveDirection == 3) {
            this.moveTo(this.mInitX, this.mInitY, this.mInitX, this.mInitY, false);
        } else {
            this.mIsInitialAnimationRunning = true;
            this.moveToEdge(this.mInitX, this.mInitY, this.mAnimateInitialMove);
        }
        this.mIsDraggable = true;
        this.updateViewLayout();
        return true;
    }

    void onUpdateSystemLayout(boolean isHideStatusBar, boolean isHideNavigationBar, boolean isPortrait) {
        this.mStatusBarHeight = isHideStatusBar ? 0 : this.mBaseStatusBarHeight;
        this.updateNavigationBarOffset(isHideNavigationBar, isPortrait);
        this.refreshLimitRect();
    }

    private void updateNavigationBarOffset(boolean isHideNavigationBar, boolean isPortrait) {
        if (!isHideNavigationBar) {
            this.mNavigationBarVerticalOffset = 0;
            this.mNavigationBarHorizontalOffset = 0;
            return;
        }
        if (isPortrait) {
            this.mNavigationBarVerticalOffset = this.mBaseNavigationBarHeight;
            this.mNavigationBarHorizontalOffset = 0;
            return;
        }
        if (this.mIsTablet) {
            this.mNavigationBarVerticalOffset = this.mBaseNavigationBarRotatedHeight;
            this.mNavigationBarHorizontalOffset = 0;
        } else {
            this.mNavigationBarVerticalOffset = 0;
            this.mNavigationBarHorizontalOffset = this.mBaseNavigationBarRotatedHeight;
        }
    }

    private void refreshLimitRect() {
        this.cancelAnimation();
        int oldPositionLimitWidth = this.mPositionLimitRect.width();
        int oldPositionLimitHeight = this.mPositionLimitRect.height();
        this.mWindowManager.getDefaultDisplay().getMetrics(this.mMetrics);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int newScreenWidth = this.mMetrics.widthPixels;
        int newScreenHeight = this.mMetrics.heightPixels;
        this.mMoveLimitRect.set(-width, -height * 2, newScreenWidth + width + this.mNavigationBarHorizontalOffset, newScreenHeight + height + this.mNavigationBarVerticalOffset);
        this.mPositionLimitRect.set(-this.mOverMargin, 0, newScreenWidth - width + this.mOverMargin + this.mNavigationBarHorizontalOffset, newScreenHeight - this.mStatusBarHeight - height + this.mNavigationBarVerticalOffset);
        int newRotation = this.mWindowManager.getDefaultDisplay().getRotation();
        if (this.mAnimateInitialMove && this.mRotation != newRotation) {
            this.mIsInitialAnimationRunning = false;
        }
        if (this.mIsInitialAnimationRunning && this.mRotation == newRotation) {
            this.moveToEdge(this.mParams.x, this.mParams.y, true);
        } else if (this.mIsMoveAccept) {
            this.moveToEdge(this.mParams.x, this.mParams.y, false);
        } else {
            int newX = (int)((float)(this.mParams.x * this.mPositionLimitRect.width()) / (float)oldPositionLimitWidth + 0.5f);
            int goalPositionX = Math.min(Math.max(this.mPositionLimitRect.left, newX), this.mPositionLimitRect.right);
            int newY = (int)((float)(this.mParams.y * this.mPositionLimitRect.height()) / (float)oldPositionLimitHeight + 0.5f);
            int goalPositionY = Math.min(Math.max(this.mPositionLimitRect.top, newY), this.mPositionLimitRect.bottom);
            this.moveTo(this.mParams.x, this.mParams.y, goalPositionX, goalPositionY, false);
        }
        this.mRotation = newRotation;
    }

    protected void onDetachedFromWindow() {
        if (this.mMoveEdgeAnimator != null) {
            this.mMoveEdgeAnimator.removeAllUpdateListeners();
        }
        super.onDetachedFromWindow();
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent event) {
        if (this.getVisibility() != 0) {
            return true;
        }
        if (!this.mIsDraggable) {
            return true;
        }
        if (this.mIsInitialAnimationRunning) {
            return true;
        }
        this.mScreenTouchX = event.getRawX();
        this.mScreenTouchY = event.getRawY();
        int action = event.getAction();
        boolean isWaitForMoveToEdge = false;
        if (action == 0) {
            this.cancelAnimation();
            this.mScreenTouchDownX = this.mScreenTouchX;
            this.mScreenTouchDownY = this.mScreenTouchY;
            this.mLocalTouchX = event.getX();
            this.mLocalTouchY = event.getY();
            this.mIsMoveAccept = false;
            this.setScale(0.9f);
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            } else {
                this.mVelocityTracker.clear();
            }
            this.mAnimationHandler.updateTouchPosition(this.getXByTouch(), this.getYByTouch());
            this.mAnimationHandler.removeMessages(1);
            this.mAnimationHandler.sendAnimationMessage(1);
            this.mLongPressHandler.removeMessages(0);
            this.mLongPressHandler.sendEmptyMessageDelayed(0, LONG_PRESS_TIMEOUT);
            this.mTouchDownTime = event.getDownTime();
            this.mVelocityTracker.addMovement(event);
            this.mIsInitialAnimationRunning = false;
        } else if (action == 2) {
            if (this.mIsMoveAccept) {
                this.mIsLongPressed = false;
                this.mLongPressHandler.removeMessages(0);
            }
            if (this.mTouchDownTime != event.getDownTime()) {
                return true;
            }
            float moveThreshold = 8.0f * this.mMetrics.density;
            if (!this.mIsMoveAccept && Math.abs(this.mScreenTouchX - this.mScreenTouchDownX) < moveThreshold && Math.abs(this.mScreenTouchY - this.mScreenTouchDownY) < moveThreshold) {
                return true;
            }
            this.mIsMoveAccept = true;
            this.mAnimationHandler.updateTouchPosition(this.getXByTouch(), this.getYByTouch());
            event.setLocation(event.getRawX(), event.getRawY());
            this.mVelocityTracker.addMovement(event);
        } else if (action == 1 || action == 3) {
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.computeCurrentVelocity(1000);
            }
            boolean tmpIsLongPressed = this.mIsLongPressed;
            this.mIsLongPressed = false;
            this.mLongPressHandler.removeMessages(0);
            if (this.mTouchDownTime != event.getDownTime()) {
                return true;
            }
            this.mAnimationHandler.removeMessages(1);
            this.setScale(1.0f);
            if (!this.mIsMoveAccept) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            if (action == 1 && !tmpIsLongPressed && !this.mIsMoveAccept) {
                int size = this.getChildCount();
                for (int i = 0; i < size; ++i) {
                    this.getChildAt(i).performClick();
                }
            } else {
                isWaitForMoveToEdge = true;
            }
        }
        if (this.mOnTouchListener != null) {
            this.mOnTouchListener.onTouch((View)this, event);
        }
        if (isWaitForMoveToEdge && this.mAnimationHandler.getState() != 2) {
            this.moveToEdge(true);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return true;
    }

    private void onLongClick() {
        this.mIsLongPressed = true;
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            this.getChildAt(i).performLongClick();
        }
    }

    public void setVisibility(int visibility) {
        if (visibility != 0) {
            this.cancelLongPress();
            this.setScale(1.0f);
            if (this.mIsMoveAccept) {
                this.moveToEdge(false);
            }
            this.mAnimationHandler.removeMessages(1);
            this.mLongPressHandler.removeMessages(0);
        }
        super.setVisibility(visibility);
    }

    public void setOnTouchListener(View.OnTouchListener listener) {
        this.mOnTouchListener = listener;
    }

    public void setBlockMoveToEdge(boolean value) {
        this.mBlockMoveToEdge = value;
    }

    private void moveToEdge(boolean withAnimation) {
        int currentX = this.getXByTouch();
        int currentY = this.getYByTouch();
        this.moveToEdge(currentX, currentY, withAnimation);
    }

    private void moveToEdge(int startX, int startY, boolean withAnimation) {
        int goalPositionX = this.getGoalPositionX(startX, startY);
        int goalPositionY = this.getGoalPositionY(startX, startY);
        if (this.mBlockMoveToEdge) {
            return;
        }
        this.moveTo(startX, startY, goalPositionX, goalPositionY, withAnimation);
    }

    public void moveTo(int currentX, int currentY, int goalPositionX, int goalPositionY, boolean withAnimation) {
        goalPositionX = Math.min(Math.max(this.mPositionLimitRect.left, goalPositionX), this.mPositionLimitRect.right);
        goalPositionY = Math.min(Math.max(this.mPositionLimitRect.top, goalPositionY), this.mPositionLimitRect.bottom);
        if (withAnimation) {
            if (this.mUsePhysics && this.mVelocityTracker != null) {
                float maxVelocity = ViewConfiguration.get((Context)this.getContext()).getScaledMaximumFlingVelocity() / 8;
                float velocityY = -Math.min(Math.max(this.mVelocityTracker.getYVelocity(), -maxVelocity), maxVelocity);
                SpringForce springX = new SpringForce((float)goalPositionX).setDampingRatio(0.7f).setStiffness(350.0f);
                SpringAnimation springAnimationX = new SpringAnimation(new FloatValueHolder());
                ((SpringAnimation)((SpringAnimation)((SpringAnimation)((SpringAnimation)springAnimationX.setStartVelocity(this.mVelocityTracker.getXVelocity())).setStartValue((float)this.mParams.x)).setSpring(springX).setMinimumVisibleChange(1.0f)).addUpdateListener(new DynamicAnimation.OnAnimationUpdateListener(){

                    public void onAnimationUpdate(DynamicAnimation animation, float value, float velocity) {
                        int x = Math.round(value);
                        if (((FloatingView)FloatingView.this).mParams.x != x && FloatingView.this.mVelocityTracker == null) {
                            ((FloatingView)FloatingView.this).mParams.x = x;
                            try {
                                FloatingView.this.mWindowManager.updateViewLayout((View)FloatingView.this, (ViewGroup.LayoutParams)FloatingView.this.mParams);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    }
                })).start();
                if (this.mParams.y < this.mPositionLimitRect.bottom && this.mParams.y > this.mPositionLimitRect.top) {
                    FlingAnimation flingAnimationY = new FlingAnimation(new FloatValueHolder());
                    ((FlingAnimation)((FlingAnimation)((FlingAnimation)flingAnimationY.setStartVelocity(velocityY).setMaxValue((float)this.mPositionLimitRect.bottom).setMinValue((float)this.mPositionLimitRect.top).setStartValue((float)this.mParams.y)).setFriction(1.7f).setMinimumVisibleChange(1.0f)).addUpdateListener(new DynamicAnimation.OnAnimationUpdateListener(){

                        public void onAnimationUpdate(DynamicAnimation animation, float value, float velocity) {
                            int y = Math.round(value);
                            if (((FloatingView)FloatingView.this).mParams.y != y && FloatingView.this.mVelocityTracker == null) {
                                ((FloatingView)FloatingView.this).mParams.y = y;
                                try {
                                    FloatingView.this.mWindowManager.updateViewLayout((View)FloatingView.this, (ViewGroup.LayoutParams)FloatingView.this.mParams);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                        }
                    })).start();
                } else {
                    SpringForce springY = new SpringForce(currentY < this.mMetrics.heightPixels / 2 ? (float)this.mPositionLimitRect.top : (float)this.mPositionLimitRect.bottom).setDampingRatio(0.75f).setStiffness(200.0f);
                    SpringAnimation springAnimationY = new SpringAnimation(new FloatValueHolder());
                    ((SpringAnimation)((SpringAnimation)((SpringAnimation)((SpringAnimation)springAnimationY.setStartVelocity(velocityY)).setStartValue((float)this.mParams.y)).setSpring(springY).setMinimumVisibleChange(1.0f)).addUpdateListener(new DynamicAnimation.OnAnimationUpdateListener(){

                        public void onAnimationUpdate(DynamicAnimation animation, float value, float velocity) {
                            int y = Math.round(value);
                            if (((FloatingView)FloatingView.this).mParams.y != y && FloatingView.this.mVelocityTracker == null) {
                                ((FloatingView)FloatingView.this).mParams.y = y;
                                try {
                                    FloatingView.this.mWindowManager.updateViewLayout((View)FloatingView.this, (ViewGroup.LayoutParams)FloatingView.this.mParams);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                        }
                    })).start();
                }
            } else {
                final boolean longestY = Math.abs(currentY - goalPositionY) > Math.abs(currentX - goalPositionX);
                this.mMoveEdgeAnimatorY = ValueAnimator.ofInt((int[])new int[]{currentY, goalPositionY});
                this.mMoveEdgeAnimatorY.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        ((FloatingView)FloatingView.this).mParams.y = (Integer)animation.getAnimatedValue();
                        if (longestY) {
                            FloatingView.this.updateViewLayout();
                            FloatingView.this.updateInitAnimation(animation);
                        }
                    }
                });
                final int finalGoalPositionY = goalPositionY;
                this.mMoveEdgeAnimatorY.addListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        ((FloatingView)FloatingView.this).mParams.y = finalGoalPositionY;
                        FloatingView.this.updateViewLayout();
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                this.mMoveEdgeAnimatorY.setDuration(450L);
                this.mMoveEdgeAnimatorY.setInterpolator(this.mMoveEdgeInterpolator);
                this.mMoveEdgeAnimatorX = ValueAnimator.ofInt((int[])new int[]{currentX, goalPositionX});
                this.mMoveEdgeAnimatorX.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        ((FloatingView)FloatingView.this).mParams.x = (Integer)animation.getAnimatedValue();
                        if (!longestY) {
                            FloatingView.this.updateViewLayout();
                            FloatingView.this.updateInitAnimation(animation);
                        }
                    }
                });
                final int finalGoalPositionX = goalPositionX;
                this.mMoveEdgeAnimatorX.addListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        ((FloatingView)FloatingView.this).mParams.x = finalGoalPositionX;
                        FloatingView.this.updateViewLayout();
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                this.mMoveEdgeAnimatorX.setDuration(450L);
                this.mMoveEdgeAnimatorX.setInterpolator(this.mMoveEdgeInterpolator);
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (FloatingView.this.mMoveEdgeAnimatorY != null) {
                            FloatingView.this.mMoveEdgeAnimatorY.start();
                        }
                        if (FloatingView.this.mMoveEdgeAnimatorX != null) {
                            FloatingView.this.mMoveEdgeAnimatorX.start();
                        }
                    }
                });
            }
        } else if (this.mParams.x != goalPositionX || this.mParams.y != goalPositionY) {
            this.mParams.x = goalPositionX;
            this.mParams.y = goalPositionY;
            this.updateViewLayout();
        }
        this.mLocalTouchX = 0.0f;
        this.mLocalTouchY = 0.0f;
        this.mScreenTouchDownX = 0.0f;
        this.mScreenTouchDownY = 0.0f;
        this.mIsMoveAccept = false;
    }

    private void updateViewLayout() {
        if (!ViewCompat.isAttachedToWindow((View)this)) {
            return;
        }
        this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mParams);
    }

    private void updateInitAnimation(ValueAnimator animation) {
        if (this.mAnimateInitialMove && animation.getDuration() <= animation.getCurrentPlayTime()) {
            this.mIsInitialAnimationRunning = false;
        }
    }

    private int getGoalPositionX(int startX, int startY) {
        int goalPositionX = startX;
        if (this.mMoveDirection == 0) {
            boolean isMoveRightEdge = startX > (this.mMetrics.widthPixels - this.getWidth()) / 2;
            goalPositionX = isMoveRightEdge ? this.mPositionLimitRect.right : this.mPositionLimitRect.left;
        } else if (this.mMoveDirection == 1) {
            goalPositionX = this.mPositionLimitRect.left;
        } else if (this.mMoveDirection == 2) {
            goalPositionX = this.mPositionLimitRect.right;
        } else if (this.mMoveDirection == 4) {
            int distTopBottom;
            int distLeftRight = Math.min(startX, this.mPositionLimitRect.width() - startX);
            if (distLeftRight < (distTopBottom = Math.min(startY, this.mPositionLimitRect.height() - startY))) {
                boolean isMoveRightEdge = startX > (this.mMetrics.widthPixels - this.getWidth()) / 2;
                goalPositionX = isMoveRightEdge ? this.mPositionLimitRect.right : this.mPositionLimitRect.left;
            }
        } else if (this.mMoveDirection == 5) {
            float minVelocity = ViewConfiguration.get((Context)this.getContext()).getScaledMaximumFlingVelocity() / 9;
            if (this.mVelocityTracker != null && this.mVelocityTracker.getXVelocity() > minVelocity) {
                goalPositionX = this.mPositionLimitRect.right;
            } else if (this.mVelocityTracker != null && this.mVelocityTracker.getXVelocity() < -minVelocity) {
                goalPositionX = this.mPositionLimitRect.left;
            } else {
                boolean isMoveRightEdge = startX > (this.mMetrics.widthPixels - this.getWidth()) / 2;
                goalPositionX = isMoveRightEdge ? this.mPositionLimitRect.right : this.mPositionLimitRect.left;
            }
        }
        return goalPositionX;
    }

    public Rect getPositionLimits() {
        return this.mPositionLimitRect;
    }

    private int getGoalPositionY(int startX, int startY) {
        int distTopBottom;
        int distLeftRight;
        int goalPositionY = startY;
        if (this.mMoveDirection == 4 && (distLeftRight = Math.min(startX, this.mPositionLimitRect.width() - startX)) >= (distTopBottom = Math.min(startY, this.mPositionLimitRect.height() - startY))) {
            boolean isMoveTopEdge = startY < (this.mMetrics.heightPixels - this.getHeight()) / 2;
            goalPositionY = isMoveTopEdge ? this.mPositionLimitRect.top : this.mPositionLimitRect.bottom;
        }
        return goalPositionY;
    }

    private void cancelAnimation() {
        if (this.mMoveEdgeAnimator != null && this.mMoveEdgeAnimator.isStarted()) {
            this.mMoveEdgeAnimator.cancel();
            this.mMoveEdgeAnimator = null;
        }
    }

    private void setScale(float newScale) {
        if (Build.VERSION.SDK_INT <= 19) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View targetView = this.getChildAt(i);
                targetView.setScaleX(newScale);
                targetView.setScaleY(newScale);
            }
        } else {
            this.setScaleX(newScale);
            this.setScaleY(newScale);
        }
    }

    void setDraggable(boolean isDraggable) {
        this.mIsDraggable = isDraggable;
    }

    void setShape(float shape) {
        this.mShape = shape;
    }

    float getShape() {
        return this.mShape;
    }

    void setOverMargin(int margin) {
        this.mOverMargin = margin;
    }

    void setMoveDirection(int moveDirection) {
        this.mMoveDirection = moveDirection;
    }

    void usePhysics(boolean usePhysics) {
        this.mUsePhysics = usePhysics && Build.VERSION.SDK_INT >= 16;
    }

    void setInitCoords(int x, int y) {
        this.mInitX = x;
        this.mInitY = y;
    }

    void setAnimateInitialMove(boolean animateInitialMove) {
        this.mAnimateInitialMove = animateInitialMove;
    }

    void getWindowDrawingRect(Rect outRect) {
        int currentX = this.getXByTouch();
        int currentY = this.getYByTouch();
        outRect.set(currentX, currentY, currentX + this.getWidth(), currentY + this.getHeight());
    }

    WindowManager.LayoutParams getWindowLayoutParams() {
        return this.mParams;
    }

    private int getXByTouch() {
        return (int)(this.mScreenTouchX - this.mLocalTouchX);
    }

    private int getYByTouch() {
        return (int)((float)(this.mMetrics.heightPixels + this.mNavigationBarVerticalOffset) - (this.mScreenTouchY - this.mLocalTouchY + (float)this.getHeight()));
    }

    void setNormal() {
        this.mAnimationHandler.setState(0);
        this.mAnimationHandler.updateTouchPosition(this.getXByTouch(), this.getYByTouch());
    }

    void setIntersecting(int centerX, int centerY) {
        this.mAnimationHandler.setState(1);
        this.mAnimationHandler.updateTargetPosition(centerX, centerY);
    }

    void setFinishing() {
        this.mAnimationHandler.setState(2);
        this.mIsMoveAccept = false;
        this.setVisibility(8);
    }

    int getState() {
        return this.mAnimationHandler.getState();
    }

    static class LongPressHandler
    extends Handler {
        private final WeakReference<FloatingView> mFloatingView;
        private static final int LONG_PRESSED = 0;

        LongPressHandler(FloatingView view) {
            this.mFloatingView = new WeakReference<FloatingView>(view);
        }

        public void handleMessage(Message msg) {
            FloatingView view = (FloatingView)((Object)this.mFloatingView.get());
            if (view == null) {
                this.removeMessages(0);
                return;
            }
            view.onLongClick();
        }
    }

    static class FloatingAnimationHandler
    extends Handler {
        private static final long ANIMATION_REFRESH_TIME_MILLIS = 10L;
        private static final long CAPTURE_DURATION_MILLIS = 300L;
        private static final int ANIMATION_NONE = 0;
        private static final int ANIMATION_IN_TOUCH = 1;
        private static final int TYPE_FIRST = 1;
        private static final int TYPE_UPDATE = 2;
        private long mStartTime;
        private float mStartX;
        private float mStartY;
        private int mStartedCode;
        private int mState;
        private boolean mIsChangeState;
        private float mTouchPositionX;
        private float mTouchPositionY;
        private float mTargetPositionX;
        private float mTargetPositionY;
        private final WeakReference<FloatingView> mFloatingView;

        FloatingAnimationHandler(FloatingView floatingView) {
            this.mFloatingView = new WeakReference<FloatingView>(floatingView);
            this.mStartedCode = 0;
            this.mState = 0;
        }

        public void handleMessage(Message msg) {
            FloatingView floatingView = (FloatingView)((Object)this.mFloatingView.get());
            if (floatingView == null) {
                this.removeMessages(1);
                return;
            }
            int animationCode = msg.what;
            int animationType = msg.arg1;
            WindowManager.LayoutParams params = floatingView.mParams;
            if (this.mIsChangeState || animationType == 1) {
                this.mStartTime = this.mIsChangeState ? SystemClock.uptimeMillis() : 0L;
                this.mStartX = params.x;
                this.mStartY = params.y;
                this.mStartedCode = animationCode;
                this.mIsChangeState = false;
            }
            float elapsedTime = SystemClock.uptimeMillis() - this.mStartTime;
            float trackingTargetTimeRate = Math.min(elapsedTime / 300.0f, 1.0f);
            if (this.mState == 0) {
                float basePosition = FloatingAnimationHandler.calcAnimationPosition(trackingTargetTimeRate);
                Rect moveLimitRect = floatingView.mMoveLimitRect;
                float targetPositionX = Math.min(Math.max(moveLimitRect.left, (int)this.mTouchPositionX), moveLimitRect.right);
                float targetPositionY = Math.min(Math.max(moveLimitRect.top, (int)this.mTouchPositionY), moveLimitRect.bottom);
                params.x = (int)(this.mStartX + (targetPositionX - this.mStartX) * basePosition);
                params.y = (int)(this.mStartY + (targetPositionY - this.mStartY) * basePosition);
                floatingView.updateViewLayout();
                this.sendMessageAtTime(FloatingAnimationHandler.newMessage(animationCode, 2), SystemClock.uptimeMillis() + 10L);
            } else if (this.mState == 1) {
                float basePosition = FloatingAnimationHandler.calcAnimationPosition(trackingTargetTimeRate);
                float targetPositionX = this.mTargetPositionX - (float)(floatingView.getWidth() / 2);
                float targetPositionY = this.mTargetPositionY - (float)(floatingView.getHeight() / 2);
                params.x = (int)(this.mStartX + (targetPositionX - this.mStartX) * basePosition);
                params.y = (int)(this.mStartY + (targetPositionY - this.mStartY) * basePosition);
                floatingView.updateViewLayout();
                this.sendMessageAtTime(FloatingAnimationHandler.newMessage(animationCode, 2), SystemClock.uptimeMillis() + 10L);
            }
        }

        private static float calcAnimationPosition(float timeRate) {
            float position = (double)timeRate <= 0.4 ? (float)(0.55 * Math.sin(8.0564 * (double)timeRate - 1.5707963267948966) + 0.55) : (float)(4.0 * Math.pow(0.417 * (double)timeRate - 0.341, 2.0) - 4.0 * Math.pow(0.07599999999999996, 2.0) + 1.0);
            return position;
        }

        void sendAnimationMessageDelayed(int animation, long delayMillis) {
            this.sendMessageAtTime(FloatingAnimationHandler.newMessage(animation, 1), SystemClock.uptimeMillis() + delayMillis);
        }

        void sendAnimationMessage(int animation) {
            this.sendMessage(FloatingAnimationHandler.newMessage(animation, 1));
        }

        private static Message newMessage(int animation, int type) {
            Message message = Message.obtain();
            message.what = animation;
            message.arg1 = type;
            return message;
        }

        void updateTouchPosition(float positionX, float positionY) {
            this.mTouchPositionX = positionX;
            this.mTouchPositionY = positionY;
        }

        void updateTargetPosition(float centerX, float centerY) {
            this.mTargetPositionX = centerX;
            this.mTargetPositionY = centerY;
        }

        void setState(int newState) {
            if (this.mState != newState) {
                this.mIsChangeState = true;
            }
            this.mState = newState;
        }

        int getState() {
            return this.mState;
        }
    }
}

