/*
 * Decompiled with CFR 0.152.
 */
package com.github.gcacace.signaturepad.utils;

import com.github.gcacace.signaturepad.utils.TimedPoint;

class SvgPoint {
    final Integer x;
    final Integer y;

    public SvgPoint(TimedPoint point) {
        this.x = Math.round(point.x);
        this.y = Math.round(point.y);
    }

    public SvgPoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public String toAbsoluteCoordinates() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.x);
        if (this.y >= 0) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(this.y);
        return stringBuilder.toString();
    }

    public String toRelativeCoordinates(SvgPoint referencePoint) {
        return new SvgPoint(this.x - referencePoint.x, this.y - referencePoint.y).toString();
    }

    public String toString() {
        return this.toAbsoluteCoordinates();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvgPoint svgPoint = (SvgPoint)o;
        if (!this.x.equals(svgPoint.x)) {
            return false;
        }
        return this.y.equals(svgPoint.y);
    }

    public int hashCode() {
        int result = this.x.hashCode();
        result = 31 * result + this.y.hashCode();
        return result;
    }
}

