/*
 * Decompiled with CFR 0.152.
 */
package com.github.gcacace.signaturepad.utils;

import com.github.gcacace.signaturepad.utils.SvgPoint;

public class SvgPathBuilder {
    public static final Character SVG_RELATIVE_CUBIC_BEZIER_CURVE = Character.valueOf('c');
    public static final Character SVG_MOVE = Character.valueOf('M');
    private final StringBuilder mStringBuilder;
    private final Integer mStrokeWidth;
    private final SvgPoint mStartPoint;
    private SvgPoint mLastPoint;
    private Character mLastSvgCommand;

    public SvgPathBuilder(SvgPoint startPoint, Integer strokeWidth) {
        this.mStrokeWidth = strokeWidth;
        this.mStartPoint = startPoint;
        this.mLastPoint = startPoint;
        this.mLastSvgCommand = null;
        this.mStringBuilder = new StringBuilder();
    }

    public final Integer getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public final SvgPoint getLastPoint() {
        return this.mLastPoint;
    }

    public SvgPathBuilder append(SvgPoint controlPoint1, SvgPoint controlPoint2, SvgPoint endPoint) {
        this.mStringBuilder.append(this.makeRelativeCubicBezierCurve(controlPoint1, controlPoint2, endPoint));
        this.mLastSvgCommand = SVG_RELATIVE_CUBIC_BEZIER_CURVE;
        this.mLastPoint = endPoint;
        return this;
    }

    public String toString() {
        return "<path " + "stroke-width=\"" + this.mStrokeWidth + "\" " + "d=\"" + SVG_MOVE + this.mStartPoint + this.mStringBuilder + "\"/>";
    }

    private String makeRelativeCubicBezierCurve(SvgPoint controlPoint1, SvgPoint controlPoint2, SvgPoint endPoint) {
        String sControlPoint1 = controlPoint1.toRelativeCoordinates(this.mLastPoint);
        String sControlPoint2 = controlPoint2.toRelativeCoordinates(this.mLastPoint);
        String sEndPoint = endPoint.toRelativeCoordinates(this.mLastPoint);
        StringBuilder sb = new StringBuilder();
        if (!SVG_RELATIVE_CUBIC_BEZIER_CURVE.equals(this.mLastSvgCommand)) {
            sb.append(SVG_RELATIVE_CUBIC_BEZIER_CURVE);
            sb.append(sControlPoint1);
        } else {
            if (!sControlPoint1.startsWith("-")) {
                sb.append(" ");
            }
            sb.append(sControlPoint1);
        }
        if (!sControlPoint2.startsWith("-")) {
            sb.append(" ");
        }
        sb.append(sControlPoint2);
        if (!sEndPoint.startsWith("-")) {
            sb.append(" ");
        }
        sb.append(sEndPoint);
        String svg = sb.toString();
        if ("c0 0 0 0 0 0".equals(svg)) {
            return "";
        }
        return svg;
    }
}

