/*
 * Decompiled with CFR 0.152.
 */
package com.github.gcacace.signaturepad.views;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.github.gcacace.signaturepad.R;
import com.github.gcacace.signaturepad.utils.Bezier;
import com.github.gcacace.signaturepad.utils.ControlTimedPoints;
import com.github.gcacace.signaturepad.utils.TimedPoint;
import java.util.ArrayList;
import java.util.List;

public class SignaturePad
extends View {
    private List<TimedPoint> mPoints;
    private boolean mIsEmpty;
    private float mLastTouchX;
    private float mLastTouchY;
    private float mLastVelocity;
    private float mLastWidth;
    private RectF mDirtyRect;
    private int mMinWidth;
    private int mMaxWidth;
    private float mVelocityFilterWeight;
    private OnSignedListener mOnSignedListener;
    private Paint mPaint = new Paint();
    private Path mPath = new Path();
    private Bitmap mSignatureBitmap = null;
    private Canvas mSignatureBitmapCanvas = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignaturePad(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SignaturePad, 0, 0);
        try {
            this.mMinWidth = a.getDimensionPixelSize(R.styleable.SignaturePad_minWidth, this.convertDpToPx(3.0f));
            this.mMaxWidth = a.getDimensionPixelSize(R.styleable.SignaturePad_maxWidth, this.convertDpToPx(7.0f));
            this.mVelocityFilterWeight = a.getFloat(R.styleable.SignaturePad_velocityFilterWeight, 0.9f);
            this.mPaint.setColor(a.getColor(R.styleable.SignaturePad_penColor, -16777216));
        }
        finally {
            a.recycle();
        }
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mDirtyRect = new RectF();
        this.clear();
    }

    public void setPenColorRes(int colorRes) {
        try {
            this.setPenColor(this.getResources().getColor(colorRes));
        }
        catch (Resources.NotFoundException ex) {
            this.setPenColor(this.getResources().getColor(-16777216));
        }
    }

    public void setPenColor(int color) {
        this.mPaint.setColor(color);
    }

    public void setMinWidth(float minWidth) {
        this.mMinWidth = this.convertDpToPx(minWidth);
    }

    public void setMaxWidth(float maxWidth) {
        this.mMaxWidth = this.convertDpToPx(maxWidth);
    }

    public void setVelocityFilterWeight(float velocityFilterWeight) {
        this.mVelocityFilterWeight = velocityFilterWeight;
    }

    public void clear() {
        this.mPoints = new ArrayList<TimedPoint>();
        this.mLastVelocity = 0.0f;
        this.mLastWidth = (this.mMinWidth + this.mMaxWidth) / 2;
        this.mPath.reset();
        if (this.mSignatureBitmap != null) {
            this.mSignatureBitmap = null;
            this.ensureSignatureBitmap();
        }
        this.setIsEmpty(true);
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        float eventX = event.getX();
        float eventY = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.mPoints.clear();
                this.mPath.moveTo(eventX, eventY);
                this.mLastTouchX = eventX;
                this.mLastTouchY = eventY;
                this.addPoint(new TimedPoint(eventX, eventY));
            }
            case 2: {
                this.resetDirtyRect(eventX, eventY);
                this.addPoint(new TimedPoint(eventX, eventY));
                break;
            }
            case 1: {
                this.resetDirtyRect(eventX, eventY);
                this.addPoint(new TimedPoint(eventX, eventY));
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.setIsEmpty(false);
                break;
            }
            default: {
                return false;
            }
        }
        this.invalidate((int)(this.mDirtyRect.left - (float)this.mMaxWidth), (int)(this.mDirtyRect.top - (float)this.mMaxWidth), (int)(this.mDirtyRect.right + (float)this.mMaxWidth), (int)(this.mDirtyRect.bottom + (float)this.mMaxWidth));
        return true;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mSignatureBitmap != null) {
            canvas.drawBitmap(this.mSignatureBitmap, 0.0f, 0.0f, this.mPaint);
        }
    }

    public void setOnSignedListener(OnSignedListener listener) {
        this.mOnSignedListener = listener;
    }

    public boolean isEmpty() {
        return this.mIsEmpty;
    }

    public Bitmap getSignatureBitmap() {
        Bitmap originalBitmap = this.getTransparentSignatureBitmap();
        Bitmap whiteBgBitmap = Bitmap.createBitmap((int)originalBitmap.getWidth(), (int)originalBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(whiteBgBitmap);
        canvas.drawColor(-1);
        canvas.drawBitmap(originalBitmap, 0.0f, 0.0f, null);
        return whiteBgBitmap;
    }

    public void setSignatureBitmap(Bitmap signature) {
        this.clear();
        this.ensureSignatureBitmap();
        RectF tempSrc = new RectF();
        RectF tempDst = new RectF();
        int dWidth = signature.getWidth();
        int dHeight = signature.getHeight();
        int vWidth = this.getWidth();
        int vHeight = this.getHeight();
        tempSrc.set(0.0f, 0.0f, (float)dWidth, (float)dHeight);
        tempDst.set(0.0f, 0.0f, (float)vWidth, (float)vHeight);
        Matrix drawMatrix = new Matrix();
        drawMatrix.setRectToRect(tempSrc, tempDst, Matrix.ScaleToFit.CENTER);
        Canvas canvas = new Canvas(this.mSignatureBitmap);
        canvas.drawBitmap(signature, drawMatrix, null);
        this.setIsEmpty(false);
        this.invalidate();
    }

    public Bitmap getTransparentSignatureBitmap() {
        this.ensureSignatureBitmap();
        return this.mSignatureBitmap;
    }

    public Bitmap getTransparentSignatureBitmap(boolean trimBlankSpace) {
        if (!trimBlankSpace) {
            return this.getTransparentSignatureBitmap();
        }
        this.ensureSignatureBitmap();
        int imgHeight = this.mSignatureBitmap.getHeight();
        int imgWidth = this.mSignatureBitmap.getWidth();
        int width = 0;
        block0: for (int i = 0; i < imgHeight; ++i) {
            for (int j = imgWidth - 1; j >= 0; --j) {
                if (this.mSignatureBitmap.getPixel(j, i) == 0 || j <= width) continue;
                width = j;
                continue block0;
            }
        }
        int height = 0;
        block2: for (int i = 0; i < imgWidth; ++i) {
            for (int j = imgHeight - 1; j >= 0; --j) {
                if (this.mSignatureBitmap.getPixel(i, j) == 0 || j <= height) continue;
                height = j;
                continue block2;
            }
        }
        return Bitmap.createBitmap((Bitmap)this.mSignatureBitmap, (int)0, (int)0, (int)width, (int)height);
    }

    private void addPoint(TimedPoint newPoint) {
        this.mPoints.add(newPoint);
        if (this.mPoints.size() > 2) {
            if (this.mPoints.size() == 3) {
                this.mPoints.add(0, this.mPoints.get(0));
            }
            ControlTimedPoints tmp = this.calculateCurveControlPoints(this.mPoints.get(0), this.mPoints.get(1), this.mPoints.get(2));
            TimedPoint c2 = tmp.c2;
            tmp = this.calculateCurveControlPoints(this.mPoints.get(1), this.mPoints.get(2), this.mPoints.get(3));
            TimedPoint c3 = tmp.c1;
            Bezier curve = new Bezier(this.mPoints.get(1), c2, c3, this.mPoints.get(2));
            TimedPoint endPoint = curve.endPoint;
            TimedPoint startPoint = curve.startPoint;
            float velocity = endPoint.velocityFrom(startPoint);
            velocity = Float.isNaN(velocity) ? 0.0f : velocity;
            velocity = this.mVelocityFilterWeight * velocity + (1.0f - this.mVelocityFilterWeight) * this.mLastVelocity;
            float newWidth = this.strokeWidth(velocity);
            this.addBezier(curve, this.mLastWidth, newWidth);
            this.mLastVelocity = velocity;
            this.mLastWidth = newWidth;
            this.mPoints.remove(0);
        }
    }

    private void addBezier(Bezier curve, float startWidth, float endWidth) {
        this.ensureSignatureBitmap();
        float originalWidth = this.mPaint.getStrokeWidth();
        float widthDelta = endWidth - startWidth;
        float drawSteps = (float)Math.floor(curve.length());
        int i = 0;
        while ((float)i < drawSteps) {
            float t = (float)i / drawSteps;
            float tt = t * t;
            float ttt = tt * t;
            float u = 1.0f - t;
            float uu = u * u;
            float uuu = uu * u;
            float x = uuu * curve.startPoint.x;
            x += 3.0f * uu * t * curve.control1.x;
            x += 3.0f * u * tt * curve.control2.x;
            float y = uuu * curve.startPoint.y;
            y += 3.0f * uu * t * curve.control1.y;
            y += 3.0f * u * tt * curve.control2.y;
            this.mPaint.setStrokeWidth(startWidth + ttt * widthDelta);
            this.mSignatureBitmapCanvas.drawPoint(x += ttt * curve.endPoint.x, y += ttt * curve.endPoint.y, this.mPaint);
            this.expandDirtyRect(x, y);
            ++i;
        }
        this.mPaint.setStrokeWidth(originalWidth);
    }

    private ControlTimedPoints calculateCurveControlPoints(TimedPoint s1, TimedPoint s2, TimedPoint s3) {
        float dx1 = s1.x - s2.x;
        float dy1 = s1.y - s2.y;
        float dx2 = s2.x - s3.x;
        float dy2 = s2.y - s3.y;
        TimedPoint m1 = new TimedPoint((s1.x + s2.x) / 2.0f, (s1.y + s2.y) / 2.0f);
        TimedPoint m2 = new TimedPoint((s2.x + s3.x) / 2.0f, (s2.y + s3.y) / 2.0f);
        float l1 = (float)Math.sqrt(dx1 * dx1 + dy1 * dy1);
        float l2 = (float)Math.sqrt(dx2 * dx2 + dy2 * dy2);
        float dxm = m1.x - m2.x;
        float dym = m1.y - m2.y;
        float k = l2 / (l1 + l2);
        TimedPoint cm = new TimedPoint(m2.x + dxm * k, m2.y + dym * k);
        float tx = s2.x - cm.x;
        float ty = s2.y - cm.y;
        return new ControlTimedPoints(new TimedPoint(m1.x + tx, m1.y + ty), new TimedPoint(m2.x + tx, m2.y + ty));
    }

    private float strokeWidth(float velocity) {
        return Math.max((float)this.mMaxWidth / (velocity + 1.0f), (float)this.mMinWidth);
    }

    private void expandDirtyRect(float historicalX, float historicalY) {
        if (historicalX < this.mDirtyRect.left) {
            this.mDirtyRect.left = historicalX;
        } else if (historicalX > this.mDirtyRect.right) {
            this.mDirtyRect.right = historicalX;
        }
        if (historicalY < this.mDirtyRect.top) {
            this.mDirtyRect.top = historicalY;
        } else if (historicalY > this.mDirtyRect.bottom) {
            this.mDirtyRect.bottom = historicalY;
        }
    }

    private void resetDirtyRect(float eventX, float eventY) {
        this.mDirtyRect.left = Math.min(this.mLastTouchX, eventX);
        this.mDirtyRect.right = Math.max(this.mLastTouchX, eventX);
        this.mDirtyRect.top = Math.min(this.mLastTouchY, eventY);
        this.mDirtyRect.bottom = Math.max(this.mLastTouchY, eventY);
    }

    private void setIsEmpty(boolean newValue) {
        this.mIsEmpty = newValue;
        if (this.mOnSignedListener != null) {
            if (this.mIsEmpty) {
                this.mOnSignedListener.onClear();
            } else {
                this.mOnSignedListener.onSigned();
            }
        }
    }

    private void ensureSignatureBitmap() {
        if (this.mSignatureBitmap == null) {
            this.mSignatureBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mSignatureBitmapCanvas = new Canvas(this.mSignatureBitmap);
        }
    }

    private int convertDpToPx(float dp) {
        return Math.round(dp * (this.getResources().getDisplayMetrics().xdpi / 160.0f));
    }

    public static interface OnSignedListener {
        public void onSigned();

        public void onClear();
    }
}

