/*
 * Decompiled with CFR 0.152.
 */
package com.github.gcacace.signaturepad.utils;

import com.github.gcacace.signaturepad.utils.TimedPoint;

public class Bezier {
    public TimedPoint startPoint;
    public TimedPoint control1;
    public TimedPoint control2;
    public TimedPoint endPoint;

    public Bezier(TimedPoint startPoint, TimedPoint control1, TimedPoint control2, TimedPoint endPoint) {
        this.startPoint = startPoint;
        this.control1 = control1;
        this.control2 = control2;
        this.endPoint = endPoint;
    }

    public float length() {
        int steps = 10;
        int length = 0;
        double px = 0.0;
        double py = 0.0;
        for (int i = 0; i <= steps; ++i) {
            float t = i / steps;
            double cx = this.point(t, this.startPoint.x, this.control1.x, this.control2.x, this.endPoint.x);
            double cy = this.point(t, this.startPoint.y, this.control1.y, this.control2.y, this.endPoint.y);
            if (i > 0) {
                double xdiff = cx - px;
                double ydiff = cy - py;
                length = (int)((double)length + Math.sqrt(xdiff * xdiff + ydiff * ydiff));
            }
            px = cx;
            py = cy;
        }
        return length;
    }

    public double point(float t, float start, float c1, float c2, float end) {
        return (double)start * (1.0 - (double)t) * (1.0 - (double)t) * (1.0 - (double)t) + 3.0 * (double)c1 * (1.0 - (double)t) * (1.0 - (double)t) * (double)t + 3.0 * (double)c2 * (1.0 - (double)t) * (double)t * (double)t + (double)(end * t * t * t);
    }
}

