/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.printer;

import info.leadinglight.umljavadoclet.model.Model;
import info.leadinglight.umljavadoclet.model.ModelClass;
import info.leadinglight.umljavadoclet.model.ModelPackage;
import info.leadinglight.umljavadoclet.model.ModelRel;
import info.leadinglight.umljavadoclet.printer.DiagramOptions;
import info.leadinglight.umljavadoclet.printer.Printer;
import java.util.List;

public abstract class PumlDiagramPrinter
extends Printer {
    private final Model _model;
    private final DiagramOptions _options;

    public PumlDiagramPrinter(Model model, DiagramOptions options) {
        this._model = model;
        this._options = options;
    }

    public Model getModel() {
        return this._model;
    }

    public DiagramOptions getOptions() {
        return this._options;
    }

    public void start() {
        this.println("@startuml");
        if (this._options.hasPumlIncludeFile()) {
            this.println("!include " + this._options.getPumlIncludeFile());
        }
        this.newline();
        this.svglinktargetOption("_parent");
        this.printLineTypeOption();
    }

    public void leftToRight() {
        this.println("left to right direction");
    }

    public void noPackagesOption() {
        this.println("set namespaceSeparator none");
    }

    public void rectangularPackagesOption() {
        this.println("skinparam packageStyle rect");
    }

    public void svglinktargetOption(String target) {
        this.println("skinparam svgLinkTarget " + target);
    }

    public void end() {
        this.newline();
        this.println("@enduml");
    }

    public void packageDefinition(ModelPackage modelPackage, String filepath, String color) {
        this.print("package ");
        this.print(modelPackage.fullName());
        if (filepath != null && filepath.length() > 0) {
            this.print(" [[");
            this.print(filepath);
            this.print("{" + modelPackage.fullName() + "}");
            this.print("]]");
        }
        if (color != null && color.length() > 0) {
            this.print(" #" + color);
        }
        this.println(" {");
        this.println("}");
        this.newline();
    }

    public void classDefinition(ModelClass modelClass, boolean displayPackageName, String filepath, String color, boolean showFields, boolean showConstructors, boolean showMethods, boolean publicMethodsOnly, boolean includeTypeInfo) {
        this.classDeclaration(modelClass, displayPackageName);
        if (filepath != null && filepath.length() > 0) {
            this.print(" [[");
            this.print(filepath);
            this.print("{" + modelClass.fullNameWithoutParameters() + "}");
            this.print("]]");
        }
        if (color != null && color.length() > 0) {
            this.print(" #" + color);
        }
        this.println(" {");
        if (showFields) {
            for (ModelClass.Field field : modelClass.fields()) {
                this.field(field, includeTypeInfo);
            }
        }
        if (showConstructors) {
            for (ModelClass.Constructor cons : modelClass.constructors()) {
                if (publicMethodsOnly && (!publicMethodsOnly || cons.visibility != ModelClass.Visibility.PUBLIC)) continue;
                this.constructor(cons, includeTypeInfo);
            }
        }
        if (showMethods) {
            for (ModelClass.Method method : modelClass.methods()) {
                if (publicMethodsOnly && (!publicMethodsOnly || method.visibility != ModelClass.Visibility.PUBLIC)) continue;
                this.method(method, includeTypeInfo);
            }
        }
        this.println("}");
        this.newline();
        if (!showFields) {
            this.hideFields(modelClass);
        }
        if (!showConstructors && !showMethods) {
            this.hideMethods(modelClass);
        }
        this.newline();
    }

    public void classDefinitionNoDetail(ModelClass modelClass, boolean displayPackageName, String filepath, String color) {
        this.classDefinition(modelClass, displayPackageName, filepath, color, false, false, false, false, false);
    }

    public void classDeclaration(ModelClass modelClass, boolean displayPackageName) {
        this.classType(modelClass);
        this.print(" \"");
        this.print("<b><size:14>");
        this.print(modelClass.shortName());
        this.print("</b>");
        if (displayPackageName) {
            this.print("\\n<size:10>");
            this.print(modelClass.packageName());
        }
        this.print("\" as ");
        this.className(modelClass);
        this.print(" ");
        this.annotations(modelClass);
    }

    public void annotations(ModelClass modelClass) {
        List<String> annotations = modelClass.annotations();
        if (annotations.size() > 0) {
            for (String annotation : modelClass.annotations()) {
                this.print("<<");
                this.print(annotation);
                this.print(">>");
            }
        }
    }

    public void className(ModelClass modelClass) {
        this.print(modelClass.fullNameWithoutParameters());
        for (String param : modelClass.parameters()) {
            param = param.replace("<", "").replace(">", "");
            this.print(param);
        }
    }

    public void classType(ModelClass modelClass) {
        switch (modelClass.type()) {
            case INTERFACE: {
                this.print("interface");
                break;
            }
            case ENUM: {
                this.print("enum");
                break;
            }
            default: {
                this.print("class");
            }
        }
    }

    public void field(ModelClass.Field field, boolean includeTypeInfo) {
        if (field.isStatic) {
            this.printStatic();
        }
        this.visibility(field.visibility);
        if (includeTypeInfo) {
            this.print(field.type + " ");
        }
        this.print(field.name);
        this.newline();
    }

    public void visibility(ModelClass.Visibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                this.print("+");
                break;
            }
            case PROTECTED: {
                this.print("#");
                break;
            }
            case PACKAGE_PRIVATE: {
                this.print("~");
                break;
            }
            default: {
                this.print("-");
            }
        }
    }

    public void constructor(ModelClass.Constructor constructor, boolean includeTypeInfo) {
        this.visibility(constructor.visibility);
        this.print(constructor.name);
        this.print("(");
        if (includeTypeInfo) {
            String sep = "";
            for (ModelClass.MethodParameter param : constructor.parameters) {
                this.print(sep);
                this.print(param.type);
                this.print(" ");
                this.print(param.name);
                sep = ",";
            }
        }
        this.print(")");
        this.newline();
    }

    public void method(ModelClass.Method method, boolean includeTypeInfo) {
        if (method.isStatic) {
            this.printStatic();
        }
        if (method.isAbstract) {
            this.printAbstract();
        }
        this.visibility(method.visibility);
        if (includeTypeInfo) {
            this.print(method.returnType);
            this.print(" ");
        }
        this.print(method.name);
        this.print("(");
        if (includeTypeInfo) {
            String sep = "";
            for (ModelClass.MethodParameter param : method.parameters) {
                this.print(sep);
                this.print(param.type);
                this.print(" ");
                this.print(param.name);
                sep = ",";
            }
        }
        this.print(")");
        this.newline();
    }

    public void hideFields(ModelClass modelClass) {
        this.print("hide ");
        this.className(modelClass);
        this.print(" fields");
        this.newline();
    }

    public void hideMethods(ModelClass modelClass) {
        this.print("hide ");
        this.className(modelClass);
        this.print(" methods");
        this.newline();
    }

    public void relationship(ModelRel rel) {
        if (this.isRelationshipVisible(rel)) {
            switch (rel.kind()) {
                case GENERALIZATION: {
                    this.generalization(rel.source(), rel.destination());
                    break;
                }
                case DEPENDENCY: {
                    this.dependency(rel.source(), rel.destination());
                    break;
                }
                case REALIZATION: {
                    this.realization(rel.source(), rel.destination());
                    break;
                }
                case DIRECTED_ASSOCIATION: {
                    this.association(rel.source(), rel.destination(), rel.destinationRole(), this.multiplicityLabel(rel.destinationCardinality()));
                }
            }
        }
    }

    public boolean isRelationshipVisible(ModelRel rel) {
        if (this._options.getDependenciesVisibility() == DiagramOptions.Visibility.PUBLIC) {
            return rel.isVisible(ModelRel.Visibility.PUBLIC);
        }
        if (this._options.getDependenciesVisibility() == DiagramOptions.Visibility.PROTECTED) {
            return rel.isVisible(ModelRel.Visibility.PROTECTED);
        }
        if (this._options.getDependenciesVisibility() == DiagramOptions.Visibility.PACKAGE) {
            return rel.isVisible(ModelRel.Visibility.PACKAGE);
        }
        if (this._options.getDependenciesVisibility() == DiagramOptions.Visibility.PRIVATE) {
            return rel.isVisible(ModelRel.Visibility.PRIVATE);
        }
        return false;
    }

    public void generalization(ModelClass src, ModelClass dest) {
        this.printRel(src, "--|>", dest);
    }

    public void realization(ModelClass src, ModelClass dest) {
        this.printRel(src, "..|>", dest);
    }

    public void dependency(ModelClass src, ModelClass dest) {
        this.printRel(src, "..>", dest);
    }

    public void packageDependency(ModelPackage src, ModelPackage dest) {
        this.print(src.fullName());
        this.print(" ..> ");
        this.print(dest.fullName());
        this.newline();
    }

    public void association(ModelClass src, ModelClass dest, String destRole, String destCardinality) {
        this.printRel(src, null, null, "-->", dest, destRole, destCardinality);
    }

    public String multiplicityLabel(ModelRel.Multiplicity mult) {
        if (mult != null) {
            switch (mult) {
                case ONE: {
                    return "1";
                }
                case ZERO_OR_ONE: {
                    return "0..1";
                }
                case MANY: {
                    return "*";
                }
            }
            return null;
        }
        return null;
    }

    private void printAbstract() {
        this.print("{abstract} ");
    }

    private void printStatic() {
        this.print("{static} ");
    }

    private void printRel(ModelClass src, String relText, ModelClass dest) {
        this.className(src);
        this.print(" " + relText + " ");
        this.className(dest);
        this.newline();
    }

    private void printRel(ModelClass src, String srcRole, String srcCardinality, String relText, ModelClass dest, String destRole, String destCardinality) {
        this.className(src);
        this.printRelLabel(srcRole, srcCardinality);
        this.print(" " + relText + " ");
        this.printRelLabel(destRole, destCardinality);
        this.className(dest);
        this.newline();
    }

    private void printRelLabel(String role, String cardinality) {
        if (role != null && role.length() > 0 || cardinality != null && cardinality.length() > 0) {
            this.print(" \"");
            if (role != null && role.length() > 0) {
                this.print(role);
            }
            if (cardinality != null && cardinality.length() > 0) {
                this.print(" " + cardinality);
            }
            this.print("\" ");
        }
    }

    private void printLineTypeOption() {
        if (this._options.getLineType() == DiagramOptions.LineType.ORTHO) {
            this.println("skinparam linetype ortho");
        } else if (this._options.getLineType() == DiagramOptions.LineType.POLYLINE) {
            this.println("skinparam linetype polyline");
        }
    }

    public String classFilepath(ModelClass modelClass, ModelClass classFile) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.relativePathToRoot(modelClass.packageName()));
        sb.append(this.pathToPackage(classFile.packageName()));
        sb.append(classFile.shortNameWithoutParameters());
        sb.append(".html");
        return sb.toString();
    }

    public String packageFilepath(ModelClass modelClass, ModelPackage packageFile) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.relativePathToRoot(modelClass.packageName()));
        sb.append(this.pathToPackage(packageFile.fullName()));
        sb.append("pacakge-summary.html");
        return sb.toString();
    }

    public String classFilepath(ModelPackage modelPackage, ModelClass classFile) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.relativePathToRoot(modelPackage.fullName()));
        sb.append(this.pathToPackage(classFile.packageName()));
        sb.append(classFile.shortNameWithoutParameters());
        sb.append(".html");
        return sb.toString();
    }

    public String packageFilepath(ModelPackage modelPackage, ModelPackage packageFile) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.relativePathToRoot(modelPackage.fullName()));
        sb.append(this.pathToPackage(packageFile.fullName()));
        sb.append("package-summary.html");
        return sb.toString();
    }

    public String classFilepath(ModelClass classFile) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pathToPackage(classFile.packageName()));
        sb.append(classFile.shortNameWithoutParameters());
        sb.append(".html");
        return sb.toString();
    }

    public String packageFilepath(ModelPackage packageFile) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pathToPackage(packageFile.fullName()));
        sb.append("package-summary.html");
        return sb.toString();
    }

    public String relativePathToRoot(String packageName) {
        StringBuilder sb = new StringBuilder();
        String[] parts = packageName.split("\\.");
        if (parts.length > 0) {
            for (int i = 0; i < parts.length; ++i) {
                sb.append("../");
            }
        }
        return sb.toString();
    }

    public String pathToPackage(String packageName) {
        StringBuilder sb = new StringBuilder();
        String[] parts = packageName.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
            sb.append("/");
        }
        return sb.toString();
    }
}

