/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.printer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public abstract class Printer {
    private final StringBuilder _sb = new StringBuilder();

    public boolean toFile(String filename) {
        return this.dumpToFile(filename, this._sb.toString());
    }

    public boolean toFile(File file) {
        return this.dumpToFile(file, this._sb.toString());
    }

    public String toString() {
        return this._sb.toString();
    }

    public StringBuilder stringBuilder() {
        return this._sb;
    }

    public void print(String str) {
        this._sb.append(str);
    }

    public void print(int level, String str) {
        this.indent(level);
        this._sb.append(str);
    }

    public void println(String str) {
        this._sb.append(str);
        this._sb.append("\n");
    }

    public void println(int level, String str) {
        this.indent(level);
        this._sb.append(str);
        this._sb.append("\n");
    }

    public void indent() {
        this.indent(1);
    }

    public void indent(int level) {
        for (int i = 0; i < level; ++i) {
            this.print("  ");
        }
    }

    public void newline() {
        this._sb.append("\n");
    }

    private boolean dumpToFile(String filename, String str) {
        return this.dumpToFile(new File(filename), str);
    }

    private boolean dumpToFile(File file, String str) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            os.write(str.getBytes());
            os.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

