/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.printer;

import info.leadinglight.umljavadoclet.model.ModelClass;
import info.leadinglight.umljavadoclet.printer.DiagramOption;
import java.util.ArrayList;
import java.util.List;

public class DiagramOptions {
    private static final String LINETYPE = "linetype";
    private static final String DEPENDENCIES = "dependencies";
    private static final String PACKAGE_ORIENTATION = "package-orientation";
    private static final String OUTPUT_MODEL = "output-model";
    private static final String PUML_INCLUDE_FILE = "puml-include-file";
    private static final String EXCLUDE_CLASSES = "exclude-classes";
    private static final String EXCLUDE_PACKAGES = "exclude-packages";
    private List<DiagramOption> options = new ArrayList<DiagramOption>();

    public DiagramOptions() {
        this.addOption(LINETYPE, "polyline,spline,ortho", "ortho", 2);
        this.addOption(DEPENDENCIES, "public,protected,package,private", "public", 2);
        this.addOption(PACKAGE_ORIENTATION, "left-to-right,top-to-bottom", "top-to-bottom", 2);
        this.addOption(OUTPUT_MODEL, "true,false", "false", 2);
        this.addOption(PUML_INCLUDE_FILE, 2);
        this.addOption(EXCLUDE_CLASSES, 2);
        this.addOption(EXCLUDE_PACKAGES, 2);
    }

    public LineType getLineType() {
        return LineType.valueOf(this.getOptionEnumValue(LINETYPE));
    }

    public Visibility getDependenciesVisibility() {
        return Visibility.valueOf(this.getOptionEnumValue(DEPENDENCIES));
    }

    public Orientation getPackageOrientation() {
        return Orientation.valueOf(this.getOptionEnumValue(PACKAGE_ORIENTATION));
    }

    public boolean isOutputModel() {
        return this.getOptionValue(OUTPUT_MODEL).equals("true");
    }

    public String getPumlIncludeFile() {
        return this.getOptionValue(PUML_INCLUDE_FILE);
    }

    public boolean hasPumlIncludeFile() {
        return this.getPumlIncludeFile() != null && this.getPumlIncludeFile().length() > 0;
    }

    public List<String> getExcludedClasses() {
        return this.getOptionCsvValue(EXCLUDE_CLASSES);
    }

    public boolean isExcludedClass(ModelClass modelClass) {
        return this.getExcludedClasses().contains(modelClass.fullNameWithoutParameters());
    }

    public List<String> getExcludedPackages() {
        return this.getOptionCsvValue(EXCLUDE_PACKAGES);
    }

    public boolean isExcludedPackage(ModelClass modelClass) {
        return this.getExcludedPackages().contains(modelClass.packageName());
    }

    public void set(String[][] docletOptions) {
        for (String[] docletOption : docletOptions) {
            String docletName = docletOption[0];
            DiagramOption option = this.getOptionForDocletName(docletName);
            if (option == null) continue;
            String docletValue = docletOption[1];
            option.setValue(docletValue);
        }
    }

    public boolean isValidOption(String docletName) {
        return this.getOptionForDocletName(docletName) != null;
    }

    public int getOptionLength(String docletName) {
        DiagramOption option = this.getOptionForDocletName(docletName);
        return option != null ? option.getLength() : 0;
    }

    public String checkOption(String[] setting) {
        String docletName = setting[0];
        DiagramOption option = this.getOptionForDocletName(docletName);
        if (option == null) {
            return "Invalid option " + docletName;
        }
        String value = setting[1];
        if (!option.isValidValue(value)) {
            return "Invalid value " + value + " for option " + docletName + "; valid values are " + option.getValidValues();
        }
        return null;
    }

    public String getOptionValuesAsString() {
        String result = "";
        for (DiagramOption option : this.options) {
            result = result + option.getName() + "=" + option.getValue() + " ";
        }
        return result;
    }

    private void addOption(String name, int length) {
        DiagramOption option = new DiagramOption(name, length);
        this.options.add(option);
    }

    private void addOption(String name, String validValues, String defaultValue, int length) {
        DiagramOption option = new DiagramOption(name, validValues, defaultValue, length);
        this.options.add(option);
    }

    private DiagramOption getOption(String name) {
        for (DiagramOption option : this.options) {
            if (!option.getName().equals(name)) continue;
            return option;
        }
        return null;
    }

    private DiagramOption getOptionForDocletName(String nameWithHyphen) {
        String name = nameWithHyphen.substring(1);
        return this.getOption(name);
    }

    private String getOptionValue(String name) {
        DiagramOption option = this.getOption(name);
        return option != null ? option.getValue() : null;
    }

    private List<String> getOptionCsvValue(String name) {
        DiagramOption option = this.getOption(name);
        return option != null ? option.getCsvValues() : new ArrayList<String>();
    }

    private String getOptionEnumValue(String name) {
        String value = this.getOptionValue(name);
        return value != null ? value.toUpperCase().replace("-", "_") : null;
    }

    public String toString() {
        return "DiagramOptions{options=" + this.options + '}';
    }

    public static enum Orientation {
        LEFT_TO_RIGHT,
        TOP_TO_BOTTOM;

    }

    public static enum Visibility {
        PUBLIC,
        PROTECTED,
        PACKAGE,
        PRIVATE;

    }

    public static enum LineType {
        SPLINE,
        POLYLINE,
        ORTHO;

    }
}

