/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.printer;

import java.util.ArrayList;
import java.util.List;

public class DiagramOption {
    private String name;
    private List<String> validValues;
    private String defaultValue;
    private int length;
    private String value;

    public DiagramOption(String name, int length) {
        this.name = name;
        this.length = length;
        this.validValues = null;
        this.defaultValue = null;
    }

    public DiagramOption(String name, String validValues, String defaultValue, int length) {
        String[] parts;
        this.name = name;
        this.validValues = new ArrayList<String>();
        for (String part : parts = validValues.split(",")) {
            this.validValues.add(part.trim());
        }
        this.defaultValue = defaultValue;
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getValidValues() {
        return this.validValues;
    }

    public boolean isValidValue(String value) {
        return this.validValues != null ? this.validValues.contains(value) : true;
    }

    public void setValidValues(List<String> validValues) {
        this.validValues = validValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getValue() {
        return this.value != null ? this.value : this.defaultValue;
    }

    public List<String> getCsvValues() {
        ArrayList<String> values = new ArrayList<String>();
        String value = this.getValue();
        if (value != null && value.length() > 0) {
            String[] parts;
            for (String part : parts = value.split(",")) {
                values.add(part);
            }
        }
        return values;
    }

    public void setValue(String value) {
        if (this.validValues != null) {
            for (String validValue : this.validValues) {
                if (!validValue.equalsIgnoreCase(value)) continue;
                this.value = validValue;
                return;
            }
        } else {
            this.value = value;
        }
    }

    public String toString() {
        return "DiagramOption{name='" + this.name + '\'' + ", validValues=" + this.validValues + ", defaultValue='" + this.defaultValue + '\'' + ", length=" + this.length + ", value='" + this.value + '\'' + '}';
    }
}

