/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Scanner;
import parser.Variable;
import util.Utils;

public class VariableBackup {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMapItemsToFileLineByLine(Map<String, Variable> map, File file) {
        if (map == null || map.isEmpty()) {
            return;
        }
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            String newLine = System.getProperty("line.separator");
            fw = new FileWriter(file.getAbsoluteFile());
            bw = new BufferedWriter(fw);
            for (Map.Entry<String, Variable> entry : map.entrySet()) {
                String s = entry.getValue().serialize();
                if (s == null || s.equals("null")) continue;
                bw.write(s + newLine);
            }
            bw.flush();
        }
        catch (Exception exception) {
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception exception) {}
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(Map<String, Variable> map, File file) {
        if (map == null) {
            System.out.println("Vars read failed!");
            return;
        }
        Scanner s = null;
        try {
            s = new Scanner(file);
            while (s.hasNextLine()) {
                String text = s.nextLine();
                if (text == null || text.equals("null")) continue;
                Variable v = Variable.parse(text);
                map.put(v.getName(), v);
            }
            System.out.println("Vars read ended!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFileLinesToMap(Map<String, Variable> map, File fileToRead) {
        BufferedReader in;
        if (map == null) {
            return;
        }
        try {
            FileReader stream = new FileReader(fileToRead);
            in = new BufferedReader(stream);
        }
        catch (Exception e) {
            Utils.logError("Sorry, but an error occurred \nwhile trying to open the file:/n" + e);
            return;
        }
        try {
            String lineFromFile;
            while ((lineFromFile = in.readLine()) != null) {
                if (lineFromFile == null || lineFromFile.equals("null")) continue;
                Variable v = Variable.parse(lineFromFile);
                map.put(v.getName(), v);
            }
        }
        catch (Exception e) {
            Utils.logError("Sorry, but an error occurred \nwhile trying to read the data:/n" + e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

