/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextFileWriter
implements Serializable {
    private ObjectOutputStream output;
    private String filePath;

    public TextFileWriter(String filePath) {
        this.filePath = filePath;
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.openFile();
    }

    private void openFile() {
        try {
            this.output = new ObjectOutputStream(new FileOutputStream(this.filePath));
        }
        catch (IOException ioException) {
            System.err.println("Error opening file.");
        }
    }

    public void write(Object obj) {
        try {
            this.output.writeObject(obj);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
    }

    public static void writeText(File file, String text) {
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(file), true);
            writer.write(text);
            writer.flush();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TextFileWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void close() {
        try {
            if (this.output != null) {
                this.output.close();
            }
        }
        catch (IOException ioException) {
            System.err.println("Error closing file.");
            System.exit(1);
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.openFile();
    }

    public static void main(String[] args) {
        TextFileWriter.writeText(new File("Gbemiro's Friends.txt"), "But the word is nigh thee, even the word of faith, which we preachthat if thou wouldest confess with thy mouth Adonai Yeshua and thou wouldest believein thy heart that God hath raised Him from the dead,thou wilt be saved.For with the heart man believes unto righteousness and with the mouth confession is made unto salvation.");
    }
}

