/*
 * Decompiled with CFR 0.152.
 */
package parser.methods.ext;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import parser.TYPE;
import parser.methods.BasicNumericalMethod;
import parser.methods.Help;
import parser.methods.ext.Utils;

public class AvgN
implements BasicNumericalMethod {
    public static final int DEFAULT_AVGN_MISIZE = 2;

    @Override
    public String solve(List<String> tokens) {
        int toRemove = Utils.getFirstTokenAsInt(tokens);
        List<BigDecimal> l = Utils.stringsToBigDecimals(tokens, 1);
        Collections.sort(l);
        Utils.trimList(l, toRemove, 2);
        BigDecimal summ = Utils.sum(l);
        return summ.divide(new BigDecimal(l.size()), new MathContext(10, RoundingMode.HALF_DOWN)).toString();
    }

    @Override
    public String getHelp() {
        return Help.toLine(this.getName(), " this is counting limited avg value. First argument is not part of the sum, but is pointing, how much tokens have to be remove from sorted arguments list from both ends, before avg is calculated from the rest. avgN(1,2,4,2) is actually not 9/4 but 2, as first 2 and last 4 from  2,2,4 (as 1 is argument) were removed. Always at least two items are left list");
    }

    @Override
    public String getName() {
        return "avgN";
    }

    @Override
    public String getType() {
        return TYPE.NUMBER.toString();
    }
}

