/*
 * Decompiled with CFR 0.152.
 */
package parser.methods;

import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.List;
import math.Maths;
import math.matrix.expressParser.Matrix;
import parser.CustomScanner;
import parser.Function;
import parser.Number;
import parser.Operator;
import parser.STRING;
import parser.Set;
import parser.methods.BasicNumericalMethod;
import parser.methods.Declarations;
import util.FunctionManager;

public class Method {
    private String name;
    private String[] parameters;
    private int DRG = 1;

    public Method(String name, String ... parameters) {
        this.name = Method.isMethodName(name) ? name : "";
        this.parameters = parameters;
        if (this.name.isEmpty()) {
            throw new InputMismatchException("Invalid Method Name!");
        }
    }

    public static boolean isFunctionOperatingMethod(String methodName) {
        return methodName.equals("diff") || methodName.equals("intg") || methodName.equals("quad") || methodName.equals("root") || methodName.equals("t_root") || methodName.equals("plot") || methodName.equals("matrix_mul") || methodName.equals("matrix_div") || methodName.equals("matrix_add") || methodName.equals("matrix_sub") || methodName.equals("matrix_pow") || methodName.equals("matrix_edit") || methodName.equals("transpose") || methodName.equals("det") || methodName.equals("adjoint") || methodName.equals("cofactor") || methodName.equals("eigpoly") || methodName.equals("eigvec") || methodName.equals("print");
    }

    public Method(String expression) {
        this.parseExpression(expression);
    }

    public static String[] getAllFunctions() {
        int sz = FunctionManager.FUNCTIONS.size();
        String[] userDefined = new String[sz + Declarations.getInbuiltMethods().length];
        String[] keyset = FunctionManager.FUNCTIONS.keySet().toArray(new String[0]);
        System.arraycopy(keyset, 0, userDefined, 0, keyset.length);
        System.arraycopy(Declarations.getInbuiltMethods(), 0, userDefined, keyset.length, Declarations.getInbuiltMethods().length);
        return userDefined;
    }

    public final void parseExpression(String expression) {
        CustomScanner cs = new CustomScanner(expression, false, "(", ")", ",");
        List<String> l = cs.scan();
        int sz = l.size();
        if (!Method.isMethodName(l.get(0))) {
            throw new InputMismatchException("Invalid Method Name!");
        }
        String[] params = new String[sz - 1];
        params = l.subList(1, sz).toArray(params);
        this.setParameters(params);
        this.setName(l.get(0));
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setParameters(String[] parameters) {
        this.parameters = parameters;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setDRG(int DRG) {
        this.DRG = DRG;
    }

    public int getDRG() {
        return this.DRG;
    }

    public static boolean isListReturningStatsMethod(String op) {
        return op.equals("sort") || op.equals("mode") || op.equals("rnd") || op.equals("quad") || op.equals("t_root") || op.equals("invert") || op.equals("linear_sys") || op.equals("tri_mat") || op.equals("echelon") || op.equals("matrix_mul") || op.equals("matrix_div") || op.equals("matrix_add") || op.equals("matrix_sub") || op.equals("matrix_pow") || op.equals("transpose") || op.equals("matrix_edit");
    }

    public static boolean isNumberReturningStatsMethod(String op) {
        return Method.isStatsMethod(op) && !Method.isListReturningStatsMethod(op);
    }

    public static boolean isRandom(String op) {
        return op.equals("rnd");
    }

    public static boolean isLogToAnyBase(String op) {
        return op.equals("log");
    }

    public static boolean isAntiLogToAnyBase(String op) {
        return op.equals("log-\u00b9") || op.equals("alog");
    }

    public static boolean isNaturalLog(String op) {
        return op.equals("ln");
    }

    public static boolean isInverseNaturalLog(String op) {
        return op.equals("ln-\u00b9") || op.equals("aln");
    }

    public static boolean isExpMethod(String op) {
        return op.equals("exp");
    }

    public static boolean isLogOrAntiLogToAnyBase(String op) {
        return Method.isLogToAnyBase(op) || Method.isAntiLogToAnyBase(op);
    }

    public boolean isDeterminant(String op) {
        return op.equals("det");
    }

    public boolean isMatrixInvert(String op) {
        return op.equals("invert");
    }

    public boolean isLinearSys(String op) {
        return op.equals("linear_sys");
    }

    public boolean isTriMat(String op) {
        return op.equals("tri_mat");
    }

    public boolean isEchelon(String op) {
        return op.equals("echelon");
    }

    public boolean isMatrixCofactors(String op) {
        return op.equals("cofactor");
    }

    public boolean isMatrixAdjoint(String op) {
        return op.equals("adjoint");
    }

    public boolean isMatrixEigenVec(String op) {
        return op.equals("eigvec");
    }

    public boolean isMatrixEigenPoly(String op) {
        return op.equals("eigpoly");
    }

    public boolean isPrint(String op) {
        return op.equals("print");
    }

    public static boolean isStatsMethod(String op) {
        return Method.isUserDefinedFunction(op) || Method.isLogOrAntiLogToAnyBase(op) || Declarations.isBasicNumericalFunction(op) || Method.isMatrixMethod(op) || Method.isHardcodedStatsMethod(op) || op.equals("pow") || op.equals("diff") || op.equals("intg") || op.equals("root") || op.equals("quad") || op.equals("t_root") || op.equals("perm") || op.equals("comb") || op.equals("log") || op.equals("log-\u00b9") || op.equals("alog") || op.equals("print");
    }

    public static boolean isMatrixMethod(String op) {
        return op.equals("linear_sys") || op.equals("det") || op.equals("invert") || op.equals("tri_mat") || op.equals("echelon") || op.equals("matrix_mul") || op.equals("matrix_div") || op.equals("matrix_add") || op.equals("matrix_sub") || op.equals("matrix_pow") || op.equals("matrix_edit") || op.equals("transpose") || op.equals("cofactor") || op.equals("adjoint") || op.equals("eigpoly") || op.equals("eigvec");
    }

    public static boolean isMatrixMul(String op) {
        return op.equals("matrix_mul");
    }

    public static boolean isMatrixDiv(String op) {
        return op.equals("matrix_div");
    }

    public static boolean isMatrixAdd(String op) {
        return op.equals("matrix_add");
    }

    public static boolean isMatrixSub(String op) {
        return op.equals("matrix_sub");
    }

    public static boolean isMatrixPow(String op) {
        return op.equals("matrix_pow");
    }

    public static boolean isTranspose(String op) {
        return op.equals("transpose");
    }

    public static boolean isMatrixEdit(String op) {
        return op.equals("matrix_edit");
    }

    public static boolean isUserDefinedFunction(String op) {
        return FunctionManager.lookUp(op) != null;
    }

    public static List<String> run(List<String> list, int DRG) {
        String name = list.get(0);
        String result = "";
        list.subList(0, 2).clear();
        list.remove(list.size() - 1);
        int sz = list.size();
        if (Method.isStatsMethod(name)) {
            Set set;
            for (BasicNumericalMethod basicNumericalMethod : Declarations.getBasicNumericalMethods()) {
                if (!name.equals(basicNumericalMethod.getName())) continue;
                Set set2 = new Set(list);
                result = basicNumericalMethod.solve(new ArrayList<String>(set2.getData()));
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("sum")) {
                set = new Set(list);
                result = String.valueOf(set.sum());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("prod")) {
                set = new Set(list);
                result = String.valueOf(set.prod());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("count")) {
                set = new Set(list);
                result = String.valueOf(set.size());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("gsum")) {
                set = new Set(list);
                result = set.gsum().toString();
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("geom")) {
                set = new Set(list);
                result = set.geom().toString();
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("avg")) {
                set = new Set(list);
                result = String.valueOf(set.avg());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("med")) {
                set = new Set(list);
                result = String.valueOf(set.median());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("rng")) {
                set = new Set(list);
                result = String.valueOf(set.rng());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("mrng")) {
                set = new Set(list);
                result = String.valueOf(set.mrng());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("max")) {
                set = new Set(list);
                result = String.valueOf(set.max());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("min")) {
                set = new Set(list);
                result = String.valueOf(set.min());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("rms")) {
                set = new Set(list);
                result = String.valueOf(set.rms());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("cov")) {
                set = new Set(list);
                result = String.valueOf(set.cov());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("s_d")) {
                set = new Set(list);
                result = String.valueOf(set.std_dev());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("variance")) {
                set = new Set(list);
                result = String.valueOf(set.var());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("st_err")) {
                set = new Set(list);
                result = String.valueOf(set.std_err());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("diff")) {
                set = new Set(list);
                result = String.valueOf(set.differentiate());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("intg")) {
                set = new Set(list);
                result = String.valueOf(set.integrate());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("root")) {
                set = new Set(list);
                result = String.valueOf(set.rootOfEquation());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals("det")) {
                set = new Set(list);
                result = String.valueOf(set.determinant());
                list.clear();
                list.add(result);
                return list;
            }
            if (Method.isUserDefinedFunction(name)) {
                try {
                    set = new Set(list);
                    result = String.valueOf(set.evaluateUserDefinedFunction(name));
                    list.clear();
                    list.add(result);
                    return list;
                }
                catch (ClassNotFoundException set3) {}
            } else {
                if (name.equals("log")) {
                    if (sz == 1) {
                        result = String.valueOf(Maths.logToAnyBase(Double.valueOf(list.get(0)), 10.0));
                        list.clear();
                        list.add(result);
                    } else if (sz == 2) {
                        result = String.valueOf(Maths.logToAnyBase(Double.valueOf(list.get(0)), Double.valueOf(list.get(1))));
                        list.clear();
                        list.add(result);
                    }
                    return list;
                }
                if (name.equals("log-\u00b9") || name.equals("alog")) {
                    if (sz == 1) {
                        result = String.valueOf(Maths.antiLogToAnyBase(Double.valueOf(list.get(0)), 10.0));
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (sz == 2) {
                        result = String.valueOf(Maths.antiLogToAnyBase(Double.valueOf(list.get(0)), Double.valueOf(list.get(1))));
                        list.clear();
                        list.add(result);
                        return list;
                    }
                } else {
                    Matrix matrix;
                    if (name.equals("quad")) {
                        set = new Set(list);
                        result = set.quadraticRoots();
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals("t_root")) {
                        set = new Set(list);
                        result = set.tartaglianRoots();
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals("pow") && sz == 2) {
                        set = new Set(list);
                        result = String.valueOf(set.power());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals("perm") && sz == 2) {
                        set = new Set(list);
                        result = String.valueOf(set.permutation());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals("comb") && sz == 2) {
                        set = new Set(list);
                        result = String.valueOf(set.combination());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals("mode")) {
                        set = new Set(list);
                        result = String.valueOf(set.mode());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals("rnd") && sz >= 0 && sz <= 2) {
                        set = new Set(list);
                        result = String.valueOf(set.random());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals("sort")) {
                        set = new Set(list);
                        result = String.valueOf(set.sort());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals("invert")) {
                        set = new Set(list);
                        matrix = set.invert();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("linear_sys")) {
                        set = new Set(list);
                        matrix = set.solveSystem();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("tri_mat")) {
                        set = new Set(list);
                        matrix = set.triMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("echelon")) {
                        set = new Set(list);
                        matrix = set.echelon();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("matrix_mul")) {
                        set = new Set(list);
                        matrix = set.multiplyMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("matrix_div")) {
                        set = new Set(list);
                        matrix = set.divideMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("matrix_add")) {
                        set = new Set(list);
                        matrix = set.addMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("matrix_sub")) {
                        set = new Set(list);
                        matrix = set.subtractMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("matrix_pow")) {
                        set = new Set(list);
                        matrix = set.powerMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("transpose")) {
                        set = new Set(list);
                        matrix = set.transpose();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("matrix_edit")) {
                        set = new Set(list);
                        matrix = set.editMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("adjoint")) {
                        set = new Set(list);
                        matrix = set.adjoint();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("cofactor")) {
                        set = new Set(list);
                        matrix = set.cofactorMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("eigpoly")) {
                        set = new Set(list);
                        String poly = set.eigenPoly();
                        list.clear();
                        String ref = "anon" + (FunctionManager.countAnonymousFunctions() + 1);
                        Function.storeAnonymousFunction("@(n)" + poly);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("eigvec")) {
                        set = new Set(list);
                        matrix = set.eigenVectors();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals("print")) {
                        set = new Set(list);
                        set.print();
                        list.clear();
                        list.add("0");
                        return list;
                    }
                }
            }
        } else if (sz == 1) {
            try {
                if (!list.get(0).equals("Infinity") && Number.isNumber(list.get(0))) {
                    if (DRG == 0) {
                        if (name.equals("sin")) {
                            result = String.valueOf(Maths.sinDegToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals("sinh")) {
                            result = String.valueOf(Math.sinh(Double.valueOf(list.get(0))));
                        } else if (name.equals("cos")) {
                            result = String.valueOf(Maths.cosDegToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals("cosh")) {
                            result = String.valueOf(Math.cosh(Double.valueOf(list.get(0))));
                        } else if (name.equals("tan")) {
                            result = String.valueOf(Maths.tanDegToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals("tanh")) {
                            result = String.valueOf(Math.tanh(Double.valueOf(list.get(0))));
                        } else if (name.equals("sec")) {
                            result = String.valueOf(1.0 / Maths.cosDegToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals("sech")) {
                            result = String.valueOf(1.0 / Math.cosh(Double.valueOf(list.get(0))));
                        } else if (name.equals("csc")) {
                            result = String.valueOf(1.0 / Maths.sinDegToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals("csch")) {
                            result = String.valueOf(1.0 / Math.sinh(Double.valueOf(list.get(0))));
                        } else if (name.equals("cot")) {
                            result = String.valueOf(1.0 / Maths.tanDegToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals("coth")) {
                            result = String.valueOf(Math.tanh(Double.valueOf(list.get(0))));
                        } else if (name.equals("exp") || name.equals("aln") || name.equals("ln-\u00b9")) {
                            result = String.valueOf(Math.exp(Double.valueOf(list.get(0))));
                        } else if (name.equals("ln")) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0))));
                        } else if (name.equals("lg")) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0))) / Math.log(10.0));
                        } else if (name.equals("sin-\u00b9") || name.equals("asin")) {
                            result = String.valueOf(Maths.asinRadToDeg(Double.valueOf(list.get(0))));
                        } else if (name.equals("cos-\u00b9") || name.equals("acos")) {
                            result = String.valueOf(Maths.acosRadToDeg(Double.valueOf(list.get(0))));
                        } else if (name.equals("tan-\u00b9") || name.equals("atan")) {
                            result = String.valueOf(Maths.atanRadToDeg(Double.valueOf(list.get(0))));
                        } else if (name.equals("sinh-\u00b9") || name.equals("asinh")) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0)) + Math.sqrt(Math.pow(Double.valueOf(list.get(0)), 2.0) + 1.0)));
                        } else if (name.equals("cosh-\u00b9") || name.equals("acosh")) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0)) + Math.sqrt(Math.pow(Double.valueOf(list.get(0)), 2.0) - 1.0)));
                        } else if (name.equals("tanh-\u00b9") || name.equals("atanh")) {
                            result = String.valueOf(0.5 * Math.log((1.0 + Double.valueOf(list.get(0))) / (1.0 - Double.valueOf(list.get(0)))));
                        } else if (name.equals("sec-\u00b9") || name.equals("asec")) {
                            result = String.valueOf(Maths.acosRadToDeg(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals("csc-\u00b9") || name.equals("acsc")) {
                            result = String.valueOf(Maths.asinRadToDeg(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals("cot-\u00b9") || name.equals("acot")) {
                            result = String.valueOf(Maths.atanRadToDeg(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals("sech-\u00b9") || name.equals("asech")) {
                            result = String.valueOf(Math.log((1.0 + Math.sqrt(1.0 - Math.pow(Double.valueOf(list.get(0)), 2.0))) / Double.valueOf(list.get(0))));
                        } else if (name.equals("csch-\u00b9") || name.equals("acsch")) {
                            result = String.valueOf(Math.log((1.0 + Math.sqrt(1.0 + Math.pow(Double.valueOf(list.get(0)), 2.0))) / Double.valueOf(list.get(0))));
                        } else if (name.equals("coth-\u00b9") || name.equals("acoth")) {
                            result = String.valueOf(0.5 * Math.log((Double.valueOf(list.get(0)) + 1.0) / (Double.valueOf(list.get(0)) - 1.0)));
                        } else if (name.equals("lg-\u00b9") || name.equals("alg")) {
                            result = String.valueOf(Math.pow(10.0, Double.valueOf(list.get(0))));
                        } else if (name.equals("ceil")) {
                            result = String.valueOf(Math.ceil(Double.valueOf(list.get(0))));
                        } else if (name.equals("floor")) {
                            result = String.valueOf(Math.floor(Double.valueOf(list.get(0))));
                        } else if (name.equals("sqrt")) {
                            result = String.valueOf(Math.sqrt(Double.valueOf(list.get(0))));
                        } else if (name.equals("cbrt")) {
                            result = String.valueOf(Math.cbrt(Double.valueOf(list.get(0))));
                        } else if (name.equals("square")) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(val * val);
                        } else if (name.equals("cube")) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(val * val * val);
                        } else if (name.equals("inverse")) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(1.0 / val);
                        } else if (name.equals("fact")) {
                            result = Maths.fact(list.get(0));
                        }
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (DRG == 1) {
                        if (name.equals("sin")) {
                            result = String.valueOf(Math.sin(Double.valueOf(list.get(0))));
                        } else if (name.equals("sinh")) {
                            result = String.valueOf(Math.sinh(Double.valueOf(list.get(0))));
                        } else if (name.equals("cos")) {
                            result = String.valueOf(Math.cos(Double.valueOf(list.get(0))));
                        } else if (name.equals("cosh")) {
                            result = String.valueOf(Math.cosh(Double.valueOf(list.get(0))));
                        } else if (name.equals("tan")) {
                            result = String.valueOf(Math.tan(Double.valueOf(list.get(0))));
                        } else if (name.equals("tanh")) {
                            result = String.valueOf(Math.tanh(Double.valueOf(list.get(0))));
                        } else if (name.equals("sec")) {
                            result = String.valueOf(1.0 / Math.cos(Double.valueOf(list.get(0))));
                        } else if (name.equals("sech")) {
                            result = String.valueOf(1.0 / Math.cosh(Double.valueOf(list.get(0))));
                        } else if (name.equals("csc")) {
                            result = String.valueOf(1.0 / Math.sin(Double.valueOf(list.get(0))));
                        } else if (name.equals("csch")) {
                            result = String.valueOf(1.0 / Math.sinh(Double.valueOf(list.get(0))));
                        } else if (name.equals("cot")) {
                            result = String.valueOf(1.0 / Math.tan(Double.valueOf(list.get(0))));
                        } else if (name.equals("coth")) {
                            result = String.valueOf(Math.tanh(Double.valueOf(list.get(0))));
                        } else if (name.equals("exp") || name.equals("aln") || name.equals("ln-\u00b9")) {
                            result = String.valueOf(Math.exp(Double.valueOf(list.get(0))));
                        } else if (name.equals("ln")) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0))));
                        } else if (name.equals("lg")) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0))) / Math.log(10.0));
                        } else if (name.equals("sin-\u00b9") || name.equals("asin")) {
                            result = String.valueOf(Math.asin(Double.valueOf(list.get(0))));
                        } else if (name.equals("cos-\u00b9") || name.equals("acos")) {
                            result = String.valueOf(Math.acos(Double.valueOf(list.get(0))));
                        } else if (name.equals("tan-\u00b9") || name.equals("atan")) {
                            result = String.valueOf(Math.atan(Double.valueOf(list.get(0))));
                        } else if (name.equals("sinh-\u00b9") || name.equals("asinh")) {
                            result = String.valueOf(Maths.asinh(Double.parseDouble(list.get(0))));
                        } else if (name.equals("cosh-\u00b9") || name.equals("acosh")) {
                            result = String.valueOf(Maths.acosh(Double.parseDouble(list.get(0))));
                        } else if (name.equals("tanh-\u00b9") || name.equals("atanh")) {
                            result = String.valueOf(Maths.atanh(Double.parseDouble(list.get(0))));
                        } else if (name.equals("sec-\u00b9") || name.equals("asec")) {
                            result = String.valueOf(Math.acos(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals("csc-\u00b9") || name.equals("acsc")) {
                            result = String.valueOf(Math.asin(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals("cot-\u00b9") || name.equals("acot")) {
                            result = String.valueOf(Math.atan(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals("sech-\u00b9") || name.equals("asech")) {
                            result = String.valueOf(Maths.asech(Double.parseDouble(list.get(0))));
                        } else if (name.equals("csch-\u00b9") || name.equals("acsch")) {
                            result = String.valueOf(Maths.acsch(Double.parseDouble(list.get(0))));
                        } else if (name.equals("coth-\u00b9") || name.equals("acoth")) {
                            result = String.valueOf(Maths.acoth(Double.parseDouble(list.get(0))));
                        } else if (name.equals("lg-\u00b9") || name.equals("alg")) {
                            result = String.valueOf(Math.pow(10.0, Double.valueOf(list.get(0))));
                        } else if (name.equals("ceil")) {
                            result = String.valueOf(Math.ceil(Double.valueOf(list.get(0))));
                        } else if (name.equals("floor")) {
                            result = String.valueOf(Math.floor(Double.valueOf(list.get(0))));
                        } else if (name.equals("sqrt")) {
                            result = String.valueOf(Math.sqrt(Double.valueOf(list.get(0))));
                        } else if (name.equals("cbrt")) {
                            result = String.valueOf(Math.cbrt(Double.valueOf(list.get(0))));
                        } else if (name.equals("square")) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(val * val);
                        } else if (name.equals("cube")) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(val * val * val);
                        } else if (name.equals("inverse")) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(1.0 / val);
                        } else if (name.equals("fact")) {
                            result = Maths.fact(list.get(0));
                        }
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (DRG == 2) {
                        if (name.equals("sin")) {
                            result = String.valueOf(Maths.sinGradToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals("sinh")) {
                            result = String.valueOf(Math.sinh(Double.valueOf(list.get(0))));
                        } else if (name.equals("cos")) {
                            result = String.valueOf(Maths.cosGradToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals("cosh")) {
                            result = String.valueOf(Math.cosh(Double.valueOf(list.get(0))));
                        } else if (name.equals("tan")) {
                            result = String.valueOf(Maths.tanGradToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals("tanh")) {
                            result = String.valueOf(Math.tanh(Double.valueOf(list.get(0))));
                        } else if (name.equals("sec")) {
                            result = String.valueOf(1.0 / Maths.cosGradToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals("sech")) {
                            result = String.valueOf(1.0 / Math.cosh(Double.valueOf(list.get(0))));
                        } else if (name.equals("csc")) {
                            result = String.valueOf(1.0 / Maths.sinGradToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals("csch")) {
                            result = String.valueOf(1.0 / Math.sinh(Double.valueOf(list.get(0))));
                        } else if (name.equals("cot")) {
                            result = String.valueOf(1.0 / Maths.tanGradToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals("coth")) {
                            result = String.valueOf(Math.tanh(Double.valueOf(list.get(0))));
                        } else if (name.equals("exp") || name.equals("aln") || name.equals("ln-\u00b9")) {
                            result = String.valueOf(Math.exp(Double.valueOf(list.get(0))));
                        } else if (name.equals("ln")) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0))));
                        } else if (name.equals("lg")) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0))) / Math.log(10.0));
                        } else if (name.equals("sin-\u00b9") || name.equals("asin")) {
                            result = String.valueOf(Maths.asinRadToGrad(Double.valueOf(list.get(0))));
                        } else if (name.equals("cos-\u00b9") || name.equals("acos")) {
                            result = String.valueOf(Maths.acosRadToGrad(Double.valueOf(list.get(0))));
                        } else if (name.equals("tan-\u00b9") || name.equals("atan")) {
                            result = String.valueOf(Maths.atanRadToGrad(Double.valueOf(list.get(0))));
                        } else if (name.equals("sinh-\u00b9") || name.equals("asinh")) {
                            result = String.valueOf(Maths.asinh(Double.parseDouble(list.get(0))));
                        } else if (name.equals("cosh-\u00b9") || name.equals("acosh")) {
                            result = String.valueOf(Maths.acosh(Double.parseDouble(list.get(0))));
                        } else if (name.equals("tanh-\u00b9") || name.equals("atanh")) {
                            result = String.valueOf(Maths.atanh(Double.parseDouble(list.get(0))));
                        } else if (name.equals("sec-\u00b9") || name.equals("asec")) {
                            result = String.valueOf(Maths.acosRadToGrad(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals("csc-\u00b9") || name.equals("acsc")) {
                            result = String.valueOf(Maths.asinRadToGrad(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals("cot-\u00b9") || name.equals("acot")) {
                            result = String.valueOf(Maths.atanRadToGrad(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals("sech-\u00b9") || name.equals("asech")) {
                            result = String.valueOf(Maths.asech(Double.parseDouble(list.get(0))));
                        } else if (name.equals("csch-\u00b9") || name.equals("acsch")) {
                            result = String.valueOf(Maths.acsch(Double.parseDouble(list.get(0))));
                        } else if (name.equals("coth-\u00b9") || name.equals("acoth")) {
                            result = String.valueOf(Maths.acoth(Double.parseDouble(list.get(0))));
                        } else if (name.equals("lg-\u00b9") || name.equals("alg")) {
                            result = String.valueOf(Math.pow(10.0, Double.valueOf(list.get(0))));
                        } else if (name.equals("ceil")) {
                            result = String.valueOf(Math.ceil(Double.valueOf(list.get(0))));
                        } else if (name.equals("floor")) {
                            result = String.valueOf(Math.floor(Double.valueOf(list.get(0))));
                        } else if (name.equals("sqrt")) {
                            result = String.valueOf(Math.sqrt(Double.valueOf(list.get(0))));
                        } else if (name.equals("cbrt")) {
                            result = String.valueOf(Math.cbrt(Double.valueOf(list.get(0))));
                        } else if (name.equals("square")) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(val * val);
                        } else if (name.equals("cube")) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(val * val * val);
                        } else if (name.equals("inverse")) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(1.0 / val);
                        } else if (name.equals("fact")) {
                            result = Maths.fact(list.get(0));
                        }
                        list.clear();
                        list.add(result);
                        return list;
                    }
                } else if (list.get(0).equals("Infinity")) {
                    list.add("Infinity");
                    return list;
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            list.add("Syntax Error!");
            return list;
        }
        throw new IllegalArgumentException(" Unknown function: " + name);
    }

    public static boolean isUnaryPreOperatorORDefinedMethod(String methodName) {
        return Method.isDefinedMethod(methodName) || Operator.isUnaryPreOperator(methodName);
    }

    public static boolean isDefinedMethod(String methodName) {
        return Method.arrayContains(Declarations.getInbuiltMethods(), methodName) || FunctionManager.contains(methodName);
    }

    public static boolean isInBuiltMethod(String methodName) {
        return Method.arrayContains(Declarations.getInbuiltMethods(), methodName);
    }

    public static boolean arrayContains(String[] array, String str) {
        for (String s : array) {
            if (!s.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMethodName(String name) {
        try {
            String end = "";
            if (name.equals("-\u00b9")) {
                return false;
            }
            if (name.endsWith("-\u00b9") && !name.equals("-\u00b9")) {
                end = "-\u00b9";
                name = name.substring(0, name.length() - 2);
            }
            if (Method.isMethodNameBeginner(name.substring(0, 1))) {
                int len = name.length();
                for (int i = 0; i < len; ++i) {
                    if (Method.isMethodNameBuilder(name.substring(i, i + 1))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (IndexOutOfBoundsException | NullPointerException boundsException) {
            return false;
        }
    }

    public static boolean isMethodNameBuilder(String name) {
        return Method.isMethodNameBeginner(name) || STRING.isDigit(name);
    }

    public static boolean isMethodNameBeginner(String name) {
        return !Operator.isPermOrComb(name) && Character.isLetter(name.toCharArray()[0]) || name.equals("_") || name.equals("$");
    }

    public String toString() {
        String out = this.name.concat("(");
        int sz = this.parameters.length;
        for (int i = 0; i < sz; ++i) {
            out = out.concat(this.parameters[i].concat(","));
        }
        out = out.substring(0, out.length());
        out = out.concat(")");
        return out;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Method) {
            Method m = (Method)obj;
            return m.name.equals(this.name) && m.parameters.length == this.parameters.length;
        }
        return false;
    }

    private static String[] join(String[] arr1, String[] arr2) {
        String[] larger = new String[arr1.length + arr2.length];
        int len = larger.length;
        int subLen1 = arr1.length;
        int subLen2 = arr2.length;
        for (int i = 0; i < len; ++i) {
            larger[i] = i < subLen1 ? arr1[i] : arr2[i];
        }
        return larger;
    }

    private static boolean isHardcodedStatsMethod(String op) {
        for (String x : Declarations.getStatsMethods()) {
            if (!x.equals(op)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStatsMethod(String expr) {
        CustomScanner cs = new CustomScanner(expr, true, Declarations.getStatsMethods());
        List<String> scan = cs.scan();
        int size = scan.size();
        for (int i = 0; i < size; ++i) {
            try {
                if (!Method.isStatsMethod(scan.get(i)) || !scan.get(i + 1).startsWith("(")) continue;
                return true;
            }
            catch (IndexOutOfBoundsException boundsException) {
                return false;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        Method m = new Method("F(x,y,z)");
        System.out.println(Method.isMethodName("F"));
        System.out.println(Method.isMethodNameBeginner("\u010c"));
        StringBuilder builder = new StringBuilder();
        for (String name : Declarations.getInbuiltMethods()) {
            builder.append(name).append(",");
        }
        System.out.println(builder);
    }
}

