/*
 * Decompiled with CFR 0.152.
 */
package parser.methods;

import parser.methods.BasicNumericalMethod;
import parser.methods.Declarations;

public class Help {
    public static String getHelp() {
        StringBuilder sb = new StringBuilder();
        sb.append("List of currently known methods:").append("\n");
        for (String op : Declarations.getInbuiltMethods()) {
            sb.append(Help.getHelp(op)).append("\n");
        }
        sb.append("List of functions is just tip of iceberg, see: https://github.com/gbenroscience/ParserNG for all features").append("\n");
        return sb.toString();
    }

    public static String getHelp(String op) {
        for (BasicNumericalMethod basicNumericalMethod : Declarations.getBasicNumericalMethods()) {
            if (!op.equals(basicNumericalMethod.getName())) continue;
            return basicNumericalMethod.getHelp();
        }
        switch (op) {
            case "sum": {
                return Help.toLine(op, "Returns sum of all values. Eg: " + op + "(1,2) will evaluate as 1+2 to 3");
            }
            case "prod": {
                return Help.toLine(op, "product of all elements. s. Eg: " + op + "(1,2) will evaluate 1*2 to 2");
            }
            case "geom": {
                return Help.toLine(op, "returns geometrical average of elements. s. Eg: " + op + "(1,2,4) will evaluate (1*2*4)^1/3 thus na 8^1/3 thus to 2");
            }
            case "gsum": {
                return Help.toLine(op, "product of all elements. s. Eg: " + op + "(1,2) will evaluate 1*2 to 2");
            }
            case "count": {
                return Help.toLine(op, "number of elements in the function. Eg: " + op + "(1,1.1) will evaluate 3");
            }
            case "avg": {
                return Help.toLine(op, "avarage of all elements. s. Eg: " + op + "(1,2) will evaluate (1*2)/2 to 0.5");
            }
            case "med": {
                return Help.toLine(op, "median from set. s. Eg: " + op + "(1,2,3) will evaluate as 2");
            }
        }
        return Help.toLine(op, "help not yet written. See https://github.com/gbenroscience/ParserNG");
    }

    static String align(String op) {
        for (String s : Declarations.getInbuiltMethods()) {
            while (s.length() > op.length()) {
                op = op + " ";
            }
        }
        return op;
    }

    public static String toLine(String op, String text) {
        return Help.align(op) + " - " + text;
    }
}

